/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.debug.MessageConsumer;
import processing.app.debug.MessageSiphon;
import processing.app.debug.MessageStream;
import processing.app.debug.RunnerException;
import processing.app.debug.Target;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compiler
implements MessageConsumer {
    static Logger logger = Logger.getLogger((String)Base.class.getName());
    static final String BUGS_URL = "http://code.google.com/p/arduino/issues/list";
    static final String SUPER_BADNESS = "Compiler error, please submit this code to http://code.google.com/p/arduino/issues/list";
    Sketch sketch;
    String buildPath;
    String primaryClassName;
    String platform;
    boolean verbose;
    String board;
    RunnerException exception;
    HashMap<String, String> configPreferences;
    Map<String, String> boardPreferences;
    Map<String, String> platformPreferences;
    Map<String, String> sketchPreferences;
    String avrBasePath;
    String corePath;
    List<File> objectFiles;
    ArrayList<String> includePaths;
    boolean firstErrorFound;
    boolean secondErrorFound;

    public Compiler() {
        logger.debug((Object)"DEBUG: Compiler(): Start no arguments");
    }

    public boolean compile(Sketch sketch, String buildPath, String primaryClassName, boolean verbose) throws RunnerException {
        Target t;
        String core;
        logger.debug((Object)"DEBUG: Compiler.java: Start Compile(...).");
        this.sketch = sketch;
        this.buildPath = buildPath;
        this.primaryClassName = primaryClassName;
        this.verbose = verbose;
        MessageStream pms = new MessageStream(this);
        this.boardPreferences = new HashMap<String, String>(Base.getBoardPreferences());
        String buildCore = this.boardPreferences.get("build.core");
        if (buildCore == null) {
            RunnerException re = new RunnerException("No board selected; please choose a board from the Tools > Board menu.");
            re.hideStackTrace();
            throw re;
        }
        this.platform = this.boardPreferences.get("platform");
        this.platformPreferences = this.platform == null ? new HashMap<String, String>(Base.getPlatformPreferences()) : new HashMap<String, String>(Base.getPlatformPreferences(this.platform));
        File sketchFolder = sketch.getFolder();
        this.sketchPreferences = Base.getSketchPreferences(sketchFolder);
        this.configPreferences = this.mergePreferences(Preferences.getMap(), this.platformPreferences, this.boardPreferences, this.sketchPreferences);
        this.avrBasePath = this.configPreferences.get("compiler.path");
        logger.debug((Object)("avrBasePath: " + this.avrBasePath));
        if (this.avrBasePath == null) {
            this.avrBasePath = Base.getAvrBasePath();
        } else {
            MessageFormat compileFormat = new MessageFormat(this.avrBasePath);
            String basePath = System.getProperty("user.dir");
            if (Base.isMacOS()) {
                logger.debug((Object)("basePath: " + basePath));
                basePath = basePath + "/mpide.app/Contents/Resources/Java";
            }
            Object[] Args = new Object[]{basePath};
            this.avrBasePath = compileFormat.format(Args);
        }
        this.board = this.configPreferences.get("board");
        if (this.board == "") {
            this.board = "_UNKNOWN";
        }
        if ((core = this.configPreferences.get("build.core")) == null) {
            RunnerException re = new RunnerException("No board selected; please choose a board from the Tools > Board menu.");
            re.hideStackTrace();
            throw re;
        }
        if (core.indexOf(58) == -1) {
            t = Base.getTarget();
            File coreFolder = new File(new File(t.getFolder(), "cores"), core);
            this.corePath = coreFolder.getAbsolutePath();
        } else {
            t = Base.targetsTable.get(core.substring(0, core.indexOf(58)));
            File coresFolder = new File(t.getFolder(), "cores");
            File coreFolder = new File(coresFolder, core.substring(core.indexOf(58) + 1));
            this.corePath = coreFolder.getAbsolutePath();
        }
        logger.debug((Object)("corePaths: " + this.corePath));
        String variant = this.boardPreferences.get("build.variant");
        String variantPath = null;
        if (variant != null) {
            Target t2;
            if (variant.indexOf(58) == -1) {
                t2 = Base.getTarget();
                variantPath = t2.getVariantFolder(variant).getAbsolutePath();
            } else {
                t2 = Base.targetsTable.get(variant.substring(0, variant.indexOf(58)));
                variantPath = t2.getVariantFolder(variant).getAbsolutePath();
            }
        }
        logger.debug((Object)("Variant Path: " + variantPath));
        this.objectFiles = new ArrayList<File>();
        logger.debug((Object)"0. getIncludes");
        sketch.setCompilingProgress(20);
        this.includePaths = this.getIncludes(this.corePath);
        if (variantPath != null) {
            this.includePaths.add(variantPath);
        }
        for (File file : sketch.getImportedLibraries()) {
            this.includePaths.add(file.getPath());
        }
        logger.debug((Object)"1. compileSketch");
        this.compileSketch(this.avrBasePath, buildPath, this.includePaths, this.configPreferences);
        sketch.setCompilingProgress(30);
        logger.debug((Object)"2. compileLibraries");
        this.compileLibraries(this.avrBasePath, buildPath, this.includePaths, this.configPreferences);
        sketch.setCompilingProgress(40);
        logger.debug((Object)"3. compileCore");
        this.compileCore(this.avrBasePath, buildPath, this.corePath, variant, variantPath, this.configPreferences);
        sketch.setCompilingProgress(50);
        logger.debug((Object)"4. compileLink");
        this.compileLink(this.avrBasePath, buildPath, this.corePath, this.includePaths, this.configPreferences);
        sketch.setCompilingProgress(60);
        logger.debug((Object)"5. compileEep");
        this.compileEep(this.avrBasePath, buildPath, this.includePaths, this.configPreferences);
        sketch.setCompilingProgress(70);
        logger.debug((Object)"6. compileHex");
        sketch.setCompilingProgress(80);
        this.compileHex(this.avrBasePath, buildPath, this.includePaths, this.configPreferences);
        sketch.setCompilingProgress(90);
        logger.debug((Object)"7. compile done");
        return true;
    }

    private List<File> compileFiles(String avrBasePath, String buildPath, ArrayList<String> includePaths, List<File> sSources, List<File> cSources, List<File> cppSources, HashMap<String, String> configPreferences) throws RunnerException {
        String objectPath;
        ArrayList<File> objectPaths = new ArrayList<File>();
        for (File file : sSources) {
            objectPath = buildPath + File.separator + file.getName() + ".o";
            objectPaths.add(new File(objectPath));
            this.execAsynchronously(Compiler.getCommandCompilerS(avrBasePath, includePaths, file.getAbsolutePath(), objectPath, configPreferences));
        }
        for (File file : cSources) {
            objectPath = buildPath + File.separator + file.getName() + ".o";
            objectPaths.add(new File(objectPath));
            this.execAsynchronously(this.getCommandCompilerC(avrBasePath, includePaths, file.getAbsolutePath(), objectPath, configPreferences));
        }
        for (File file : cppSources) {
            objectPath = buildPath + File.separator + file.getName() + ".o";
            objectPaths.add(new File(objectPath));
            this.execAsynchronously(Compiler.getCommandCompilerCPP(avrBasePath, includePaths, file.getAbsolutePath(), objectPath, configPreferences));
        }
        return objectPaths;
    }

    private void execAsynchronously(String command) throws RunnerException {
        Process process;
        logger.debug((Object)"execAsynchronously: start");
        String[] commandArray = command.split("::");
        ArrayList<String> stringList = new ArrayList<String>();
        for (String string : commandArray) {
            if ((string = string.trim()) == null || string.length() <= 0) continue;
            stringList.add(string);
        }
        commandArray = stringList.toArray(new String[stringList.size()]);
        int result = 0;
        if (this.verbose || Preferences.getBoolean("build.verbose")) {
            System.out.print(command.replace(":", " "));
            System.out.println();
        }
        this.firstErrorFound = false;
        this.secondErrorFound = false;
        try {
            process = Runtime.getRuntime().exec(commandArray);
        }
        catch (IOException e) {
            RunnerException re = new RunnerException(e.getMessage());
            re.hideStackTrace();
            throw re;
        }
        MessageSiphon in = new MessageSiphon(process.getInputStream(), this);
        MessageSiphon err = new MessageSiphon(process.getErrorStream(), this);
        boolean running = true;
        while (running) {
            try {
                if (in.thread != null) {
                    in.thread.join();
                }
                if (err.thread != null) {
                    err.thread.join();
                }
                result = process.waitFor();
                running = false;
            }
            catch (InterruptedException ignored) {}
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (result > 1) {
            System.err.println(command + " returned " + result);
        }
        if (result != 0) {
            RunnerException re = new RunnerException("Error running.");
            re.hideStackTrace();
            throw re;
        }
    }

    @Override
    public void message(String s) {
        String errorFormat;
        String[] pieces;
        if (!this.verbose) {
            int i;
            while ((i = s.indexOf(this.buildPath + File.separator)) != -1) {
                s = s.substring(0, i) + s.substring(i + (this.buildPath + File.separator).length());
            }
        }
        if ((pieces = PApplet.match(s, errorFormat = "([\\w\\d_]+.\\w+):(\\d+):\\s*error:\\s*(.*)\\s*")) != null) {
            RunnerException e = this.sketch.placeException(pieces[3], pieces[1], PApplet.parseInt(pieces[2]) - 1);
            if (e != null && !this.verbose) {
                SketchCode code = this.sketch.getCode(e.getCodeIndex());
                String fileName = code.isExtension(this.sketch.getDefaultExtension()) ? code.getPrettyName() : code.getFileName();
                s = fileName + ":" + e.getCodeLine() + ": error: " + e.getMessage();
            }
            if (pieces[3].trim().equals("SPI.h: No such file or directory")) {
                e = new RunnerException("Please import the SPI library from the Sketch > Import Library menu.");
                s = s + "\nAs of Arduino 0019, the Ethernet library depends on the SPI library.\nYou appear to be using it or another library that depends on the SPI library.";
            }
            if (this.exception == null && e != null) {
                this.exception = e;
                this.exception.hideStackTrace();
            }
        }
        System.err.print(s);
    }

    private static String getCommandCompilerS(String avrBasePath, ArrayList<String> includePaths, String sourceName, String objectName, HashMap<String, String> configPreferences) {
        logger.debug((Object)"getCommandCompilerS: start");
        String baseCommandString = configPreferences.get("recipe.cpp.o.pattern");
        MessageFormat compileFormat = new MessageFormat(baseCommandString);
        String includes = Compiler.preparePaths(includePaths);
        Object[] Args = new Object[]{avrBasePath, configPreferences.get("compiler.cpp.cmd"), configPreferences.get("compiler.S.flags"), configPreferences.get("compiler.cpudef"), configPreferences.get("build.mcu"), configPreferences.get("build.f_cpu"), configPreferences.get("software") + "=" + (configPreferences.get("core.version") != null ? (Serializable)((Object)configPreferences.get("core.version")) : Integer.valueOf(150)), configPreferences.get("board"), configPreferences.get("compiler.define") + " " + configPreferences.get("board.define"), includes, sourceName, objectName};
        return compileFormat.format(Args);
    }

    private String getCommandCompilerC(String avrBasePath, ArrayList<String> includePaths, String sourceName, String objectName, HashMap<String, String> configPreferences) {
        logger.debug((Object)"getCommandCompilerC: start");
        String baseCommandString = configPreferences.get("recipe.c.o.pattern");
        MessageFormat compileFormat = new MessageFormat(baseCommandString);
        String includes = Compiler.preparePaths(includePaths);
        Object[] Args = new Object[]{avrBasePath, configPreferences.get("compiler.c.cmd"), configPreferences.get("compiler.c.flags"), configPreferences.get("compiler.cpudef"), configPreferences.get("build.mcu"), configPreferences.get("build.f_cpu"), configPreferences.get("software") + "=" + (configPreferences.get("core.version") != null ? (Serializable)((Object)configPreferences.get("core.version")) : Integer.valueOf(150)), configPreferences.get("board"), configPreferences.get("compiler.define") + " " + configPreferences.get("board.define"), includes, sourceName, objectName};
        return compileFormat.format(Args);
    }

    private static String getCommandCompilerCPP(String avrBasePath, ArrayList<String> includePaths, String sourceName, String objectName, HashMap<String, String> configPreferences) {
        logger.debug((Object)"getCommandCompilerCPP: start");
        String baseCommandString = configPreferences.get("recipe.cpp.o.pattern");
        MessageFormat compileFormat = new MessageFormat(baseCommandString);
        String includes = Compiler.preparePaths(includePaths);
        logger.debug((Object)("Source: " + sourceName));
        Object[] Args = new Object[]{avrBasePath, configPreferences.get("compiler.cpp.cmd"), configPreferences.get("compiler.cpp.flags"), configPreferences.get("compiler.cpudef"), configPreferences.get("build.mcu"), configPreferences.get("build.f_cpu"), configPreferences.get("software") + "=" + (configPreferences.get("core.version") != null ? (Serializable)((Object)configPreferences.get("core.version")) : Integer.valueOf(150)), configPreferences.get("board"), configPreferences.get("compiler.define") + " " + configPreferences.get("board.define"), includes, sourceName, objectName};
        return compileFormat.format(Args);
    }

    private static void createFolder(File folder) throws RunnerException {
        if (folder.isDirectory()) {
            return;
        }
        if (!folder.mkdir()) {
            throw new RunnerException("Couldn't create: " + folder);
        }
    }

    public static String[] headerListFromIncludePath(String path) {
        FilenameFilter onlyHFiles = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".h");
            }
        };
        return new File(path).list(onlyHFiles);
    }

    public static ArrayList<File> findFilesInPath(String path, String extension, boolean recurse) {
        return Compiler.findFilesInFolder(new File(path), extension, recurse);
    }

    public static ArrayList<File> findFilesInFolder(File folder, String extension, boolean recurse) {
        ArrayList<File> files = new ArrayList<File>();
        if (folder.listFiles() == null) {
            return files;
        }
        for (File file : folder.listFiles()) {
            if (file.getName().startsWith(".")) continue;
            if (file.getName().endsWith("." + extension)) {
                files.add(file);
            }
            if (!recurse || !file.isDirectory()) continue;
            files.addAll(Compiler.findFilesInFolder(file, extension, true));
        }
        return files;
    }

    ArrayList<String> getIncludes(String corePath) {
        logger.debug((Object)("corePath: " + corePath));
        logger.debug((Object)("getSketchFlderPath: " + this.sketch.getFolder().toString()));
        ArrayList<String> includePaths = new ArrayList<String>();
        includePaths.add(this.sketch.getFolder().toString());
        includePaths.add(corePath);
        for (File file : this.sketch.getImportedLibraries()) {
            logger.debug((Object)("getImportedLibraries: " + file.getPath()));
            includePaths.add(file.getPath());
        }
        return includePaths;
    }

    void compileSketch(String avrBasePath, String buildPath, ArrayList<String> includePaths, HashMap<String, String> configPreferences) throws RunnerException {
        logger.debug((Object)"compileSketch: start");
        this.objectFiles.addAll(this.compileFiles(avrBasePath, buildPath, includePaths, Compiler.findFilesInPath(buildPath, "S", false), Compiler.findFilesInPath(buildPath, "c", false), Compiler.findFilesInPath(buildPath, "cpp", false), configPreferences));
    }

    void compileLibraries(String avrBasePath, String buildPath, ArrayList<String> includePaths, HashMap<String, String> configPreferences) throws RunnerException {
        logger.debug((Object)"compileLibraries: start");
        for (File libraryFolder : this.sketch.getImportedLibraries()) {
            File outputFolder = new File(buildPath, libraryFolder.getName());
            File utilityFolder = new File(libraryFolder, "utility");
            Compiler.createFolder(outputFolder);
            this.includePaths.add(utilityFolder.getAbsolutePath());
            this.objectFiles.addAll(this.compileFiles(avrBasePath, outputFolder.getAbsolutePath(), includePaths, Compiler.findFilesInFolder(libraryFolder, "S", false), Compiler.findFilesInFolder(libraryFolder, "c", false), Compiler.findFilesInFolder(libraryFolder, "cpp", false), configPreferences));
            outputFolder = new File(outputFolder, "utility");
            Compiler.createFolder(outputFolder);
            this.objectFiles.addAll(this.compileFiles(avrBasePath, outputFolder.getAbsolutePath(), includePaths, Compiler.findFilesInFolder(utilityFolder, "S", false), Compiler.findFilesInFolder(utilityFolder, "c", false), Compiler.findFilesInFolder(utilityFolder, "cpp", false), configPreferences));
            this.includePaths.remove(includePaths.size() - 1);
        }
    }

    void compileCore(String avrBasePath, String buildPath, String corePath, String variant, String variantPath, HashMap<String, String> configPreferences) throws RunnerException {
        logger.debug((Object)"compileCore(...) start");
        ArrayList<String> includePaths = new ArrayList<String>();
        includePaths.add(corePath);
        if (variantPath != null) {
            includePaths.add(variantPath);
        }
        String baseCommandString = configPreferences.get("recipe.ar.pattern");
        String commandString = "";
        MessageFormat compileFormat = new MessageFormat(baseCommandString);
        List<File> coreObjectFiles = this.compileFiles(avrBasePath, buildPath, includePaths, Compiler.findFilesInPath(corePath, "S", true), Compiler.findFilesInPath(corePath, "c", true), Compiler.findFilesInPath(corePath, "cpp", true), configPreferences);
        for (File file : coreObjectFiles) {
            Object[] Args = new Object[]{avrBasePath, configPreferences.get("compiler.ar.cmd"), configPreferences.get("compiler.ar.flags"), buildPath + File.separator, "core.a", file.getAbsolutePath()};
            commandString = compileFormat.format(Args);
            this.execAsynchronously(commandString);
        }
    }

    void compileLink(String avrBasePath, String buildPath, String corePath, ArrayList<String> includePaths, HashMap<String, String> configPreferences) throws RunnerException {
        String variantPath;
        Target t;
        logger.debug((Object)"compileLink: start");
        String baseCommandString = configPreferences.get("recipe.c.combine.pattern");
        String commandString = "";
        MessageFormat compileFormat = new MessageFormat(baseCommandString);
        String objectFileList = "";
        for (File file : this.objectFiles) {
            objectFileList = objectFileList + file.getAbsolutePath() + "::";
        }
        String variant = configPreferences.get("build.variant");
        if (variant.indexOf(58) == -1) {
            t = Base.getTarget();
            variantPath = t.getVariantFolder(variant).getAbsolutePath();
        } else {
            t = Base.targetsTable.get(variant.substring(0, variant.indexOf(58)));
            variantPath = t.getVariantFolder(variant.substring(0, variant.indexOf(58))).getAbsolutePath();
        }
        String ldscript = configPreferences.get("ldscript");
        String foundPath = null;
        if (ldscript != null) {
            File testFile = null;
            testFile = new File(variantPath, ldscript);
            logger.debug((Object)("Searching for " + variantPath + "/" + ldscript + "..."));
            if (testFile.exists()) {
                logger.debug((Object)"... found");
                foundPath = variantPath;
            } else {
                logger.debug((Object)("Searching for " + corePath + "/" + ldscript + "..."));
                testFile = new File(corePath, ldscript);
                if (testFile.exists()) {
                    logger.debug((Object)"... found");
                    foundPath = corePath;
                }
            }
            if (foundPath == null) {
                System.out.println("Linker script not found: " + ldscript);
                return;
            }
        } else {
            ldscript = "";
            foundPath = "";
        }
        Object[] Args = new Object[]{avrBasePath, configPreferences.get("compiler.c.elf.cmd"), configPreferences.get("compiler.c.elf.flags"), configPreferences.get("compiler.cpudef"), configPreferences.get("build.mcu"), buildPath + File.separator, this.primaryClassName, objectFileList, buildPath + File.separator + "core.a", buildPath, foundPath, configPreferences.get("ldscript") != null ? configPreferences.get("ldscript") : "", corePath, configPreferences.get("ldcommon") != null ? configPreferences.get("ldcommon") : ""};
        commandString = compileFormat.format(Args);
        logger.debug((Object)("Link command: " + commandString));
        this.execAsynchronously(commandString);
    }

    void compileEep(String avrBasePath, String buildPath, ArrayList<String> includePaths, HashMap<String, String> configPreferences) throws RunnerException {
        logger.debug((Object)"compileEep: start");
        String baseCommandString = configPreferences.get("recipe.objcopy.eep.pattern");
        String commandString = "";
        MessageFormat compileFormat = new MessageFormat(baseCommandString);
        String objectFileList = "";
        Object[] Args = new Object[]{avrBasePath, configPreferences.get("compiler.objcopy.cmd"), configPreferences.get("compiler.objcopy.eep.flags"), buildPath + File.separator + this.primaryClassName, buildPath + File.separator + this.primaryClassName};
        commandString = compileFormat.format(Args);
        this.execAsynchronously(commandString);
    }

    void compileHex(String avrBasePath, String buildPath, ArrayList<String> includePaths, HashMap<String, String> configPreferences) throws RunnerException {
        logger.debug((Object)"compileHex: start");
        String baseCommandString = configPreferences.get("recipe.objcopy.hex.pattern");
        String commandString = "";
        MessageFormat compileFormat = new MessageFormat(baseCommandString);
        String objectFileList = "";
        Object[] Args = new Object[]{avrBasePath, configPreferences.get("compiler.elf2hex.cmd"), configPreferences.get("compiler.elf2hex.flags"), buildPath + File.separator + this.primaryClassName, buildPath + File.separator + this.primaryClassName};
        commandString = compileFormat.format(Args);
        this.execAsynchronously(commandString);
    }

    HashMap mergePreferences(Map Preferences2, Map platformPreferences, Map boardPreferences, Map sketchPreferences) {
        HashMap _map = new HashMap();
        for (Map.Entry pair : Preferences2.entrySet()) {
            if (pair.getValue() == null) {
                _map.put(pair.getKey(), "");
                continue;
            }
            _map.put(pair.getKey(), (String)pair.getValue());
        }
        for (Map.Entry pair : platformPreferences.entrySet()) {
            if (pair.getValue() == null) {
                _map.put(pair.getKey(), "");
                continue;
            }
            _map.put(pair.getKey(), (String)pair.getValue());
        }
        for (Map.Entry pair : boardPreferences.entrySet()) {
            if (pair.getValue() == null) {
                _map.put(pair.getKey(), "");
                continue;
            }
            _map.put(pair.getKey(), (String)pair.getValue());
        }
        for (Map.Entry pair : sketchPreferences.entrySet()) {
            if (pair.getValue() == null) {
                _map.put(pair.getKey(), "");
                continue;
            }
            _map.put(pair.getKey(), (String)pair.getValue());
        }
        return _map;
    }

    private static String preparePaths(ArrayList<String> includePaths) {
        String includes = "";
        for (int i = 0; i < includePaths.size(); ++i) {
            includes = includes + " -I" + includePaths.get(i) + "::";
        }
        return includes;
    }
}

