/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import processing.app.Base;
import processing.app.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Target {
    private String name;
    private File folder;
    private Map boards;
    private Map programmers;
    private Map platforms;
    private Map bootloaders;
    static Logger logger = Logger.getLogger((String)Base.class.getName());

    public Target(String name, File folder) {
        File file;
        File sbhwFolder;
        logger.debug((Object)("Target: initiated: name = " + name + " folder= " + folder.getName()));
        this.name = name;
        this.folder = folder;
        this.boards = new LinkedHashMap();
        this.programmers = new LinkedHashMap();
        this.platforms = new LinkedHashMap();
        this.bootloaders = new LinkedHashMap();
        File boardsFile = new File(folder, "boards.txt");
        try {
            if (boardsFile.exists()) {
                LinkedHashMap boardPreferences = new LinkedHashMap();
                Preferences.load(new FileInputStream(boardsFile), boardPreferences);
                for (Object k : boardPreferences.keySet()) {
                    String key = (String)k;
                    String string = key.substring(0, key.indexOf(46));
                    if (!this.boards.containsKey(string)) {
                        this.boards.put(string, new HashMap());
                    }
                    ((Map)this.boards.get(string)).put(key.substring(key.indexOf(46) + 1), boardPreferences.get(key));
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error loading boards from " + boardsFile + ": " + e);
        }
        File platformsFile = new File(folder, "platforms.txt");
        try {
            if (platformsFile.exists()) {
                LinkedHashMap platformPreferences = new LinkedHashMap();
                Preferences.load(new FileInputStream(platformsFile), platformPreferences);
                for (Object k : platformPreferences.keySet()) {
                    String string = (String)k;
                    String platform = string.substring(0, string.indexOf(46));
                    if (!this.platforms.containsKey(platform)) {
                        this.platforms.put(platform, new HashMap());
                    }
                    ((Map)this.platforms.get(platform)).put(string.substring(string.indexOf(46) + 1), platformPreferences.get(string));
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error loading platforms from " + platformsFile + ": " + e);
        }
        File programmersFile = new File(folder, "programmers.txt");
        try {
            if (programmersFile.exists()) {
                LinkedHashMap programmerPreferences = new LinkedHashMap();
                Preferences.load(new FileInputStream(programmersFile), programmerPreferences);
                for (Object e : programmerPreferences.keySet()) {
                    String key = (String)e;
                    String programmer = key.substring(0, key.indexOf(46));
                    if (!this.programmers.containsKey(programmer)) {
                        this.programmers.put(programmer, new HashMap());
                    }
                    ((Map)this.programmers.get(programmer)).put(key.substring(key.indexOf(46) + 1), programmerPreferences.get(key));
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error loading programmers from " + programmersFile + ": " + e);
        }
        File bootloadersFile = new File(folder, "bootloaders.txt");
        try {
            if (bootloadersFile.exists()) {
                LinkedHashMap bootloaderPreferences = new LinkedHashMap();
                Preferences.load(new FileInputStream(bootloadersFile), bootloaderPreferences);
                for (Object k : bootloaderPreferences.keySet()) {
                    String key = (String)k;
                    String bootloader = key.substring(0, key.indexOf(46));
                    if (!this.bootloaders.containsKey(bootloader)) {
                        this.bootloaders.put(bootloader, new HashMap());
                    }
                    ((Map)this.bootloaders.get(bootloader)).put(key.substring(key.indexOf(46) + 1), bootloaderPreferences.get(key));
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error loading bootloaders from " + bootloadersFile + ": " + e);
        }
        File variantsDir = new File(folder, "variants");
        if (variantsDir.exists() && variantsDir.isDirectory()) {
            logger.debug((Object)"Ok, variants is a directory");
            for (File child : variantsDir.listFiles()) {
                if (!child.isDirectory()) continue;
                File variantBoardsFile = new File(child, "boards.txt");
                try {
                    if (variantBoardsFile.exists()) {
                        LinkedHashMap boardPreferences = new LinkedHashMap();
                        Preferences.load(new FileInputStream(variantBoardsFile), boardPreferences);
                        for (Object k : boardPreferences.keySet()) {
                            String key = (String)k;
                            String board = key.substring(0, key.indexOf(46));
                            if (!this.boards.containsKey(board)) {
                                this.boards.put(board, new HashMap());
                            }
                            ((Map)this.boards.get(board)).put(key.substring(key.indexOf(46) + 1), boardPreferences.get(key));
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println("Error loading boards from " + variantBoardsFile + ": " + e);
                }
                File variantBootloadersFile = new File(child, "bootloaders.txt");
                try {
                    Object k;
                    if (!variantBootloadersFile.exists()) continue;
                    LinkedHashMap bootloaderPreferences = new LinkedHashMap();
                    Preferences.load(new FileInputStream(variantBootloadersFile), bootloaderPreferences);
                    k = bootloaderPreferences.keySet().iterator();
                    while (k.hasNext()) {
                        Object k2 = k.next();
                        String key = (String)k2;
                        String bootloader = key.substring(0, key.indexOf(46));
                        if (!this.bootloaders.containsKey(bootloader)) {
                            this.bootloaders.put(bootloader, new HashMap());
                        }
                        logger.debug((Object)("Adding variant bootloader [" + bootloader + "] = " + key.substring(key.indexOf(46) + 1) + ", " + bootloaderPreferences.get(key)));
                        ((Map)this.bootloaders.get(bootloader)).put(key.substring(key.indexOf(46) + 1), bootloaderPreferences.get(key));
                    }
                }
                catch (Exception e) {
                    System.err.println("Error loading bootloaders from " + variantBootloadersFile + ": " + e);
                }
            }
        }
        if ((sbhwFolder = new File(file = Base.getSketchbookHardwareFolder(), folder.getName())).exists()) {
            logger.debug((Object)"SBHW OK");
            variantsDir = new File(sbhwFolder, "variants");
            if (variantsDir.exists() && variantsDir.isDirectory()) {
                logger.debug((Object)("Scanning extra dir " + file.getName() + "/" + sbhwFolder.getName() + "/" + variantsDir.getName()));
                for (File child : variantsDir.listFiles()) {
                    if (!child.isDirectory()) continue;
                    File variantBoardsFile = new File(child, "boards.txt");
                    try {
                        if (variantBoardsFile.exists()) {
                            LinkedHashMap boardPreferences = new LinkedHashMap();
                            Preferences.load(new FileInputStream(variantBoardsFile), boardPreferences);
                            for (Object k : boardPreferences.keySet()) {
                                String key = (String)k;
                                String board = key.substring(0, key.indexOf(46));
                                if (!this.boards.containsKey(board)) {
                                    this.boards.put(board, new HashMap());
                                }
                                ((Map)this.boards.get(board)).put(key.substring(key.indexOf(46) + 1), boardPreferences.get(key));
                            }
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Error loading boards from " + variantBoardsFile + ": " + e);
                    }
                    File variantBootloadersFile = new File(child, "bootloaders.txt");
                    try {
                        if (!variantBootloadersFile.exists()) continue;
                        LinkedHashMap bootloaderPreferences = new LinkedHashMap();
                        Preferences.load(new FileInputStream(variantBootloadersFile), bootloaderPreferences);
                        for (Object k : bootloaderPreferences.keySet()) {
                            String key = (String)k;
                            String bootloader = key.substring(0, key.indexOf(46));
                            if (!this.bootloaders.containsKey(bootloader)) {
                                this.bootloaders.put(bootloader, new HashMap());
                            }
                            ((Map)this.bootloaders.get(bootloader)).put(key.substring(key.indexOf(46) + 1), bootloaderPreferences.get(key));
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Error loading bootloaders from " + variantBootloadersFile + ": " + e);
                    }
                }
            }
        }
    }

    public File getVariantFolder(String variant) {
        File variantFolder = null;
        if (variant != null) {
            if (variant.indexOf(58) == -1) {
                File sketchVariantsFolder;
                File sketchTargetFolder;
                File sketchHardwareFolder = Base.getSketchbookHardwareFolder();
                if (sketchHardwareFolder.exists() && sketchHardwareFolder.isDirectory() && (sketchTargetFolder = new File(sketchHardwareFolder, this.name)).exists() && sketchTargetFolder.isDirectory() && (sketchVariantsFolder = new File(sketchTargetFolder, "variants")).exists() && sketchVariantsFolder.isDirectory()) {
                    variantFolder = new File(sketchVariantsFolder, variant);
                }
                if (variantFolder == null) {
                    variantFolder = new File(new File(this.folder, "variants"), variant);
                }
            } else {
                File sketchVariantsFolder;
                File sketchTargetFolder;
                Target t = Base.targetsTable.get(variant.substring(0, variant.indexOf(58)));
                File sketchHardwareFolder = Base.getSketchbookHardwareFolder();
                if (sketchHardwareFolder.exists() && sketchHardwareFolder.isDirectory() && (sketchTargetFolder = new File(sketchHardwareFolder, this.name)).exists() && sketchTargetFolder.isDirectory() && (sketchVariantsFolder = new File(sketchTargetFolder, "variants")).exists() && sketchVariantsFolder.isDirectory()) {
                    variantFolder = new File(sketchVariantsFolder, variant.substring(variant.indexOf(58) + 1));
                }
                if (variantFolder == null) {
                    variantFolder = new File(new File(this.folder, "variants"), variant.substring(variant.indexOf(58) + 1));
                }
            }
        }
        return variantFolder;
    }

    public String getName() {
        return this.name;
    }

    public File getFolder() {
        return this.folder;
    }

    public Map<String, Map<String, String>> getBoards() {
        logger.debug((Object)("Target: getBoards(): " + this.name));
        return this.boards;
    }

    public Map<String, Map<String, String>> getProgrammers() {
        logger.debug((Object)("Target: getProgrammers() for: " + this.name));
        return this.programmers;
    }

    public Map<String, Map<String, String>> getPlatforms() {
        logger.debug((Object)("Target: getPlatforms(): " + this.name));
        return this.platforms;
    }

    public Map<String, Map<String, String>> getBootloaders() {
        logger.debug((Object)("Target: getBootloaders(): " + this.name));
        return this.bootloaders;
    }

    public Map<String, String> getSketchPreferences(File folder) {
        LinkedHashMap<String, String> sketchprefs = new LinkedHashMap<String, String>();
        File sketchprefsFile = new File(folder, "preferences.txt");
        try {
            if (sketchprefsFile.exists()) {
                LinkedHashMap sketchPreferences = new LinkedHashMap();
                Preferences.load(new FileInputStream(sketchprefsFile), sketchPreferences);
                for (Object k : sketchPreferences.keySet()) {
                    String key = (String)k;
                    String sketchpref = key.substring(0, key.indexOf(46));
                    if (!sketchprefs.containsKey(sketchprefs)) {
                        sketchprefs.put((String)((Object)sketchprefs), (String)((Object)new HashMap()));
                    }
                    ((Map)sketchprefs.get(sketchpref)).put(key.substring(key.indexOf(46) + 1), sketchPreferences.get(key));
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error loading sketchprefs from " + sketchprefsFile + ": " + e);
        }
        logger.debug((Object)("Target: getSketchPreferences() for: " + this.name));
        return sketchprefs;
    }
}

