/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.MouseEvent;
import sun.awt.dnd.SunDragSourceContextPeer;

class WMouseDragGestureRecognizer
extends MouseDragGestureRecognizer {
    private static final long serialVersionUID = -3527844310018033570L;
    protected static int motionThreshold;
    protected static final int ButtonMask = 7168;

    protected WMouseDragGestureRecognizer(DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
        super(dragSource, component, n, dragGestureListener);
    }

    protected WMouseDragGestureRecognizer(DragSource dragSource, Component component, int n) {
        this(dragSource, component, n, null);
    }

    protected WMouseDragGestureRecognizer(DragSource dragSource, Component component) {
        this(dragSource, component, 0);
    }

    protected WMouseDragGestureRecognizer(DragSource dragSource) {
        this(dragSource, null);
    }

    protected int mapDragOperationFromModifiers(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiersEx();
        int n2 = n & 0x1C00;
        if (n2 != 1024 && n2 != 2048 && n2 != 4096) {
            return 0;
        }
        return SunDragSourceContextPeer.convertModifiersToDropAction(n, this.getSourceActions());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.events.clear();
        if (this.mapDragOperationFromModifiers(mouseEvent) != 0) {
            try {
                motionThreshold = DragSource.getDragThreshold();
            }
            catch (Exception exception) {
                motionThreshold = 5;
            }
            this.appendEvent(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.events.clear();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.events.clear();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        int n;
        if (!this.events.isEmpty() && (n = this.mapDragOperationFromModifiers(mouseEvent)) == 0) {
            this.events.clear();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.events.isEmpty()) {
            int n = this.mapDragOperationFromModifiers(mouseEvent);
            if (n == 0) {
                return;
            }
            MouseEvent mouseEvent2 = (MouseEvent)this.events.get(0);
            Point point = mouseEvent2.getPoint();
            Point point2 = mouseEvent.getPoint();
            int n2 = Math.abs(point.x - point2.x);
            int n3 = Math.abs(point.y - point2.y);
            if (n2 > motionThreshold || n3 > motionThreshold) {
                this.fireDragGestureRecognized(n, ((MouseEvent)this.getTriggerEvent()).getPoint());
            } else {
                this.appendEvent(mouseEvent);
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

