;Delay routines for an 8 MHz clock
;
delay_us:	;Delay for 1-255 microseconds given by r16
;On entry, r16 is the delay in microseconds
;Registers destroyed: r16
DlyUs:
	nop
	nop
	nop
	nop
	nop
	dec r16
	brne DlyUs
	ret

delay_ms:	;Delay for 1-255 milliseconds given by r16
;On entry, r16 is the delay in milliseconds
;Registers destroyed: r16
	push r17
	mov r17, r16
DlyMs:
	ldi r16, 250
	rcall delay_us
	ldi r16, 250
	rcall delay_us
	ldi r16, 250
	rcall delay_us
	ldi r16, 248
	rcall delay_us
	dec r17
	brne DlyMs
	pop r17
	ret

delay_100us:	;Delay for 1-255 * 100 microseconds given by r16
;On entry, r16 is the delay in hundreds of microseconds
;Registers destroyed: r16
	push r17
	mov r17, r16
Dly100:
	ldi r16, 100
	rcall delay_us
	dec r17
	brne Dly100
	pop r17
	ret
