/*******************************************************************************
* File Name: CAL_IN.c  
* Version 1.50
*
* Description:
*  This file contains API to enable firmware control of a Pins component.
*
* Note:
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#include "cytypes.h"
#include "CAL_IN.h"


/*******************************************************************************
* Function Name: CAL_IN_Write
********************************************************************************
* Summary:
*  Assign a new value to the digital port's data output register.  
*
* Parameters:  
*  prtValue:  The value to be assigned to the Digital Port. 
*
* Return: 
*  void 
*  
*******************************************************************************/
void CAL_IN_Write(uint8 value) 
{
    uint8 staticBits = CAL_IN_DR & ~CAL_IN_MASK;
    CAL_IN_DR = staticBits | ((value << CAL_IN_SHIFT) & CAL_IN_MASK);
}


/*******************************************************************************
* Function Name: CAL_IN_SetDriveMode
********************************************************************************
* Summary:
*  Change the drive mode on the pins of the port.
* 
* Parameters:  
*  mode:  Change the pins to this drive mode.
*
* Return: 
*  void
*
*******************************************************************************/
void CAL_IN_SetDriveMode(uint8 mode) 
{
	CyPins_SetPinDriveMode(CAL_IN_0, mode);
}


/*******************************************************************************
* Function Name: CAL_IN_Read
********************************************************************************
* Summary:
*  Read the current value on the pins of the Digital Port in right justified 
*  form.
*
* Parameters:  
*  void 
*
* Return: 
*  Returns the current value of the Digital Port as a right justified number
*  
* Note:
*  Macro CAL_IN_ReadPS calls this function. 
*  
*******************************************************************************/
uint8 CAL_IN_Read(void) 
{
    return (CAL_IN_PS & CAL_IN_MASK) >> CAL_IN_SHIFT;
}


/*******************************************************************************
* Function Name: CAL_IN_ReadDataReg
********************************************************************************
* Summary:
*  Read the current value assigned to a Digital Port's data output register
*
* Parameters:  
*  void 
*
* Return: 
*  Returns the current value assigned to the Digital Port's data output register
*  
*******************************************************************************/
uint8 CAL_IN_ReadDataReg(void) 
{
    return (CAL_IN_DR & CAL_IN_MASK) >> CAL_IN_SHIFT;
}


/* If Interrupts Are Enabled for this Pins component */ 
#if defined(CAL_IN_INTSTAT) 

    /*******************************************************************************
    * Function Name: CAL_IN_ClearInterrupt
    ********************************************************************************
    * Summary:
    *  Clears any active interrupts attached to port and returns the value of the 
    *  interrupt status register.
    *
    * Parameters:  
    *  void 
    *
    * Return: 
    *  Returns the value of the interrupt status register
    *  
    *******************************************************************************/
    uint8 CAL_IN_ClearInterrupt(void) 
    {
        return (CAL_IN_INTSTAT & CAL_IN_MASK) >> CAL_IN_SHIFT;
    }

#endif /* If Interrupts Are Enabled for this Pins component */ 


/* [] END OF FILE */ 
