/*******************************************************************************
* File Name: ICLK.c  
* Version 1.50
*
* Description:
*  This file contains API to enable firmware control of a Pins component.
*
* Note:
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#include "cytypes.h"
#include "ICLK.h"


/*******************************************************************************
* Function Name: ICLK_Write
********************************************************************************
* Summary:
*  Assign a new value to the digital port's data output register.  
*
* Parameters:  
*  prtValue:  The value to be assigned to the Digital Port. 
*
* Return: 
*  void 
*  
*******************************************************************************/
void ICLK_Write(uint8 value) 
{
    uint8 staticBits = ICLK_DR & ~ICLK_MASK;
    ICLK_DR = staticBits | ((value << ICLK_SHIFT) & ICLK_MASK);
}


/*******************************************************************************
* Function Name: ICLK_SetDriveMode
********************************************************************************
* Summary:
*  Change the drive mode on the pins of the port.
* 
* Parameters:  
*  mode:  Change the pins to this drive mode.
*
* Return: 
*  void
*
*******************************************************************************/
void ICLK_SetDriveMode(uint8 mode) 
{
	CyPins_SetPinDriveMode(ICLK_0, mode);
}


/*******************************************************************************
* Function Name: ICLK_Read
********************************************************************************
* Summary:
*  Read the current value on the pins of the Digital Port in right justified 
*  form.
*
* Parameters:  
*  void 
*
* Return: 
*  Returns the current value of the Digital Port as a right justified number
*  
* Note:
*  Macro ICLK_ReadPS calls this function. 
*  
*******************************************************************************/
uint8 ICLK_Read(void) 
{
    return (ICLK_PS & ICLK_MASK) >> ICLK_SHIFT;
}


/*******************************************************************************
* Function Name: ICLK_ReadDataReg
********************************************************************************
* Summary:
*  Read the current value assigned to a Digital Port's data output register
*
* Parameters:  
*  void 
*
* Return: 
*  Returns the current value assigned to the Digital Port's data output register
*  
*******************************************************************************/
uint8 ICLK_ReadDataReg(void) 
{
    return (ICLK_DR & ICLK_MASK) >> ICLK_SHIFT;
}


/* If Interrupts Are Enabled for this Pins component */ 
#if defined(ICLK_INTSTAT) 

    /*******************************************************************************
    * Function Name: ICLK_ClearInterrupt
    ********************************************************************************
    * Summary:
    *  Clears any active interrupts attached to port and returns the value of the 
    *  interrupt status register.
    *
    * Parameters:  
    *  void 
    *
    * Return: 
    *  Returns the value of the interrupt status register
    *  
    *******************************************************************************/
    uint8 ICLK_ClearInterrupt(void) 
    {
        return (ICLK_INTSTAT & ICLK_MASK) >> ICLK_SHIFT;
    }

#endif /* If Interrupts Are Enabled for this Pins component */ 


/* [] END OF FILE */ 
