/*******************************************************************************
* File Name: ICLK.h  
* Version 1.50
*
* Description:
*  This file containts Control Register function prototypes and register defines
*
* Note:
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#if !defined(CY_PINS_ICLK_H) /* Pins ICLK_H */
#define CY_PINS_ICLK_H

#include "cytypes.h"
#include "cyfitter.h"
#include "cypins.h"
#include "ICLK_aliases.h"


/***************************************
*        Function Prototypes             
***************************************/    

void    ICLK_Write(uint8 value) ;
void    ICLK_SetDriveMode(uint8 mode) ;
uint8   ICLK_ReadDataReg(void) ;
uint8   ICLK_Read(void) ;
uint8   ICLK_ClearInterrupt(void) ;

/***************************************
*           API Constants        
***************************************/

/* Drive Modes */
#define ICLK_DM_ALG_HIZ         PIN_DM_ALG_HIZ
#define ICLK_DM_DIG_HIZ         PIN_DM_DIG_HIZ
#define ICLK_DM_RES_UP          PIN_DM_RES_UP
#define ICLK_DM_RES_DWN         PIN_DM_RES_DWN
#define ICLK_DM_OD_LO           PIN_DM_OD_LO
#define ICLK_DM_OD_HI           PIN_DM_OD_HI
#define ICLK_DM_STRONG          PIN_DM_STRONG
#define ICLK_DM_RES_UPDWN       PIN_DM_RES_UPDWN

/* Digital Port Constants */
#define ICLK_MASK               ICLK__MASK
#define ICLK_SHIFT              ICLK__SHIFT
#define ICLK_WIDTH              1u

/***************************************
*             Registers        
***************************************/

/* Main Port Registers */
/* Pin State */
#define ICLK_PS                     (* (reg8 *) ICLK__PS)
/* Data Register */
#define ICLK_DR                     (* (reg8 *) ICLK__DR)
/* Port Number */
#define ICLK_PRT_NUM                (* (reg8 *) ICLK__PRT) 
/* Connect to Analog Globals */                                                  
#define ICLK_AG                     (* (reg8 *) ICLK__AG)                       
/* Analog MUX bux enable */
#define ICLK_AMUX                   (* (reg8 *) ICLK__AMUX) 
/* Bidirectional Enable */                                                        
#define ICLK_BIE                    (* (reg8 *) ICLK__BIE)
/* Bit-mask for Aliased Register Access */
#define ICLK_BIT_MASK               (* (reg8 *) ICLK__BIT_MASK)
/* Bypass Enable */
#define ICLK_BYP                    (* (reg8 *) ICLK__BYP)
/* Port wide control signals */                                                   
#define ICLK_CTL                    (* (reg8 *) ICLK__CTL)
/* Drive Modes */
#define ICLK_DM0                    (* (reg8 *) ICLK__DM0) 
#define ICLK_DM1                    (* (reg8 *) ICLK__DM1)
#define ICLK_DM2                    (* (reg8 *) ICLK__DM2) 
/* Input Buffer Disable Override */
#define ICLK_INP_DIS                (* (reg8 *) ICLK__INP_DIS)
/* LCD Common or Segment Drive */
#define ICLK_LCD_COM_SEG            (* (reg8 *) ICLK__LCD_COM_SEG)
/* Enable Segment LCD */
#define ICLK_LCD_EN                 (* (reg8 *) ICLK__LCD_EN)
/* Slew Rate Control */
#define ICLK_SLW                    (* (reg8 *) ICLK__SLW)

/* DSI Port Registers */
/* Global DSI Select Register */
#define ICLK_PRTDSI__CAPS_SEL       (* (reg8 *) ICLK__PRTDSI__CAPS_SEL) 
/* Double Sync Enable */
#define ICLK_PRTDSI__DBL_SYNC_IN    (* (reg8 *) ICLK__PRTDSI__DBL_SYNC_IN) 
/* Output Enable Select Drive Strength */
#define ICLK_PRTDSI__OE_SEL0        (* (reg8 *) ICLK__PRTDSI__OE_SEL0) 
#define ICLK_PRTDSI__OE_SEL1        (* (reg8 *) ICLK__PRTDSI__OE_SEL1) 
/* Port Pin Output Select Registers */
#define ICLK_PRTDSI__OUT_SEL0       (* (reg8 *) ICLK__PRTDSI__OUT_SEL0) 
#define ICLK_PRTDSI__OUT_SEL1       (* (reg8 *) ICLK__PRTDSI__OUT_SEL1) 
/* Sync Output Enable Registers */
#define ICLK_PRTDSI__SYNC_OUT       (* (reg8 *) ICLK__PRTDSI__SYNC_OUT) 


#if defined(ICLK__INTSTAT)  /* Interrupt Registers */

    #define ICLK_INTSTAT                (* (reg8 *) ICLK__INTSTAT)
    #define ICLK_SNAP                   (* (reg8 *) ICLK__SNAP)

#endif /* Interrupt Registers */

#endif /* End Pins ICLK_H */


/* [] END OF FILE */
