/*******************************************************************************
* File Name: TEST_INPUT.h  
* Version 1.50
*
* Description:
*  This file containts Control Register function prototypes and register defines
*
* Note:
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#if !defined(CY_PINS_TEST_INPUT_H) /* Pins TEST_INPUT_H */
#define CY_PINS_TEST_INPUT_H

#include "cytypes.h"
#include "cyfitter.h"
#include "cypins.h"
#include "TEST_INPUT_aliases.h"


/***************************************
*        Function Prototypes             
***************************************/    

void    TEST_INPUT_Write(uint8 value) ;
void    TEST_INPUT_SetDriveMode(uint8 mode) ;
uint8   TEST_INPUT_ReadDataReg(void) ;
uint8   TEST_INPUT_Read(void) ;
uint8   TEST_INPUT_ClearInterrupt(void) ;

/***************************************
*           API Constants        
***************************************/

/* Drive Modes */
#define TEST_INPUT_DM_ALG_HIZ         PIN_DM_ALG_HIZ
#define TEST_INPUT_DM_DIG_HIZ         PIN_DM_DIG_HIZ
#define TEST_INPUT_DM_RES_UP          PIN_DM_RES_UP
#define TEST_INPUT_DM_RES_DWN         PIN_DM_RES_DWN
#define TEST_INPUT_DM_OD_LO           PIN_DM_OD_LO
#define TEST_INPUT_DM_OD_HI           PIN_DM_OD_HI
#define TEST_INPUT_DM_STRONG          PIN_DM_STRONG
#define TEST_INPUT_DM_RES_UPDWN       PIN_DM_RES_UPDWN

/* Digital Port Constants */
#define TEST_INPUT_MASK               TEST_INPUT__MASK
#define TEST_INPUT_SHIFT              TEST_INPUT__SHIFT
#define TEST_INPUT_WIDTH              1u

/***************************************
*             Registers        
***************************************/

/* Main Port Registers */
/* Pin State */
#define TEST_INPUT_PS                     (* (reg8 *) TEST_INPUT__PS)
/* Data Register */
#define TEST_INPUT_DR                     (* (reg8 *) TEST_INPUT__DR)
/* Port Number */
#define TEST_INPUT_PRT_NUM                (* (reg8 *) TEST_INPUT__PRT) 
/* Connect to Analog Globals */                                                  
#define TEST_INPUT_AG                     (* (reg8 *) TEST_INPUT__AG)                       
/* Analog MUX bux enable */
#define TEST_INPUT_AMUX                   (* (reg8 *) TEST_INPUT__AMUX) 
/* Bidirectional Enable */                                                        
#define TEST_INPUT_BIE                    (* (reg8 *) TEST_INPUT__BIE)
/* Bit-mask for Aliased Register Access */
#define TEST_INPUT_BIT_MASK               (* (reg8 *) TEST_INPUT__BIT_MASK)
/* Bypass Enable */
#define TEST_INPUT_BYP                    (* (reg8 *) TEST_INPUT__BYP)
/* Port wide control signals */                                                   
#define TEST_INPUT_CTL                    (* (reg8 *) TEST_INPUT__CTL)
/* Drive Modes */
#define TEST_INPUT_DM0                    (* (reg8 *) TEST_INPUT__DM0) 
#define TEST_INPUT_DM1                    (* (reg8 *) TEST_INPUT__DM1)
#define TEST_INPUT_DM2                    (* (reg8 *) TEST_INPUT__DM2) 
/* Input Buffer Disable Override */
#define TEST_INPUT_INP_DIS                (* (reg8 *) TEST_INPUT__INP_DIS)
/* LCD Common or Segment Drive */
#define TEST_INPUT_LCD_COM_SEG            (* (reg8 *) TEST_INPUT__LCD_COM_SEG)
/* Enable Segment LCD */
#define TEST_INPUT_LCD_EN                 (* (reg8 *) TEST_INPUT__LCD_EN)
/* Slew Rate Control */
#define TEST_INPUT_SLW                    (* (reg8 *) TEST_INPUT__SLW)

/* DSI Port Registers */
/* Global DSI Select Register */
#define TEST_INPUT_PRTDSI__CAPS_SEL       (* (reg8 *) TEST_INPUT__PRTDSI__CAPS_SEL) 
/* Double Sync Enable */
#define TEST_INPUT_PRTDSI__DBL_SYNC_IN    (* (reg8 *) TEST_INPUT__PRTDSI__DBL_SYNC_IN) 
/* Output Enable Select Drive Strength */
#define TEST_INPUT_PRTDSI__OE_SEL0        (* (reg8 *) TEST_INPUT__PRTDSI__OE_SEL0) 
#define TEST_INPUT_PRTDSI__OE_SEL1        (* (reg8 *) TEST_INPUT__PRTDSI__OE_SEL1) 
/* Port Pin Output Select Registers */
#define TEST_INPUT_PRTDSI__OUT_SEL0       (* (reg8 *) TEST_INPUT__PRTDSI__OUT_SEL0) 
#define TEST_INPUT_PRTDSI__OUT_SEL1       (* (reg8 *) TEST_INPUT__PRTDSI__OUT_SEL1) 
/* Sync Output Enable Registers */
#define TEST_INPUT_PRTDSI__SYNC_OUT       (* (reg8 *) TEST_INPUT__PRTDSI__SYNC_OUT) 


#if defined(TEST_INPUT__INTSTAT)  /* Interrupt Registers */

    #define TEST_INPUT_INTSTAT                (* (reg8 *) TEST_INPUT__INTSTAT)
    #define TEST_INPUT_SNAP                   (* (reg8 *) TEST_INPUT__SNAP)

#endif /* Interrupt Registers */

#endif /* End Pins TEST_INPUT_H */


/* [] END OF FILE */
