/*******************************************************************************
* File Name: VDACQ.h  
* Version 1.50
*
*  Description:
*    This file contains the function prototypes and constants used in
*    the 8-bit Voltage DAC (vDAC8) User Module.
*
*   Note:
*     
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#if !defined(CY_VDAC8_VDACQ_H) 
#define CY_VDAC8_VDACQ_H

#include "cytypes.h"
#include "cyfitter.h"


/* PSoC3 ES2 or early */
#define VDACQ_PSOC3_ES2  ((CYDEV_CHIP_MEMBER_USED == CYDEV_CHIP_MEMBER_3A)    && \
                                    (CYDEV_CHIP_REVISION_USED <= CYDEV_CHIP_REVISION_3A_ES2))                    
/* PSoC5 ES1 or early */
#define VDACQ_PSOC5_ES1  ((CYDEV_CHIP_MEMBER_USED == CYDEV_CHIP_MEMBER_5A)    && \
                                    (CYDEV_CHIP_REVISION_USED <= CYDEV_CHIP_REVISION_5A_ES1))
/* PSoC3 ES3 or later */
#define VDACQ_PSOC3_ES3  ((CYDEV_CHIP_MEMBER_USED == CYDEV_CHIP_MEMBER_3A)    && \
                                    (CYDEV_CHIP_REVISION_USED > CYDEV_CHIP_REVISION_3A_ES2))
/* PSoC5 ES2 or later */
#define VDACQ_PSOC5_ES2  ((CYDEV_CHIP_MEMBER_USED == CYDEV_CHIP_MEMBER_5A)    && \
                                    (CYDEV_CHIP_REVISION_USED > CYDEV_CHIP_REVISION_5A_ES1))


/***************************************
*       Type defines
***************************************/

/* Sleep Mode API Support */
typedef struct VDACQ_backupStruct
{
    uint8 enableState; 
	uint8 data_value;
}VDACQ_backupStruct;


/***************************************
*        Function Prototypes 
***************************************/

void VDACQ_Start(void);
void VDACQ_Stop(void)            ;
void VDACQ_SetSpeed(uint8 speed) ;
void VDACQ_SetRange(uint8 range) ;
void VDACQ_SetValue(uint8 value) ;
void VDACQ_DacTrim(void)         ;
void VDACQ_Init(void)            ;
void VDACQ_Enable(void)          ;
void VDACQ_SaveConfig(void);
void VDACQ_RestoreConfig(void);
void VDACQ_Sleep(void);
void VDACQ_Wakeup(void)          ;
  
  
/***************************************
*            API Constants
***************************************/

/* SetRange constants */

#define VDACQ_RANGE_1V       0x00u
#define VDACQ_RANGE_4V       0x04u


/* Power setting for Start API  */
#define VDACQ_LOWSPEED       0x00u
#define VDACQ_HIGHSPEED      0x02u


/***************************************
*  Initialization Parameter Constants
***************************************/

#define VDACQ_DEFAULT_RANGE    0     /* Default DAC range */
#define VDACQ_DEFAULT_SPEED    0     /* Default DAC speed */
#define VDACQ_DEFAULT_CNTL     0x00u             /* Default Control */
#define VDACQ_DEFAULT_STRB     0    /* Default Strobe mode */
#define VDACQ_DEFAULT_DATA     100  /* Initial DAC value */
#define VDACQ_DEFAULT_DATA_SRC 0    /* Default Data Source */


/***************************************
*              Registers        
***************************************/

#define VDACQ_CR0         (* (reg8 *) VDACQ_viDAC8__CR0 )
#define VDACQ_CR1         (* (reg8 *) VDACQ_viDAC8__CR1 )
#define VDACQ_Data        (* (reg8 *) VDACQ_viDAC8__D )
#define VDACQ_Data_PTR    (  (reg8 *) VDACQ_viDAC8__D )
#define VDACQ_Strobe      (* (reg8 *) VDACQ_viDAC8__STROBE )
#define VDACQ_SW0         (* (reg8 *) VDACQ_viDAC8__SW0 )
#define VDACQ_SW2         (* (reg8 *) VDACQ_viDAC8__SW2 )
#define VDACQ_SW3         (* (reg8 *) VDACQ_viDAC8__SW3 )
#define VDACQ_SW4         (* (reg8 *) VDACQ_viDAC8__SW4 )
#define VDACQ_TR          (* (reg8 *) VDACQ_viDAC8__TR )
#define VDACQ_PWRMGR      (* (reg8 *) VDACQ_viDAC8__PM_ACT_CFG )  /* Power manager */
#define VDACQ_STBY_PWRMGR (* (reg8 *) VDACQ_viDAC8__PM_STBY_CFG )  /* Standby Power manager */


/***************************************
*         Register Constants       
***************************************/

/* CR0 vDac Control Register 0 definitions */

/* Bit Field  DAC_HS_MODE                  */
#define VDACQ_HS_MASK        0x02u
#define VDACQ_HS_LOWPOWER    0x00u
#define VDACQ_HS_HIGHSPEED   0x02u

/* Bit Field  DAC_MODE                  */
#define VDACQ_MODE_MASK      0x10u
#define VDACQ_MODE_V         0x00u
#define VDACQ_MODE_I         0x10u

/* Bit Field  DAC_RANGE                  */
#define VDACQ_RANGE_MASK     0x0Cu
#define VDACQ_RANGE_0        0x00u
#define VDACQ_RANGE_1        0x04u

/* CR1 iDac Control Register 1 definitions */

/* Bit Field  DAC_MX_DATA                  */
#define VDACQ_SRC_MASK       0x20u
#define VDACQ_SRC_REG        0x00u
#define VDACQ_SRC_UDB        0x20u

/* This bit enable reset from UDB array      */
#define VDACQ_RESET_MASK     0x10u
#define VDACQ_RESET_ENABLE   0x10u
#define VDACQ_RESET_DISABLE  0x00u

/* This bit enables data from DAC bus      */
#define VDACQ_DACBUS_MASK     0x20u
#define VDACQ_DACBUS_ENABLE   0x20u
#define VDACQ_DACBUS_DISABLE  0x00u

/* DAC STROBE Strobe Control Register definitions */

/* Bit Field  DAC_MX_STROBE                  */
#define VDACQ_STRB_MASK     0x08u
#define VDACQ_STRB_EN       0x08u
#define VDACQ_STRB_DIS      0x00u

/* PM_ACT_CFG (Active Power Mode CFG Register)     */ 
#define VDACQ_ACT_PWR_EN   VDACQ_viDAC8__PM_ACT_MSK /* Power enable mask */ 
#define VDACQ_STBY_PWR_EN  VDACQ_viDAC8__PM_STBY_MSK  /* Standby Power enable mask */


/***********************************************************************************
*              Trim    
* Note - VDAC trim values are stored in the "Customer Table" area in 
* Row 1 of the Hidden Flash.  There are 8 bytes of trim data for each VDAC block.
* The values are:
*       I Gain offset, min range, Sourcing
*       I Gain offset, min range, Sinking
*       I Gain offset, med range, Sourcing
*       I Gain offset, med range, Sinking
*       I Gain offset, max range, Sourcing
*       I Gain offset, max range, Sinking
*       V Gain offset, 1V range
*       V Gain offset, 4V range
*
* The data set for the 4 VDACs are arranged using a left side/right side approach:
*   Left 0, Left 1, Right 0, Right 1.
* When mapped to the VDAC0 thru VDAC3 as:
*   VDAC 0, VDAC 2, VDAC 1, VDAC 3
************************************************************************************/
#define VDACQ_TRIM_M7_1V_RNG_OFFSET  0x06u
#define VDACQ_TRIM_M8_4V_RNG_OFFSET  0x07u

#define VDACQ_DAC_TRIM_BASE     (VDACQ_viDAC8__TRIM__M1)

#endif /* CY_VDAC8_VDACQ_H  */


/* [] END OF FILE */


