/*******************************************************************************
* File Name: Filter.h
* Version 2.0
*
* Description:
*  This header file contains definitions associated with the FILT component.
*
* Note:
* 
********************************************************************************
* Copyright 2008-2012, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(Filter_H) /* FILT Header File */
#define Filter_H

#include "cyfitter.h"
#include "CyLib.h"


/***************************************
*     Data Struct Definition
***************************************/

/* Low power Mode API Support */
typedef struct _Filter_backupStruct 
{
    uint8 enableState;
    uint8 cr;
    uint8 sr;
    uint8 sema;
}   Filter_BACKUP_STRUCT;


/***************************************
* FILT component function prototypes.
****************************************/

void   Filter_Start(void);
void   Filter_Stop(void) ;
uint8 Filter_Read8(uint8 channel) ;
uint16 Filter_Read16(uint8 channel) ;
uint32 Filter_Read24(uint8 channel) ;
void Filter_Write8(uint8 channel, uint8 sample) ;
void Filter_Write16(uint8 channel, uint16 sample) ;
void Filter_Write24(uint8 channel, uint32 sample) ;
void Filter_Sleep(void);
void Filter_Wakeup(void) ;
void Filter_SaveConfig(void);
void Filter_RestoreConfig(void) ;
void Filter_Init(void) ;
void Filter_Enable(void) ;
void Filter_SetCoherency(uint8 channel, uint8 byteSelect) ;
void Filter_RestoreACURam(void) ;


/*****************************************
* FILT component API Constants.
******************************************/

/* Channel Definitions */
#define Filter_CHANNEL_A             (0u)
#define Filter_CHANNEL_B             (1u)

#define Filter_CHANNEL_A_INTR        (0x08u)
#define Filter_CHANNEL_B_INTR        (0x10u)

#define Filter_ALL_INTR              (0xf8u)

#define Filter_SIGN_BIT              (0x00800000u)
#define Filter_SIGN_BYTE             (0xFF000000u)

/* Component's enable/disable state */
#define Filter_ENABLED               (0x01u)
#define Filter_DISABLED              (0x00u)

/* SetCoherency API constants */
#define Filter_KEY_LOW               (0x00u)
#define Filter_KEY_MID               (0x01u)
#define Filter_KEY_HIGH              (0x02u)


/*******************************************************************************
* FILT component macros.
*******************************************************************************/

#define Filter_ClearInterruptSource() \
   (Filter_SR_REG = Filter_ALL_INTR )

#define Filter_IsInterruptChannelA() \
    (Filter_SR_REG & Filter_CHANNEL_A_INTR)

#define Filter_IsInterruptChannelB() \
    (Filter_SR_REG & Filter_CHANNEL_B_INTR)


/*******************************************************************************
* FILT component DFB registers.
*******************************************************************************/

/* DFB Status register */
#define Filter_SR_REG             (* (reg8 *) Filter_DFB__SR)
#define Filter_SR_PTR             (  (reg8 *) Filter_DFB__SR)

/* DFB Control register */
#define Filter_CR_REG             (* (reg8 *) Filter_DFB__CR)
#define Filter_CR_PTR             (  (reg8 *) Filter_DFB__CR)


/*******************************************************************************
* DFB.COHER bit field defines.
*******************************************************************************/

/* STAGEA key coherency mask */
#define Filter_STAGEA_COHER_MASK    0x03u

/* HOLDA key coherency mask */
#define Filter_HOLDA_COHER_MASK    (0x03u << 4)

/* STAGEB key coherency mask */
#define Filter_STAGEB_COHER_MASK    0x0Cu

/* HOLDB key coherency mask */
#define Filter_HOLDB_COHER_MASK    (0x0Cu << 4)

#endif /* End FILT Header File */


/* [] END OF FILE */
