/*******************************************************************************
* File Name: TP14_OUT.c  
* Version 1.60
*
* Description:
*  This file contains API to enable firmware control of a Pins component.
*
* Note:
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#include "cytypes.h"
#include "TP14_OUT.h"


/*******************************************************************************
* Function Name: TP14_OUT_Write
********************************************************************************
* Summary:
*  Assign a new value to the digital port's data output register.  
*
* Parameters:  
*  prtValue:  The value to be assigned to the Digital Port. 
*
* Return: 
*  void 
*  
*******************************************************************************/
void TP14_OUT_Write(uint8 value) 
{
    uint8 staticBits = TP14_OUT_DR & ~TP14_OUT_MASK;
    TP14_OUT_DR = staticBits | ((value << TP14_OUT_SHIFT) & TP14_OUT_MASK);
}


/*******************************************************************************
* Function Name: TP14_OUT_SetDriveMode
********************************************************************************
* Summary:
*  Change the drive mode on the pins of the port.
* 
* Parameters:  
*  mode:  Change the pins to this drive mode.
*
* Return: 
*  void
*
*******************************************************************************/
void TP14_OUT_SetDriveMode(uint8 mode) 
{
	CyPins_SetPinDriveMode(TP14_OUT_0, mode);
}


/*******************************************************************************
* Function Name: TP14_OUT_Read
********************************************************************************
* Summary:
*  Read the current value on the pins of the Digital Port in right justified 
*  form.
*
* Parameters:  
*  void 
*
* Return: 
*  Returns the current value of the Digital Port as a right justified number
*  
* Note:
*  Macro TP14_OUT_ReadPS calls this function. 
*  
*******************************************************************************/
uint8 TP14_OUT_Read(void) 
{
    return (TP14_OUT_PS & TP14_OUT_MASK) >> TP14_OUT_SHIFT;
}


/*******************************************************************************
* Function Name: TP14_OUT_ReadDataReg
********************************************************************************
* Summary:
*  Read the current value assigned to a Digital Port's data output register
*
* Parameters:  
*  void 
*
* Return: 
*  Returns the current value assigned to the Digital Port's data output register
*  
*******************************************************************************/
uint8 TP14_OUT_ReadDataReg(void) 
{
    return (TP14_OUT_DR & TP14_OUT_MASK) >> TP14_OUT_SHIFT;
}


/* If Interrupts Are Enabled for this Pins component */ 
#if defined(TP14_OUT_INTSTAT) 

    /*******************************************************************************
    * Function Name: TP14_OUT_ClearInterrupt
    ********************************************************************************
    * Summary:
    *  Clears any active interrupts attached to port and returns the value of the 
    *  interrupt status register.
    *
    * Parameters:  
    *  void 
    *
    * Return: 
    *  Returns the value of the interrupt status register
    *  
    *******************************************************************************/
    uint8 TP14_OUT_ClearInterrupt(void) 
    {
        return (TP14_OUT_INTSTAT & TP14_OUT_MASK) >> TP14_OUT_SHIFT;
    }

#endif /* If Interrupts Are Enabled for this Pins component */ 


/* [] END OF FILE */ 
