/*******************************************************************************
* FILENAME: cyfitter_cfg.c
* PSoC Creator 2.0 Component Pack 1
*
* Description:
* This file is automatically generated by PSoC Creator with device 
* initialization code.
*
* THIS FILE SHOULD NOT BE MODIFIED.
*
********************************************************************************
* Copyright 2011, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#include <string.h>
#include <cytypes.h>
#include <cydevice_trm.h>
#include <cyfitter.h>
#include <CyLib.h>
#include <cyfitter_cfg.h>

/* Clock startup error codes                                                   */
#define CYCLOCKSTART_NO_ERROR    0
#define CYCLOCKSTART_XTAL_ERROR  1
#define CYCLOCKSTART_32KHZ_ERROR 2
#define CYCLOCKSTART_PLL_ERROR   3

/*******************************************************************************
* Function Name: CyClockStartupError
********************************************************************************
* Summary:
*  If an error is encountered during clock configuration (crystal startup error,
*  PLL lock error, etc) the system will end up here.  Unless reimplemented by 
*  the customer, an infinite loop will be encountered.
*
* Parameters:  
*   void
*
* Return:
*   void
*
*******************************************************************************/
#if defined(__GNUC__) || defined(__ARMCC_VERSION)
__attribute__ ((unused))
#endif
static void CyClockStartupError(uint8 errorCode)
{
    /* To remove the compiler warning if errorCode not used.                */
    errorCode = errorCode;

    /* `#START CyClockStartupError` */

    /* `#END` */

    /* If nothing else, stop here since the clocks have not started         */
    /* correctly.                                                           */
    while(1) {}
}


#undef CYCODE
#undef CYDATA
#undef CYXDATA
#undef CYFAR
#if defined(__C51__) || defined(__CX51__)
	#define CYCODE code
	#define CYDATA data
	#define CYXDATA xdata
	#define CYFAR far

	#define CYPACKED
	#define CYALIGNED
    
	#define CY_CFG_MEMORY_BARRIER()

	#ifndef CYCONFIGCPY_DECLARED
		extern void cymemzero(void CYFAR *addr, uint16 size);
		extern void cyconfigcpy(uint16 size, const void CYFAR *src, void CYFAR *dest) small;
		extern void cyconfigcpycode(uint16 size, const void CYCODE *src, void CYFAR *dest);
	#endif


	#define CYMEMZERO(a,c) cymemzero((a),(c))
	#define CYCONFIGCPY(d,s,c) cyconfigcpy((c),(s),(d))
	#define CYCONFIGCPYCODE(d,s,c) cyconfigcpycode((c),(s),(d))
#else
	#error Unsupported toolchain
#endif

/* Defines the layout and meaning of each entry in the cfg_memset_list used for clearing registers */
typedef struct {
	void CYFAR *address;
	uint16 size;
} CYPACKED cfg_memset_t;

/* Defines the layout and meaning of each entry in the cfg_memcpy_list used for initializing registers */
typedef struct {
	void CYFAR *dest;
	const void CYCODE *src;
	uint16 size;
} CYPACKED cfg_memcpy_t;

/* Contains the regions of memory that must be set to 0 during configuration */
#define CFG_MEMSET_COUNT (sizeof(cfg_memset_list)/sizeof(*cfg_memset_list))
static const cfg_memset_t CYCODE cfg_memset_list [] = {
	/* address, size */
	{(void CYFAR *)(CYREG_PRT3_DR), 64},
	{(void CYFAR *)(CYDEV_UCFG_B0_P0_U0_BASE), 4096},
	{(void CYFAR *)(CYDEV_UCFG_B1_P2_U0_BASE), 2048},
	{(void CYFAR *)(CYDEV_UCFG_DSI0_BASE), 2560},
	{(void CYFAR *)(CYDEV_UCFG_DSI12_BASE), 512},
	{(void CYFAR *)(CYREG_BCTL1_MDCLK_EN), 16},
};

const uint8 CYCODE cfg_byte_table[] = {
	0x23,
	0x00, 0x52, 0x04, /* Base address 0x005200 */
	/* CYDEV_PRTDSI_PRT1_BASE */
	0x08, 0x10, 
	/* CYDEV_PRTDSI_PRT2_BASE */
	0x11, 0x10, 
	/* CYDEV_PRTDSI_PRT12_BASE */
	0x60, 0x04, 0x61, 0x08, 
	0x00, 0x64, 0x03, /* Base address 0x006400 */
	/* CYDEV_UWRK_UWRK8_B0_BASE + 0x00000070 */
	0x74, 0x80, 0x76, 0x15, 0x7D, 0x02, 
	0x01, 0x00, 0x16, /* Base address 0x010000 */
	/* CYDEV_UCFG_B0_P0_U1_BASE */
	0x82, 0x01, 0x91, 0x02, 0x93, 0x01, 0x95, 0x08, 0x97, 0x04, 0x99, 0x20, 0x9B, 0x10, 0x9D, 0x80, 
	0x9F, 0x40, 0xA1, 0xAA, 0xA3, 0x55, 0xB1, 0x03, 0xB3, 0x0C, 0xB5, 0x30, 0xB6, 0x01, 0xB7, 0xC0, 
	0xB9, 0xFF, 0xBB, 0x54, 0xD8, 0x04, 0xD9, 0x04, 0xDB, 0x04, 0xDF, 0x01, 
	0x01, 0x01, 0x0F, /* Base address 0x010100 */
	/* CYDEV_UCFG_B0_P0_ROUTE_BASE */
	0x06, 0x40, 0x1F, 0x40, 0x24, 0x50, 0x27, 0x0A, 0x2E, 0x02, 0x2F, 0x40, 0x36, 0x9A, 0x5C, 0x50, 
	0x5F, 0x0A, 0x67, 0x2A, 
	/* CYDEV_UCFG_B0_P0_ROUTE_BASE + 0x00000080 */
	0xC0, 0x10, 0xCA, 0x80, 0xCC, 0xF0, 0xD6, 0xF0, 0xD8, 0x70, 
	0x01, 0x02, 0x6C, /* Base address 0x010200 */
	/* CYDEV_UCFG_B0_P1_U0_BASE */
	0x01, 0x54, 0x03, 0x54, 0x05, 0x54, 0x07, 0x54, 0x09, 0x54, 0x0B, 0x54, 0x0C, 0x40, 0x0D, 0xD4, 
	0x0F, 0x54, 0x11, 0x56, 0x12, 0x40, 0x13, 0x55, 0x14, 0x20, 0x15, 0x5C, 0x16, 0x10, 0x17, 0x54, 
	0x18, 0x08, 0x19, 0x74, 0x1A, 0x04, 0x1B, 0x54, 0x1C, 0x02, 0x1D, 0x54, 0x1E, 0x01, 0x1F, 0x54, 
	0x21, 0x54, 0x23, 0x54, 0x25, 0x54, 0x27, 0x54, 0x29, 0x54, 0x2B, 0x54, 0x2C, 0x2A, 0x2D, 0x56, 
	0x2E, 0x15, 0x2F, 0x55, 0x30, 0x03, 0x31, 0x03, 0x32, 0x0C, 0x33, 0x08, 0x34, 0x30, 0x35, 0x20, 
	0x36, 0x40, 0x37, 0x80, 0x38, 0x2F, 0x39, 0xFF, 0x3A, 0x15, 0x3B, 0x54, 0x3F, 0x55, 0x58, 0x04, 
	0x59, 0x04, 0x5F, 0x01, 
	/* CYDEV_UCFG_B0_P1_U1_BASE */
	0x80, 0x15, 0x81, 0x80, 0x82, 0x15, 0x83, 0x40, 0x84, 0x15, 0x85, 0x20, 0x86, 0x15, 0x87, 0x10, 
	0x88, 0x15, 0x89, 0x08, 0x8A, 0x15, 0x8B, 0x04, 0x8C, 0x17, 0x8E, 0x15, 0x90, 0x15, 0x91, 0x02, 
	0x92, 0x15, 0x93, 0x01, 0x94, 0x1D, 0x96, 0x15, 0x98, 0x35, 0x99, 0x80, 0x9A, 0x15, 0x9B, 0x40, 
	0x9C, 0x15, 0x9D, 0x20, 0x9E, 0x55, 0x9F, 0x10, 0xA0, 0x15, 0xA1, 0x08, 0xA2, 0x15, 0xA3, 0x04, 
	0xA4, 0x15, 0xA6, 0x15, 0xA8, 0x15, 0xAA, 0x15, 0xAC, 0x55, 0xAD, 0x02, 0xAE, 0x15, 0xAF, 0x01, 
	0xB0, 0x02, 0xB1, 0x03, 0xB2, 0x08, 0xB3, 0x0C, 0xB4, 0x20, 0xB5, 0x30, 0xB6, 0x40, 0xB7, 0xC0, 
	0xB8, 0x2F, 0xB9, 0xFF, 0xBA, 0x15, 0xBB, 0x54, 0xBE, 0x15, 0xBF, 0x55, 0xD8, 0x04, 0xD9, 0x04, 
	0xDB, 0x04, 0xDF, 0x01, 
	0x01, 0x03, 0x26, /* Base address 0x010300 */
	/* CYDEV_UCFG_B0_P1_ROUTE_BASE */
	0x00, 0x40, 0x06, 0x01, 0x0A, 0x28, 0x0B, 0x01, 0x0E, 0x40, 0x0F, 0x2A, 0x12, 0x01, 0x13, 0x40, 
	0x16, 0x02, 0x19, 0xC0, 0x1B, 0x15, 0x1C, 0x01, 0x1F, 0x15, 0x21, 0x99, 0x26, 0x9A, 0x28, 0x82, 
	0x2F, 0x02, 0x30, 0x02, 0x31, 0x20, 0x32, 0x40, 0x36, 0x25, 0x39, 0x15, 0x3D, 0x80, 0x68, 0x02, 
	0x69, 0x15, 0x70, 0x88, 0x73, 0x84, 
	/* CYDEV_UCFG_B0_P1_ROUTE_BASE + 0x00000080 */
	0x8C, 0x01, 0x97, 0x2A, 0x9A, 0x02, 0x9E, 0x40, 0xA6, 0x9A, 0xC0, 0x81, 0xC2, 0xF7, 0xC4, 0x81, 
	0xCA, 0x19, 0xCC, 0xED, 0xCE, 0x17, 
	0x01, 0x04, 0x5E, /* Base address 0x010400 */
	/* CYDEV_UCFG_B0_P2_U0_BASE */
	0x00, 0x02, 0x01, 0x80, 0x02, 0x01, 0x03, 0x40, 0x04, 0x08, 0x05, 0x20, 0x06, 0x04, 0x07, 0x10, 
	0x09, 0x08, 0x0B, 0x04, 0x0D, 0x02, 0x0F, 0x01, 0x10, 0x80, 0x11, 0x02, 0x12, 0x40, 0x13, 0x01, 
	0x14, 0x20, 0x16, 0x10, 0x18, 0x08, 0x1A, 0x04, 0x1D, 0x80, 0x1F, 0x40, 0x20, 0x02, 0x22, 0x01, 
	0x25, 0x08, 0x27, 0x04, 0x28, 0x20, 0x2A, 0x10, 0x2C, 0x80, 0x2D, 0x20, 0x2E, 0x40, 0x2F, 0x10, 
	0x30, 0x03, 0x31, 0x03, 0x32, 0x0C, 0x33, 0x0C, 0x34, 0x30, 0x35, 0x30, 0x36, 0xC0, 0x37, 0xC0, 
	0x38, 0xFF, 0x39, 0xFF, 0x3A, 0x55, 0x3B, 0x55, 0x3E, 0x55, 0x3F, 0x55, 0x58, 0x04, 0x59, 0x04, 
	0x5B, 0x04, 0x5F, 0x01, 
	/* CYDEV_UCFG_B0_P2_U1_BASE */
	0x80, 0x12, 0x82, 0x11, 0x83, 0x08, 0x84, 0x10, 0x86, 0x10, 0x88, 0x10, 0x8A, 0x50, 0x8C, 0x10, 
	0x8D, 0x0F, 0x8E, 0x10, 0x90, 0x10, 0x92, 0x10, 0x94, 0x18, 0x96, 0x14, 0x98, 0x10, 0x9A, 0x10, 
	0x9C, 0x10, 0x9E, 0x10, 0xA0, 0x10, 0xA2, 0x10, 0xA3, 0x01, 0xA4, 0x18, 0xA6, 0x14, 0xA7, 0x04, 
	0xA8, 0x10, 0xAA, 0x10, 0xAB, 0x02, 0xAC, 0x12, 0xAE, 0x11, 0xB0, 0x03, 0xB1, 0x08, 0xB2, 0x0C, 
	0xB3, 0x04, 0xB4, 0x20, 0xB5, 0x02, 0xB6, 0x40, 0xB7, 0x01, 0xB8, 0x2F, 0xBA, 0x95, 0xBE, 0x15, 
	0xD8, 0x04, 0xD9, 0x04, 0xDC, 0x09, 0xDF, 0x01, 
	0x01, 0x05, 0x3F, /* Base address 0x010500 */
	/* CYDEV_UCFG_B0_P2_ROUTE_BASE */
	0x00, 0x04, 0x02, 0x80, 0x04, 0x21, 0x09, 0x05, 0x0B, 0x04, 0x0F, 0x10, 0x10, 0x88, 0x13, 0x80, 
	0x16, 0x02, 0x17, 0x08, 0x19, 0x02, 0x1A, 0x01, 0x1B, 0x28, 0x1E, 0x44, 0x1F, 0x44, 0x20, 0x08, 
	0x22, 0x01, 0x23, 0x21, 0x24, 0x04, 0x25, 0x05, 0x26, 0x80, 0x29, 0x84, 0x2D, 0x02, 0x2F, 0x28, 
	0x31, 0x40, 0x33, 0x01, 0x39, 0x55, 0x3E, 0x01, 0x3F, 0x40, 0x69, 0x55, 0x72, 0x02, 0x73, 0x48, 
	/* CYDEV_UCFG_B0_P2_ROUTE_BASE + 0x00000080 */
	0x87, 0x40, 0x8C, 0x80, 0x8D, 0x04, 0x8F, 0x20, 0x90, 0x01, 0x91, 0x20, 0x93, 0x04, 0x94, 0x40, 
	0x96, 0xE8, 0x97, 0x41, 0x99, 0x40, 0x9B, 0x80, 0x9C, 0x80, 0xA0, 0x88, 0xA1, 0x88, 0xA5, 0x60, 
	0xA6, 0x25, 0xAC, 0x02, 0xAE, 0x40, 0xAF, 0x02, 0xB1, 0x81, 0xC0, 0x5C, 0xC2, 0x2E, 0xC4, 0xAB, 
	0xCA, 0xEA, 0xCC, 0x09, 0xCE, 0x9F, 0xE2, 0x08, 0xE4, 0x02, 0xEA, 0x08, 0xEE, 0x02, 
	0x01, 0x06, 0x4D, /* Base address 0x010600 */
	/* CYDEV_UCFG_B0_P3_U0_BASE */
	0x01, 0xD4, 0x03, 0x54, 0x05, 0x56, 0x07, 0x55, 0x09, 0x5C, 0x0B, 0x54, 0x0D, 0x56, 0x0F, 0x55, 
	0x11, 0x54, 0x13, 0x54, 0x15, 0x54, 0x17, 0x54, 0x19, 0x54, 0x1B, 0x54, 0x1D, 0x54, 0x1F, 0x54, 
	0x21, 0x54, 0x23, 0x54, 0x25, 0x74, 0x27, 0x54, 0x29, 0x54, 0x2B, 0x54, 0x2D, 0x54, 0x2F, 0x54, 
	0x31, 0x03, 0x33, 0x08, 0x35, 0x20, 0x37, 0x80, 0x39, 0xFF, 0x3B, 0x54, 0x3F, 0x55, 0x59, 0x04, 
	0x5B, 0x04, 0x5F, 0x01, 
	/* CYDEV_UCFG_B0_P3_U1_BASE */
	0x80, 0x15, 0x82, 0x15, 0x84, 0x15, 0x86, 0x55, 0x87, 0x01, 0x88, 0x1D, 0x8A, 0x15, 0x8B, 0x04, 
	0x8C, 0x15, 0x8D, 0x0F, 0x8E, 0x15, 0x90, 0x55, 0x92, 0x15, 0x94, 0x15, 0x96, 0x15, 0x97, 0x02, 
	0x98, 0x15, 0x9A, 0x15, 0x9C, 0x15, 0x9E, 0x15, 0x9F, 0x08, 0xA0, 0x17, 0xA2, 0x15, 0xA4, 0x15, 
	0xA6, 0x15, 0xA8, 0x35, 0xAA, 0x15, 0xAC, 0x15, 0xAE, 0x15, 0xB0, 0x02, 0xB1, 0x02, 0xB2, 0x08, 
	0xB3, 0x01, 0xB4, 0x20, 0xB5, 0x08, 0xB6, 0x40, 0xB7, 0x04, 0xB8, 0x2F, 0xBA, 0x15, 0xBE, 0x15, 
	0xD8, 0x04, 0xD9, 0x04, 0xDF, 0x01, 
	0x01, 0x07, 0x38, /* Base address 0x010700 */
	/* CYDEV_UCFG_B0_P3_ROUTE_BASE */
	0x00, 0x08, 0x01, 0x20, 0x0B, 0x40, 0x10, 0x88, 0x18, 0x40, 0x19, 0x80, 0x1A, 0x28, 0x20, 0x22, 
	0x21, 0x21, 0x22, 0x40, 0x23, 0x10, 0x25, 0x40, 0x26, 0x25, 0x2F, 0x20, 0x31, 0x88, 0x39, 0x20, 
	0x3B, 0x48, 0x3D, 0x02, 0x3E, 0x54, 0x40, 0x80, 0x41, 0x01, 0x6D, 0x02, 0x6E, 0x50, 0x6F, 0x20, 
	0x74, 0x88, 0x75, 0x20, 
	/* CYDEV_UCFG_B0_P3_ROUTE_BASE + 0x00000080 */
	0x84, 0x10, 0x8D, 0x04, 0x91, 0x20, 0x92, 0x04, 0x93, 0xC8, 0x94, 0x60, 0x96, 0xA8, 0x97, 0x10, 
	0x9C, 0x80, 0x9D, 0x84, 0x9F, 0x01, 0xA0, 0x04, 0xA1, 0x88, 0xA5, 0x60, 0xA6, 0x25, 0xA9, 0x01, 
	0xAF, 0x40, 0xB1, 0x20, 0xB2, 0x81, 0xB4, 0x04, 0xC0, 0x06, 0xC2, 0x08, 0xC4, 0x0A, 0xCA, 0x40, 
	0xCC, 0x0A, 0xCE, 0xFE, 0xE0, 0x08, 0xE2, 0x02, 0xEA, 0x04, 0xEC, 0x01, 
	0x01, 0x08, 0x0B, /* Base address 0x010800 */
	/* CYDEV_UCFG_B0_P4_U0_BASE */
	0x05, 0x0F, 0x0F, 0x04, 0x17, 0x02, 0x1F, 0x01, 0x27, 0x08, 0x31, 0x02, 0x33, 0x08, 0x35, 0x04, 
	0x37, 0x01, 0x59, 0x04, 0x5F, 0x01, 
	0x01, 0x09, 0x1F, /* Base address 0x010900 */
	/* CYDEV_UCFG_B0_P4_ROUTE_BASE */
	0x24, 0x28, 0x25, 0x43, 0x2F, 0x10, 0x36, 0x40, 0x37, 0x04, 0x3C, 0x80, 0x3E, 0x08, 
	/* CYDEV_UCFG_B0_P4_ROUTE_BASE + 0x00000080 */
	0x84, 0x04, 0x8D, 0x01, 0x93, 0x20, 0x94, 0x28, 0x95, 0x10, 0x9A, 0x08, 0x9B, 0x04, 0x9C, 0x04, 
	0x9E, 0x50, 0xA0, 0x40, 0xA2, 0x40, 0xA5, 0x02, 0xAA, 0x01, 0xB1, 0x04, 0xB2, 0x40, 0xB3, 0x04, 
	0xB7, 0x08, 0xCA, 0x40, 0xCC, 0x50, 0xCE, 0x50, 0xE2, 0x12, 0xE8, 0xA0, 0xEA, 0x04, 0xEC, 0xC0, 
	0x01, 0x0A, 0x46, /* Base address 0x010A00 */
	/* CYDEV_UCFG_B0_P5_U0_BASE */
	0x02, 0x02, 0x05, 0x0F, 0x0F, 0x04, 0x17, 0x08, 0x1A, 0x01, 0x1B, 0x01, 0x1C, 0x0F, 0x1F, 0x02, 
	0x2A, 0x08, 0x2E, 0x04, 0x30, 0x01, 0x31, 0x04, 0x32, 0x04, 0x33, 0x01, 0x34, 0x02, 0x35, 0x08, 
	0x36, 0x08, 0x37, 0x02, 0x58, 0x04, 0x59, 0x04, 0x5F, 0x01, 
	/* CYDEV_UCFG_B0_P5_U1_BASE */
	0x80, 0x20, 0x82, 0x10, 0x84, 0x02, 0x86, 0x01, 0x88, 0x80, 0x89, 0x20, 0x8A, 0x40, 0x8B, 0x10, 
	0x8C, 0x08, 0x8D, 0x20, 0x8E, 0x04, 0x8F, 0x10, 0x91, 0x80, 0x93, 0x40, 0x94, 0x80, 0x95, 0x08, 
	0x96, 0x40, 0x97, 0x04, 0x9D, 0x80, 0x9F, 0x40, 0xA0, 0x02, 0xA1, 0x08, 0xA2, 0x01, 0xA3, 0x04, 
	0xA5, 0x02, 0xA7, 0x01, 0xA8, 0x20, 0xA9, 0x02, 0xAA, 0x10, 0xAB, 0x01, 0xAC, 0x08, 0xAE, 0x04, 
	0xB0, 0x03, 0xB1, 0x03, 0xB2, 0x0C, 0xB3, 0x0C, 0xB4, 0x30, 0xB5, 0x30, 0xB6, 0xC0, 0xB7, 0xC0, 
	0xB8, 0xFF, 0xB9, 0xFF, 0xBA, 0x54, 0xBB, 0x55, 0xBE, 0x55, 0xBF, 0x55, 0xD8, 0x04, 0xD9, 0x04, 
	0xDF, 0x01, 
	0x01, 0x0B, 0x38, /* Base address 0x010B00 */
	/* CYDEV_UCFG_B0_P5_ROUTE_BASE */
	0x00, 0x01, 0x04, 0x08, 0x05, 0x51, 0x08, 0x80, 0x0A, 0x04, 0x0D, 0x04, 0x12, 0x0A, 0x15, 0x10, 
	0x17, 0x41, 0x19, 0x19, 0x1B, 0x80, 0x1C, 0x81, 0x1D, 0x08, 0x1E, 0x04, 0x20, 0x20, 0x22, 0x80, 
	0x23, 0x84, 0x25, 0xA0, 0x26, 0x0A, 0x2D, 0x08, 0x2F, 0x84, 0x31, 0xA4, 0x36, 0x81, 0x37, 0x08, 
	0x38, 0x40, 0x3A, 0x08, 0x3C, 0x20, 0x3E, 0x40, 
	/* CYDEV_UCFG_B0_P5_ROUTE_BASE + 0x00000080 */
	0x84, 0x80, 0x86, 0x08, 0x8E, 0x40, 0x8F, 0x44, 0x90, 0x40, 0x93, 0x20, 0x94, 0x20, 0x97, 0x04, 
	0x99, 0x44, 0x9B, 0x01, 0x9C, 0x04, 0x9E, 0x58, 0x9F, 0x80, 0xA5, 0x0A, 0xAE, 0x40, 0xAF, 0x08, 
	0xB3, 0x50, 0xC0, 0xF8, 0xC2, 0x23, 0xC4, 0xD3, 0xCA, 0xE0, 0xCC, 0xDE, 0xCE, 0x3A, 0xE0, 0x10, 
	0xE2, 0x08, 0xE4, 0x50, 0xE8, 0x20, 0xEC, 0x80, 
	0x01, 0x0C, 0x45, /* Base address 0x010C00 */
	/* CYDEV_UCFG_B0_P6_U0_BASE */
	0x00, 0x20, 0x01, 0x12, 0x02, 0x10, 0x03, 0x11, 0x05, 0x50, 0x07, 0x10, 0x08, 0x20, 0x09, 0x10, 
	0x0A, 0x10, 0x0B, 0x10, 0x0D, 0x10, 0x0F, 0x50, 0x10, 0x08, 0x11, 0x10, 0x12, 0x04, 0x13, 0x10, 
	0x14, 0x80, 0x15, 0x18, 0x16, 0x40, 0x17, 0x14, 0x18, 0x08, 0x19, 0x10, 0x1A, 0x04, 0x1B, 0x10, 
	0x1C, 0x80, 0x1D, 0x10, 0x1E, 0x40, 0x1F, 0x10, 0x21, 0x10, 0x23, 0x10, 0x24, 0x02, 0x25, 0x18, 
	0x26, 0x01, 0x27, 0x14, 0x29, 0x12, 0x2B, 0x11, 0x2C, 0x02, 0x2D, 0x10, 0x2E, 0x01, 0x2F, 0x10, 
	0x30, 0x03, 0x31, 0x03, 0x32, 0x0C, 0x33, 0x0C, 0x34, 0x30, 0x35, 0x20, 0x36, 0xC0, 0x37, 0x40, 
	0x38, 0xFF, 0x39, 0x2F, 0x3A, 0x55, 0x3B, 0x15, 0x3E, 0x55, 0x3F, 0x15, 0x58, 0x04, 0x59, 0x04, 
	0x5F, 0x01, 
	/* CYDEV_UCFG_B0_P6_U1_BASE */
	0x96, 0x08, 0x9E, 0x01, 0xA4, 0x0F, 0xAA, 0x04, 0xAE, 0x02, 0xB0, 0x01, 0xB2, 0x02, 0xB4, 0x04, 
	0xB6, 0x08, 0xD8, 0x04, 0xDB, 0x04, 0xDF, 0x01, 
	0x01, 0x0D, 0x1F, /* Base address 0x010D00 */
	/* CYDEV_UCFG_B0_P6_ROUTE_BASE */
	0x04, 0x20, 0x06, 0x40, 0x09, 0x88, 0x0D, 0x02, 0x0F, 0x16, 0x11, 0x04, 0x12, 0x0A, 0x16, 0x10, 
	0x17, 0x80, 0x19, 0x40, 0x1B, 0x29, 0x1C, 0x40, 0x1D, 0x84, 0x1F, 0x10, 0x26, 0x4A, 0x27, 0x09, 
	0x2F, 0x28, 0x34, 0x04, 0x3D, 0x04, 0x3E, 0x08, 0x3F, 0x41, 0x68, 0x06, 
	/* CYDEV_UCFG_B0_P6_ROUTE_BASE + 0x00000080 */
	0x88, 0x06, 0x8F, 0x01, 0xC0, 0x50, 0xC2, 0xF5, 0xC4, 0xA7, 0xCA, 0x60, 0xCC, 0x40, 0xCE, 0xD0, 
	0xE4, 0x10, 
	0x01, 0x15, 0x02, /* Base address 0x011500 */
	/* CYDEV_UCFG_B1_P2_ROUTE_BASE + 0x00000080 */
	0xB4, 0x01, 0xE8, 0x20, 
	0x01, 0x16, 0x43, /* Base address 0x011600 */
	/* CYDEV_UCFG_B1_P3_U0_BASE */
	0x01, 0x01, 0x03, 0x02, 0x05, 0x04, 0x07, 0x08, 0x09, 0x10, 0x0B, 0x20, 0x0D, 0x40, 0x0F, 0x80, 
	0x11, 0x02, 0x13, 0x01, 0x14, 0x03, 0x15, 0x80, 0x17, 0x40, 0x1C, 0x01, 0x1D, 0x08, 0x1E, 0x02, 
	0x1F, 0x04, 0x21, 0x20, 0x23, 0x10, 0x28, 0x02, 0x2A, 0x01, 0x33, 0xFF, 0x36, 0x03, 0x39, 0x08, 
	0x3F, 0x04, 0x58, 0x04, 0x59, 0x04, 0x5B, 0x04, 0x5C, 0x09, 0x5F, 0x01, 
	/* CYDEV_UCFG_B1_P3_U1_BASE */
	0x80, 0x08, 0x81, 0x02, 0x82, 0x04, 0x86, 0x01, 0x88, 0x20, 0x89, 0x80, 0x8A, 0x10, 0x8B, 0x50, 
	0x8C, 0x02, 0x8D, 0x01, 0x92, 0x01, 0x93, 0x20, 0x95, 0xD0, 0x96, 0x80, 0x97, 0x28, 0x98, 0x04, 
	0x99, 0x01, 0x9A, 0x08, 0xA2, 0x02, 0xA3, 0x50, 0xA7, 0x04, 0xA8, 0x10, 0xAA, 0x20, 0xAE, 0x40, 
	0xAF, 0x4A, 0xB1, 0x60, 0xB2, 0xFF, 0xB3, 0x80, 0xB5, 0x07, 0xB7, 0x18, 0xB8, 0x80, 0xBB, 0xB2, 
	0xBE, 0x44, 0xD8, 0x04, 0xD9, 0x04, 0xDC, 0x90, 0xDF, 0x01, 
	0x01, 0x17, 0x32, /* Base address 0x011700 */
	/* CYDEV_UCFG_B1_P3_ROUTE_BASE */
	0x00, 0x08, 0x01, 0x80, 0x02, 0x08, 0x03, 0x80, 0x09, 0x04, 0x0A, 0x04, 0x0B, 0x80, 0x0D, 0x08, 
	0x0E, 0x02, 0x10, 0x88, 0x12, 0x02, 0x17, 0x20, 0x18, 0x01, 0x19, 0x08, 0x1E, 0x02, 0x1F, 0x80, 
	0x20, 0x18, 0x21, 0x20, 0x22, 0x8A, 0x23, 0x20, 0x24, 0x20, 0x25, 0x0C, 0x29, 0x88, 0x2B, 0x80, 
	0x2F, 0x80, 0x31, 0x28, 0x32, 0x02, 0x35, 0x80, 0x36, 0x8A, 0x38, 0x10, 0x39, 0x01, 0x3B, 0x80, 
	0x3E, 0x55, 0x6C, 0x88, 0x6D, 0x01, 0x6E, 0x55, 
	/* CYDEV_UCFG_B1_P3_ROUTE_BASE + 0x00000080 */
	0x85, 0x20, 0x93, 0x80, 0x94, 0x20, 0xB0, 0x01, 0xB1, 0x80, 0xB3, 0x01, 0xC0, 0x0F, 0xC2, 0xAE, 
	0xC4, 0x4B, 0xCA, 0x8B, 0xCC, 0xD7, 0xCE, 0xFD, 0xEA, 0x01, 0xEE, 0x0F, 
	0x01, 0x19, 0x06, /* Base address 0x011900 */
	/* CYDEV_UCFG_B1_P4_ROUTE_BASE + 0x00000080 */
	0xB1, 0x50, 0xB2, 0x50, 0xE8, 0x80, 0xEA, 0x01, 0xEC, 0x80, 0xEE, 0x2F, 
	0x01, 0x1B, 0x02, /* Base address 0x011B00 */
	/* CYDEV_UCFG_B1_P5_ROUTE_BASE + 0x00000080 */
	0xE8, 0x20, 0xEC, 0x10, 
	0x01, 0x40, 0x04, /* Base address 0x014000 */
	/* CYDEV_UCFG_DSI0_BASE */
	0x32, 0x02, 0x33, 0x80, 0x36, 0x40, 
	/* CYDEV_UCFG_DSI0_BASE + 0x00000080 */
	0xCC, 0x70, 
	0x01, 0x41, 0x02, /* Base address 0x014100 */
	/* CYDEV_UCFG_DSI1_BASE + 0x00000080 */
	0xA6, 0x42, 0xA7, 0x80, 
	0x01, 0x42, 0x0E, /* Base address 0x014200 */
	/* CYDEV_UCFG_DSI2_BASE */
	0x33, 0x02, 0x37, 0x08, 0x3B, 0x01, 0x3F, 0x20, 0x40, 0x20, 0x51, 0x20, 
	/* CYDEV_UCFG_DSI2_BASE + 0x00000080 */
	0x87, 0x08, 0xA6, 0x42, 0xA7, 0x80, 0xCC, 0xC0, 0xCE, 0x60, 0xD0, 0x40, 0xD4, 0x20, 0xE2, 0x10, 
	0x01, 0x43, 0x0A, /* Base address 0x014300 */
	/* CYDEV_UCFG_DSI3_BASE + 0x00000080 */
	0x86, 0x02, 0x97, 0x01, 0x9C, 0x20, 0xA6, 0x42, 0xA7, 0x90, 0xAB, 0x02, 0xAD, 0x20, 0xC4, 0x40, 
	0xE2, 0x40, 0xEA, 0x30, 
	0x01, 0x44, 0x02, /* Base address 0x014400 */
	/* CYDEV_UCFG_DSI4_BASE */
	0x7C, 0x01, 
	/* CYDEV_UCFG_DSI4_BASE + 0x00000080 */
	0xDE, 0x01, 
	0x01, 0x45, 0x09, /* Base address 0x014500 */
	/* CYDEV_UCFG_DSI5_BASE */
	0x58, 0x04, 0x63, 0x40, 
	/* CYDEV_UCFG_DSI5_BASE + 0x00000080 */
	0x88, 0x04, 0x8B, 0x40, 0x94, 0x01, 0xD6, 0x02, 0xD8, 0x02, 0xE0, 0x04, 0xE4, 0x01, 
	0x01, 0x46, 0x04, /* Base address 0x014600 */
	/* CYDEV_UCFG_DSI6_BASE */
	0x44, 0x10, 
	/* CYDEV_UCFG_DSI6_BASE + 0x00000080 */
	0x85, 0x01, 0x94, 0x01, 0xD0, 0x01, 
	0x01, 0x47, 0x0E, /* Base address 0x014700 */
	/* CYDEV_UCFG_DSI7_BASE */
	0x0B, 0x42, 0x0D, 0x02, 0x0E, 0x02, 0x11, 0x11, 0x17, 0x88, 
	/* CYDEV_UCFG_DSI7_BASE + 0x00000080 */
	0x85, 0x02, 0x94, 0x01, 0x95, 0x01, 0x9C, 0x10, 0x9F, 0x08, 0xAB, 0x08, 0xC0, 0x03, 0xC2, 0x0F, 
	0xC4, 0x0F, 
	0x01, 0x48, 0x0D, /* Base address 0x014800 */
	/* CYDEV_UCFG_DSI8_BASE */
	0x21, 0x01, 0x26, 0x80, 0x32, 0x80, 
	/* CYDEV_UCFG_DSI8_BASE + 0x00000080 */
	0x86, 0x20, 0xA8, 0x20, 0xAB, 0x11, 0xAE, 0x40, 0xAF, 0x80, 0xC8, 0x60, 0xCC, 0x10, 0xE2, 0x10, 
	0xEA, 0x80, 0xEE, 0xF0, 
	0x01, 0x49, 0x04, /* Base address 0x014900 */
	/* CYDEV_UCFG_DSI9_BASE */
	0x76, 0x20, 
	/* CYDEV_UCFG_DSI9_BASE + 0x00000080 */
	0x9A, 0x20, 0xB1, 0x01, 0xDE, 0x20, 
	0x01, 0x4C, 0x09, /* Base address 0x014C00 */
	/* CYDEV_UCFG_DSI12_BASE */
	0x5C, 0x01, 
	/* CYDEV_UCFG_DSI12_BASE + 0x00000080 */
	0x94, 0x01, 0x9C, 0x10, 0xAA, 0x01, 0xAB, 0x81, 0xAD, 0x10, 0xAF, 0x40, 0xC6, 0x0E, 0xD6, 0x01, 
	0x01, 0x4D, 0x04, /* Base address 0x014D00 */
	/* CYDEV_UCFG_DSI13_BASE + 0x00000080 */
	0xB0, 0x10, 0xB4, 0x01, 0xE8, 0x04, 0xEC, 0x08, 
	0x01, 0x50, 0x03, /* Base address 0x015000 */
	/* CYREG_BCTL1_MDCLK_EN */
	0x11, 0x01, 0x12, 0x14, 0x1B, 0x01, 
	0x01, 0x51, 0x01, /* Base address 0x015100 */
	/* CYREG_IDMUX_DRQ_CTL0 */
	0x14, 0x02, 
};
/* BYTES: 2042 */

/* IDMUX_IRQ Address: CYREG_IDMUX_IRQ_CTL0 Size (bytes): 8 */
static const uint8 CYCODE BS_IDMUX_IRQ_VAL[] = {
	0x2A, 0x00, 0x00, 0x8A, 0x02, 0x02, 0x00, 0x00};

/* UCFG_BCTL0 Address: CYREG_BCTL0_MDCLK_EN Size (bytes): 16 */
static const uint8 CYCODE BS_UCFG_BCTL0_VAL[] = {
	0x01, 0x01, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01, 0x01, 0x00, 0x01, 0x00};

/* IOPINS0_0 Address: CYREG_PRT0_DM0 Size (bytes): 8 */
static const uint8 CYCODE BS_IOPINS0_0_VAL[] = {
	0x00, 0x11, 0x11, 0x01, 0x00, 0x00, 0x08, 0x00};

/* IOPINS0_1 Address: CYREG_PRT1_DR Size (bytes): 10 */
static const uint8 CYCODE BS_IOPINS0_1_VAL[] = {
	0x00, 0x00, 0x00, 0x14, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00};

/* IOPINS0_7 Address: CYREG_PRT12_DM0 Size (bytes): 8 */
static const uint8 CYCODE BS_IOPINS0_7_VAL[] = {
	0x00, 0x0C, 0x0C, 0x00, 0x0C, 0x00, 0x00, 0x00};

/* IOPINS0_8 Address: CYREG_PRT15_DR Size (bytes): 10 */
static const uint8 CYCODE BS_IOPINS0_8_VAL[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00};

/* IOPINS0_2 Address: CYREG_PRT2_DM0 Size (bytes): 8 */
static const uint8 CYCODE BS_IOPINS0_2_VAL[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xF8, 0x00};

/* CYDEV_CLKDIST_ACFG0_CFG0 Address: CYREG_CLKDIST_ACFG0_CFG0 Size (bytes): 4 */
static const uint8 CYCODE BS_CYDEV_CLKDIST_ACFG0_CFG0_VAL[] = {
	0x03, 0x00, 0x19, 0x01};

#define CFG_MEMCPY_COUNT (sizeof(cfg_memcpy_list)/sizeof(*cfg_memcpy_list))
static const cfg_memcpy_t CYCODE cfg_memcpy_list [] = {
	/* dest, src, size */
	{(void CYFAR *)(CYREG_IDMUX_IRQ_CTL0), BS_IDMUX_IRQ_VAL, 8},
	{(void CYFAR *)(CYREG_BCTL0_MDCLK_EN), BS_UCFG_BCTL0_VAL, 16},
};


extern void cfg_write_bytes_code(void CYCODE *table);
extern void cfg_write_bytes(void CYFAR *table);

/*******************************************************************************
* Function Name: ClockSetup
********************************************************************************
*
* Summary:
*  Performs the initialization of all of the clocks in the device based on the
*  settings in the Clock tab of the DWR.  This includes enabling the requested
*  clocks and setting the necessary dividers to produce the desired frequency. 
*
* Parameters:
*  void
*
* Return:
*  void
*
*******************************************************************************/
static void ClockSetup(void)
{
	reg32  timeout;
	reg32* timeout_p = &timeout;
	reg8   pllLock;


	/* Configure Digital Clocks based on settings from Clock DWR */
	CY_SET_XTND_REG24((void CYFAR *)(CYREG_CLKDIST_DCFG0_CFG0), 0x1A0008);
	CY_SET_XTND_REG24((void CYFAR *)(CYREG_CLKDIST_DCFG1_CFG0), 0x190001);

	/* Configure Analog Clocks based on settings from Clock DWR */
	CYCONFIGCPYCODE((void CYFAR *)(CYREG_CLKDIST_ACFG0_CFG0), (void CYCODE *)(BS_CYDEV_CLKDIST_ACFG0_CFG0_VAL), 4);

	/* Configure ILO based on settings from Clock DWR */
	CY_SET_REG8((void CYXDATA *)(CYREG_SLOWCLK_ILO_CR0), 0x06);

	/* Configure XTAL based on settings from Clock DWR */
	CY_SET_REG8((void CYXDATA *)(CYREG_FASTCLK_XMHZ_CFG0), 0x16);
	CY_SET_REG8((void CYXDATA *)(CYREG_FASTCLK_XMHZ_CSR), 0x01);
	/* Wait up to 130000us for the XTAL to lock */
	CY_GET_REG8(CYREG_FASTCLK_XMHZ_CSR);
	for (timeout = 130000 / 10; *timeout_p && (CY_GET_REG8(CYREG_FASTCLK_XMHZ_CSR) & 0x80u); timeout--) { 
		
		CyDelayCycles(10 * 48); /* Delay 10us based on 48MHz clock */
	}
	if (*timeout_p == 0)
		CyClockStartupError(CYCLOCKSTART_XTAL_ERROR);

	/* Configure PLL based on settings from Clock DWR */
	CY_SET_XTND_REG16((void CYFAR *)(CYREG_FASTCLK_PLL_P), 0x0815);
	CY_SET_REG8((void CYXDATA *)(CYREG_CLKDIST_CR), 0x01);
	CY_SET_XTND_REG16((void CYFAR *)(CYREG_FASTCLK_PLL_CFG0), 0x1051);
	/* Wait up to 250us for the PLL to lock */
	pllLock = 0;
	for (timeout = 250 / 10; *timeout_p && (pllLock != 0x03u); timeout--) { 
		pllLock = 0x03u & ((pllLock << 1) | ((CY_GET_REG8(CYREG_FASTCLK_PLL_SR) & 0x01u) >> 0));
		CyDelayCycles(10 * 48); /* Delay 10us based on 48MHz clock */
	}

	/* Configure Bus/Master Clock based on settings from Clock DWR */
	CY_SET_XTND_REG16((void CYFAR *)(CYREG_CLKDIST_MSTR0), 0x0103);
	CY_SET_REG8((void CYXDATA *)(CYREG_CLKDIST_MSTR0), 0x00);

	/* Configure IMO based on settings from Clock DWR */
	CY_SET_REG8((void CYXDATA *)(CYREG_FASTCLK_IMO_CR), 0x52);
	CY_SET_REG8((void CYXDATA *)(CYREG_IMO_TR1), (CY_GET_XTND_REG8(CYREG_FLSHID_CUST_TABLES_IMO_USB)));
	CY_SET_REG8((void CYXDATA *)(CYREG_CLKDIST_MSTR0), 0x07);
	CY_SET_REG8((void CYXDATA *)(CYREG_CLKDIST_BCFG0), 0x00);
	CY_SET_REG8((void CYXDATA *)(CYREG_CLKDIST_BCFG2), 0x48);
	CY_SET_REG8((void CYXDATA *)(CYREG_CLKDIST_MSTR0), 0x00);

	/* Configure USB Clock based on settings from Clock DWR */
	CY_SET_REG8((void CYXDATA *)(CYREG_CLKDIST_UCFG), 0x00);
	CY_SET_REG8((void CYXDATA *)(CYREG_CLKDIST_LD), 0x02);

	CY_SET_REG8((void CYXDATA *)(CYREG_PM_ACT_CFG2), ((CY_GET_REG8(CYREG_PM_ACT_CFG2) | 0x03)));
	CY_SET_REG8((void CYXDATA *)(CYREG_PM_ACT_CFG1), ((CY_GET_REG8(CYREG_PM_ACT_CFG1) | 0x01)));
	CY_SET_REG8((void CYXDATA *)(CYREG_PM_ACT_CFG0), ((CY_GET_REG8(CYREG_PM_ACT_CFG0) | 0x80)));
}


/* Analog API Functions */

/*******************************************************************************
* Function Name: AnalogSetDefault
********************************************************************************
*
* Summary:
*  Sets up the analog portions of the chip to default values based on chip
*  configuration options from the project.
*
* Parameters:
*  void
*
* Return:
*  void
*
*******************************************************************************/
void AnalogSetDefault(void)
{
	uint8 bg_xover_inl_trim = CY_GET_XTND_REG8(CYREG_FLSHID_MFG_CFG_BG_XOVER_INL_TRIM + 1u);
	CY_SET_REG8(CYREG_BG_DFT0, bg_xover_inl_trim & 0x07u);
	CY_SET_REG8(CYREG_BG_DFT1, (bg_xover_inl_trim >> 4) & 0x0Fu);
	CY_SET_REG16(CYREG_PRT2_AMUX, 0x38C0);
	CY_SET_REG8(CYREG_DAC2_SW3, 0x01);
	CY_SET_REG8(CYREG_DSM0_SW0, 0x03);
	CY_SET_REG8(CYREG_DSM0_SW4, 0x08);
	CY_SET_REG8(CYREG_PUMP_CR0, 0x66);
}

#define CY_AMUX_UNUSED CYREG_BOOST_SR


/*******************************************************************************
* Function Name: cyfitter_cfg
********************************************************************************
* Summary:
*  This function is called by the start-up code for the selected device. It
*  performs all of the necessary device configuration based on the design
*  settings.  This includes settings from the Design Wide Resources (DWR) such
*  as Clocks and Pins as well as any component configuration that is necessary.
*
* Parameters:  
*   void
*
* Return:
*   void
*
*******************************************************************************/
void cyfitter_cfg(void)
{
	/* Setup Flash Cycles based on 48MHz clock startup frequency. */
	CY_SET_REG8((void CYXDATA *)(CYREG_CACHE_CR), ((CYDEV_INSTRUCT_CACHE_ENABLED) ? 0xF1 : 0xC0));
	/* Enable/Disable Debug functionality based on settings from System DWR */
	CY_SET_XTND_REG8(CYREG_MLOGIC_DEBUG, (CY_GET_XTND_REG8(CYREG_MLOGIC_DEBUG) | 0x05));

	{
		uint8 CYDATA i;

		/* Zero out critical memory blocks before beginning configuration */
		for (i = 0; i < CFG_MEMSET_COUNT; i++)
		{
			const cfg_memset_t CYCODE * CYDATA ms = &cfg_memset_list[i];
			CYMEMZERO(ms->address, ms->size);
		}

		/* Copy device configuration data into registers */
		for (i = 0; i < CFG_MEMCPY_COUNT; i++)
		{
			const cfg_memcpy_t CYCODE * CYDATA mc = &cfg_memcpy_list[i];
			void * CYDATA dest = mc->dest;
			const void CYCODE * CYDATA src = mc->src;
			uint16 CYDATA size = mc->size;
			CYCONFIGCPYCODE(dest, src, size);
		}

		cfg_write_bytes_code(cfg_byte_table);

		/* Perform normal device configuration. Order is not critical for these items. */
		CYMEMZERO((void CYFAR *)(CYREG_PHUB_CFGMEM16_CFG0), 4);

		/* Enable digital routing */
		CY_SET_XTND_REG8(CYREG_BCTL0_BANK_CTL, CY_GET_XTND_REG8(CYREG_BCTL0_BANK_CTL) | 0x02u);
		CY_SET_XTND_REG8(CYREG_BCTL1_BANK_CTL, CY_GET_XTND_REG8(CYREG_BCTL1_BANK_CTL) | 0x02u);

		/* Enable UDB array */
		CY_SET_REG8(CYREG_PM_ACT_CFG0, CY_GET_REG8(CYREG_PM_ACT_CFG0) | 0x40u);
		CY_SET_REG8(CYREG_PM_AVAIL_CR2, CY_GET_REG8(CYREG_PM_AVAIL_CR2) | 0x10u);
	}

	/* Perform second pass device configuration. These items must be configured in specific order after the regular configuration is done. */
	CYCONFIGCPYCODE((void CYFAR *)(CYREG_PRT0_DM0), (void CYCODE *)(BS_IOPINS0_0_VAL), 8);
	CYCONFIGCPYCODE((void CYFAR *)(CYREG_PRT1_DR), (void CYCODE *)(BS_IOPINS0_1_VAL), 10);
	CYCONFIGCPYCODE((void CYFAR *)(CYREG_PRT12_DM0), (void CYCODE *)(BS_IOPINS0_7_VAL), 8);
	CYCONFIGCPYCODE((void CYFAR *)(CYREG_PRT15_DR), (void CYCODE *)(BS_IOPINS0_8_VAL), 10);
	CYCONFIGCPYCODE((void CYFAR *)(CYREG_PRT2_DM0), (void CYCODE *)(BS_IOPINS0_2_VAL), 8);
	CY_SET_REG8((void CYXDATA *)(CYREG_INTC_CSR_EN), 0x01);
	CY_SET_REG8((void CYXDATA *)(CYREG_PWRSYS_WAKE_TR2), 0x3A);


	/* Set Flash Cycles based on max possible frequency in case a glitch occurs during ClockSetup(). */
	CY_SET_REG8((void CYXDATA *)(CYREG_CACHE_CR), ((CYDEV_INSTRUCT_CACHE_ENABLED) ? 0x31 : 0x00));
	/* Setup clocks based on selections from Clock DWR */
	ClockSetup();
	/* Set Flash Cycles based on newly configured 56.00MHz Bus Clock. */
	CY_SET_REG8((void CYXDATA *)(CYREG_CACHE_CR), ((CYDEV_INSTRUCT_CACHE_ENABLED) ? 0xF1 : 0xC0));
	CY_SET_XTND_REG8((void CYFAR *)(CYREG_BCTL0_UDB_TEST_3), 0x40);
	CY_SET_XTND_REG8((void CYFAR *)(CYREG_BCTL1_UDB_TEST_3), 0x40);

	/* Perform basic analog initialization to defaults */
	AnalogSetDefault();

	/* Configure alternate active mode */
	CYCONFIGCPY((void CYFAR *)CYDEV_PM_STBY_BASE, (void CYFAR *)CYDEV_PM_ACT_BASE, 14);
	CY_SET_REG8(CYREG_PM_STBY_CFG0, CY_GET_REG8(CYREG_PM_STBY_CFG0) & ~0x02u);	/* Disable CPU */
}
