/*******************************************************************************
* File Name: USBFS_1.h
* Version 1.60
*
* Description:
*  Header File for the USFS component. Contains prototypes and constant values.
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions,
* disclaimers, and limitations in the end user license agreement accompanying
* the software package with which this file was provided.
********************************************************************************/

#if !defined(CY_USBFS_USBFS_1_H)
#define CY_USBFS_USBFS_1_H

#include "cytypes.h"
#include "cydevice_trm.h"
#include "cyfitter.h"


/***************************************
* Conditional Compilation Parameters
***************************************/

/* PSoC3 ES2 or early */
#define USBFS_1_PSOC3_ES2  ((CYDEV_CHIP_MEMBER_USED == CYDEV_CHIP_MEMBER_3A) && \
                                     (CYDEV_CHIP_REVISION_USED <= CYDEV_CHIP_REVISION_3A_ES2))

/* PSoC5 ES1 or early */
#define USBFS_1_PSOC5_ES1  ((CYDEV_CHIP_MEMBER_USED == CYDEV_CHIP_MEMBER_5A) && \
                                     (CYDEV_CHIP_REVISION_USED <= CYDEV_CHIP_REVISION_5A_ES1))
/* PSoC3 ES3 or later */
#define USBFS_1_PSOC3_ES3  ((CYDEV_CHIP_MEMBER_USED == CYDEV_CHIP_MEMBER_3A) && \
                                     (CYDEV_CHIP_REVISION_USED > CYDEV_CHIP_REVISION_3A_ES2))

/* PSoC3 ES3 or early */
#define USBFS_1_PSOC3_UPTO_ES3 ((CYDEV_CHIP_MEMBER_USED == CYDEV_CHIP_MEMBER_3A) && \
                                         (CYDEV_CHIP_REVISION_USED <= CYDEV_CHIP_REVISION_3A_ES3))

/* PSoC5 ES2 or later */
#define USBFS_1_PSOC5_ES2  ((CYDEV_CHIP_MEMBER_USED == CYDEV_CHIP_MEMBER_5A) && \
                                     (CYDEV_CHIP_REVISION_USED > CYDEV_CHIP_REVISION_5A_ES1))


#if(USBFS_1_PSOC3_ES2)
    #include <intrins.h>
    #define USBFS_1_ISR_PATCH() _nop_(); _nop_(); _nop_(); _nop_(); _nop_(); _nop_(); _nop_(); _nop_();
#endif  /* End PSOC3_ES2 */


/***************************************
*  Memory Type Definitions
***************************************/

/* Renamed Type Definitions for backward compatibility. 
*  Should not be used in new designs. 
*/
#define USBFS_1_CODE CYCODE
#define USBFS_1_FAR CYFAR
#if defined(__C51__) || defined(__CX51__)
    #define USBFS_1_DATA data
    #define USBFS_1_XDATA xdata
#else
    #define USBFS_1_DATA
    #define USBFS_1_XDATA
#endif /* End __C51__ */


/***************************************
*    Initial Parameter Constants
***************************************/

#define USBFS_1_NUM_DEVICES   1
#define USBFS_1_ENABLE_DESCRIPTOR_STRINGS   
#define USBFS_1_ENABLE_SN_STRING   
#define USBFS_1_ENABLE_STRINGS   
#define USBFS_1_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_IN_BUF_SIZE   65
#define USBFS_1_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_NUM_IN_RPTS   1
#define USBFS_1_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_OUT_BUF_SIZE   65
#define USBFS_1_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_NUM_OUT_RPTS   1
#define USBFS_1_DEVICE0_CONFIGURATION0_INTERFACE0_ALTERNATE0_HID_COUNT   1
#define USBFS_1_ENABLE_HID_CLASS   
#define USBFS_1_HID_RPT_1_SIZE_LSB   0x24u
#define USBFS_1_HID_RPT_1_SIZE_MSB   0x00u
#define USBFS_1_HID_RPT_2_SIZE_LSB   0x24u
#define USBFS_1_HID_RPT_2_SIZE_MSB   0x00u
#define USBFS_1_HID_RPT_3_SIZE_LSB   0x24u
#define USBFS_1_HID_RPT_3_SIZE_MSB   0x00u
#define USBFS_1_HID_RPT_4_SIZE_LSB   0x24u
#define USBFS_1_HID_RPT_4_SIZE_MSB   0x00u
#define USBFS_1_MAX_REPORTID_NUMBER   0

#define USBFS_1_MON_VBUS                       (0u)
#define USBFS_1_EXTERN_VND                     (0u)
#define USBFS_1_EXTERN_CLS                     (0u)
#define USBFS_1_MAX_INTERFACES_NUMBER          (1u)
#define USBFS_1_EP0_ISR_REMOVE                 (0u)
#define USBFS_1_EP1_ISR_REMOVE                 (0u)
#define USBFS_1_EP2_ISR_REMOVE                 (0u)
#define USBFS_1_EP3_ISR_REMOVE                 (1u)
#define USBFS_1_EP4_ISR_REMOVE                 (1u)
#define USBFS_1_EP5_ISR_REMOVE                 (1u)
#define USBFS_1_EP6_ISR_REMOVE                 (1u)
#define USBFS_1_EP7_ISR_REMOVE                 (1u)
#define USBFS_1_EP8_ISR_REMOVE                 (1u)


/***************************************
*    Data Struct Definition
***************************************/

typedef struct _USBFS_1_EpCtlBlock 
{
    uint8  attrib;
    uint8  apiEpState;
    uint8  hwEpState;
    uint8  epToggle;
    uint8  addr;
    uint8  epMode;
    uint16 buffOffset;
    uint16 bufferSize;
} T_USBFS_1_EP_CTL_BLOCK;

typedef struct _USBFS_1_EpSettingsBlock 
{
    uint8  interface;
    uint8  altSetting;
    uint8  addr;
    uint8  attributes;
    uint16 bufferSize;
    uint8  bMisc;
} T_USBFS_1_EP_SETTINGS_BLOCK;

typedef struct _USBFS_1_XferStatusBlock
{
    uint8  status;
    uint16 length;
} T_USBFS_1_XFER_STATUS_BLOCK;

typedef struct _USBFS_1_Td
{
    uint16  count;
    volatile uint8 *pData;
    T_USBFS_1_XFER_STATUS_BLOCK *pStatusBlock;
} T_USBFS_1_TD;

typedef struct _USBFS_1_Lut
{
    uint8   c;
    void    *p_list;
} T_USBFS_1_LUT;

/* Resume/Suspend API Support */
typedef struct _USBFS_1_BackupStruct
{
    uint8 enableState;
    uint8 mode;
    
    uint8 pll;
    uint8 imo;
    uint32 clk;
} USBFS_1_BACKUP_STRUCT;


/* Renamed struct fields for backward compatibility. 
*  Should not be used in new designs. 
*/
#define wBuffOffset         buffOffset
#define wBufferSize         bufferSize
#define bStatus             status
#define wLength             length
#define wCount              count

/* Renamed global variable for backward compatibility. 
*  Should not be used in new designs. 
*/
#define currentTD           USBFS_1_currentTD


/***************************************
*       Function Prototypes
***************************************/

void   USBFS_1_Start(uint8 device, uint8 mode);
void   USBFS_1_Init(void);
void   USBFS_1_InitComponent(uint8 device, uint8 mode);
void   USBFS_1_Stop(void) ;
uint8  USBFS_1_CheckActivity(void) ;
uint8  USBFS_1_GetConfiguration(void) ;
uint8  USBFS_1_GetInterfaceSetting(uint8 interfaceNumber) \
                                                        ;
uint8  USBFS_1_GetEPState(uint8 epNumber) ;
uint16 USBFS_1_GetEPCount(uint8 epNumber) ;
void   USBFS_1_LoadInEP(uint8 epNumber, uint8 *pData, uint16 length);
uint16 USBFS_1_ReadOutEP(uint8 epNumber, uint8 *pData, uint16 length);
void   USBFS_1_EnableOutEP(uint8 epNumber);
void   USBFS_1_DisableOutEP(uint8 epNumber) ;
void   USBFS_1_Force(uint8 bState) ;
uint8  USBFS_1_GetEPAckState(uint8 epNumber) ;
void   USBFS_1_SetPowerStatus(uint8 powerStatus);
uint8  USBFS_1_RWUEnabled(void) ;
void   USBFS_1_SerialNumString(uint8 *snString);
void   USBFS_1_TerminateEP(uint8 ep);

void   USBFS_1_Suspend(void);
void   USBFS_1_Resume(void) ;

#if (USBFS_1_MON_VBUS == 1u)
    uint8  USBFS_1_VBusPresent(void) ;
#endif /* End USBFS_1_MON_VBUS */

#if defined(CYDEV_BOOTLOADER_IO_COMP) && ((CYDEV_BOOTLOADER_IO_COMP == CyBtldr_USBFS_1) || \
                                          (CYDEV_BOOTLOADER_IO_COMP == CyBtldr_Custom_Interface))

    void USBFS_1_CyBtldrCommStart(void);
    void USBFS_1_CyBtldrCommStop(void) ;
    void USBFS_1_CyBtldrCommReset(void);
    cystatus USBFS_1_CyBtldrCommWrite(uint8 *pData, uint16 size, uint16 *count, uint8 timeOut);
    cystatus USBFS_1_CyBtldrCommRead( uint8 *pData, uint16 size, uint16 *count, uint8 timeOut);

    #define USBFS_1_BTLDR_SIZEOF_WRITE_BUFFER      (64u)    /* EP 1 OUT */
    #define USBFS_1_BTLDR_SIZEOF_READ_BUFFER       (64u)    /* EP 2 IN */
    #define USBFS_1_BTLDR_MAX_PACKET_SIZE          USBFS_1_BTLDR_SIZEOF_WRITE_BUFFER

    /* These defines active if used USBFS interface as an IO Component for bootloading.
    *  When Custom_Interface selected in Bootloder configuration as the IO Component, user must provide these functions
    */    
    #if (CYDEV_BOOTLOADER_IO_COMP == CyBtldr_USBFS_1)    
        #define CyBtldrCommStart        USBFS_1_CyBtldrCommStart
        #define CyBtldrCommStop         USBFS_1_CyBtldrCommStop
        #define CyBtldrCommReset        USBFS_1_CyBtldrCommReset
        #define CyBtldrCommWrite        USBFS_1_CyBtldrCommWrite
        #define CyBtldrCommRead         USBFS_1_CyBtldrCommRead
    #endif  /*End   CYDEV_BOOTLOADER_IO_COMP == CyBtldr_USBFS_1 */

#endif /* End CYDEV_BOOTLOADER_IO_COMP  */

/* Renamed Functions for backward compatibility. 
*  Should not be used in new designs. 
*/

#define USBFS_1_bCheckActivity             USBFS_1_CheckActivity
#define USBFS_1_bGetConfiguration          USBFS_1_GetConfiguration
#define USBFS_1_bGetInterfaceSetting       USBFS_1_GetInterfaceSetting
#define USBFS_1_bGetEPState                USBFS_1_GetEPState
#define USBFS_1_wGetEPCount                USBFS_1_GetEPCount
#define USBFS_1_bGetEPAckState             USBFS_1_GetEPAckState
#define USBFS_1_bRWUEnabled                USBFS_1_RWUEnabled
#define USBFS_1_bVBusPresent               USBFS_1_VBusPresent

#define USBFS_1_bConfiguration             USBFS_1_configuration
#define USBFS_1_bInterfaceSetting          USBFS_1_interfaceSetting
#define USBFS_1_bDeviceAddress             USBFS_1_deviceAddress
#define USBFS_1_bDeviceStatus              USBFS_1_deviceStatus
#define USBFS_1_bEPHalt                    USBFS_1_epHalt
#define USBFS_1_bDevice                    USBFS_1_device
#define USBFS_1_bTransferState             USBFS_1_transferState
#define USBFS_1_bLastPacketSize            USBFS_1_lastPacketSize

#define USBFS_1_LoadEP                     USBFS_1_LoadInEP
#define USBFS_1_LoadInISOCEP               USBFS_1_LoadInEP
#define USBFS_1_EnableOutISOCEP(e)         USBFS_1_EnableOutEP(e)

#define USBFS_1_SetVector                  CyIntSetVector
#define USBFS_1_SetPriority                CyIntSetPriority
#define USBFS_1_EnableInt(a, b)            CyIntEnable(a)


/***************************************
*          API Constants
***************************************/

#define USBFS_1_EP0                        (0u)
#define USBFS_1_EP1                        (1u)
#define USBFS_1_EP2                        (2u)
#define USBFS_1_EP3                        (3u)
#define USBFS_1_EP4                        (4u)
#define USBFS_1_EP5                        (5u)
#define USBFS_1_EP6                        (6u)
#define USBFS_1_EP7                        (7u)
#define USBFS_1_EP8                        (8u)
#define USBFS_1_MAX_EP                     (9u)

#define USBFS_1_TRUE                       (1u)
#define USBFS_1_FALSE                      (0u)

#define USBFS_1_NULL                       ((void *) 0)

#define USBFS_1_NO_EVENT_ALLOWED           (2u)
#define USBFS_1_EVENT_PENDING              (1u)
#define USBFS_1_NO_EVENT_PENDING           (0u)

#define USBFS_1_IN_BUFFER_FULL             USBFS_1_NO_EVENT_PENDING
#define USBFS_1_IN_BUFFER_EMPTY            USBFS_1_EVENT_PENDING
#define USBFS_1_OUT_BUFFER_FULL            USBFS_1_EVENT_PENDING
#define USBFS_1_OUT_BUFFER_EMPTY           USBFS_1_NO_EVENT_PENDING

#define USBFS_1_FORCE_J                    (0xA0u)
#define USBFS_1_FORCE_K                    (0x80u)
#define USBFS_1_FORCE_SE0                  (0xC0u)
#define USBFS_1_FORCE_NONE                 (0x00u)

#define USBFS_1_IDLE_TIMER_RUNNING         (0x02u)
#define USBFS_1_IDLE_TIMER_EXPIRED         (0x01u)
#define USBFS_1_IDLE_TIMER_INDEFINITE      (0x00u)

#define USBFS_1_DEVICE_STATUS_BUS_POWERED  (0x00u)
#define USBFS_1_DEVICE_STATUS_SELF_POWERED (0x01u)

#define USBFS_1_3V_OPERATION               (0x00u)
#define USBFS_1_5V_OPERATION               (0x01u)
#define USBFS_1_DWR_VDDD_OPERATION         (0x02u)


#define USBFS_1_MODE_DISABLE               (0x00u)
#define USBFS_1_MODE_NAK_IN_OUT            (0x01u)
#define USBFS_1_MODE_STATUS_OUT_ONLY       (0x02u)
#define USBFS_1_MODE_STALL_IN_OUT          (0x03u)
#define USBFS_1_MODE_RESERVED_0100         (0x04u)
#define USBFS_1_MODE_ISO_OUT               (0x05u)
#define USBFS_1_MODE_STATUS_IN_ONLY        (0x06u)
#define USBFS_1_MODE_ISO_IN                (0x07u)
#define USBFS_1_MODE_NAK_OUT               (0x08u)
#define USBFS_1_MODE_ACK_OUT               (0x09u)
#define USBFS_1_MODE_RESERVED_1010         (0x0Au)
#define USBFS_1_MODE_ACK_OUT_STATUS_IN     (0x0Bu)
#define USBFS_1_MODE_NAK_IN                (0x0Cu)
#define USBFS_1_MODE_ACK_IN                (0x0Du)
#define USBFS_1_MODE_RESERVED_1110         (0x0Eu)
#define USBFS_1_MODE_ACK_IN_STATUS_OUT     (0x0Fu)
#define USBFS_1_MODE_MASK                  (0x0Fu)
#define USBFS_1_MODE_STALL_DATA_EP         (0x80u)

#define USBFS_1_MODE_ACKD                  (0x10u)
#define USBFS_1_MODE_OUT_RCVD              (0x20u)
#define USBFS_1_MODE_IN_RCVD               (0x40u)
#define USBFS_1_MODE_SETUP_RCVD            (0x80u)

#define USBFS_1_RQST_TYPE_MASK             (0x60u)
#define USBFS_1_RQST_TYPE_STD              (0x00u)
#define USBFS_1_RQST_TYPE_CLS              (0x20u)
#define USBFS_1_RQST_TYPE_VND              (0x40u)
#define USBFS_1_RQST_DIR_MASK              (0x80u)
#define USBFS_1_RQST_DIR_D2H               (0x80u)
#define USBFS_1_RQST_DIR_H2D               (0x00u)
#define USBFS_1_RQST_RCPT_MASK             (0x03u)
#define USBFS_1_RQST_RCPT_DEV              (0x00u)
#define USBFS_1_RQST_RCPT_IFC              (0x01u)
#define USBFS_1_RQST_RCPT_EP               (0x02u)
#define USBFS_1_RQST_RCPT_OTHER            (0x03u)

/* Standard Request Types (Table 9-4) */
#define USBFS_1_GET_STATUS                 (0x00u)
#define USBFS_1_CLEAR_FEATURE              (0x01u)
#define USBFS_1_SET_FEATURE                (0x03u)
#define USBFS_1_SET_ADDRESS                (0x05u)
#define USBFS_1_GET_DESCRIPTOR             (0x06u)
#define USBFS_1_SET_DESCRIPTOR             (0x07u)
#define USBFS_1_GET_CONFIGURATION          (0x08u)
#define USBFS_1_SET_CONFIGURATION          (0x09u)
#define USBFS_1_GET_INTERFACE              (0x0Au)
#define USBFS_1_SET_INTERFACE              (0x0Bu)
#define USBFS_1_SYNCH_FRAME                (0x0Cu)

/* Vendor Specific Request Types */
/* Request for Microsoft OS String Descriptor*/
#define USBFS_1_GET_EXTENDED_CONFIG_DESCRIPTOR (0x01u)

/* Descriptor Types (Table 9-5) */
#define USBFS_1_DESCR_DEVICE                   (1u)
#define USBFS_1_DESCR_CONFIG                   (2u)
#define USBFS_1_DESCR_STRING                   (3u)
#define USBFS_1_DESCR_INTERFACE                (4u)
#define USBFS_1_DESCR_ENDPOINT                 (5u)
#define USBFS_1_DESCR_DEVICE_QUALIFIER         (6u)
#define USBFS_1_DESCR_OTHER_SPEED              (7u)
#define USBFS_1_DESCR_INTERFACE_POWER          (8u)

/* Device Descriptor Defines */
#define USBFS_1_DEVICE_DESCR_LENGTH            (18u)
#define USBFS_1_DEVICE_DESCR_SN_SHIFT          (16u)

/* Config Descriptor Shifts and Masks */
#define USBFS_1_CONFIG_DESCR_LENGTH                (0u)
#define USBFS_1_CONFIG_DESCR_TYPE                  (1u)
#define USBFS_1_CONFIG_DESCR_TOTAL_LENGTH_LOW      (2u)
#define USBFS_1_CONFIG_DESCR_TOTAL_LENGTH_HI       (3u)
#define USBFS_1_CONFIG_DESCR_NUM_INTERFACES        (4u)
#define USBFS_1_CONFIG_DESCR_CONFIG_VALUE          (5u)
#define USBFS_1_CONFIG_DESCR_CONFIGURATION         (6u)
#define USBFS_1_CONFIG_DESCR_ATTRIB                (7u)
#define USBFS_1_CONFIG_DESCR_ATTRIB_SELF_POWERED   (0x40u)
#define USBFS_1_CONFIG_DESCR_ATTRIB_RWU_EN         (0x20u)

/* Feature Selectors (Table 9-6) */
#define USBFS_1_DEVICE_REMOTE_WAKEUP           (0x01u)
#define USBFS_1_ENDPOINT_HALT                  (0x00u)
#define USBFS_1_TEST_MODE                      (0x02u)

/* USB Device Status (Figure 9-4) */
#define USBFS_1_DEVICE_STATUS_BUS_POWERED      (0x00u)
#define USBFS_1_DEVICE_STATUS_SELF_POWERED     (0x01u)
#define USBFS_1_DEVICE_STATUS_REMOTE_WAKEUP    (0x02u)

/* USB Endpoint Status (Figure 9-4) */
#define USBFS_1_ENDPOINT_STATUS_HALT           (0x01u)

/* USB Endpoint Directions */
#define USBFS_1_DIR_IN                         (0x80u)
#define USBFS_1_DIR_OUT                        (0x00u)
#define USBFS_1_DIR_UNUSED                     (0x7Fu)

/* USB Endpoint Attributes */
#define USBFS_1_EP_TYPE_CTRL                   (0x00u)
#define USBFS_1_EP_TYPE_ISOC                   (0x01u)
#define USBFS_1_EP_TYPE_BULK                   (0x02u)
#define USBFS_1_EP_TYPE_INT                    (0x03u)
#define USBFS_1_EP_TYPE_MASK                   (0x03u)

#define USBFS_1_EP_SYNC_TYPE_NO_SYNC           (0x00u)
#define USBFS_1_EP_SYNC_TYPE_ASYNC             (0x04u)
#define USBFS_1_EP_SYNC_TYPE_ADAPTIVE          (0x08u)
#define USBFS_1_EP_SYNC_TYPE_SYNCHRONOUS       (0x0Cu)
#define USBFS_1_EP_SYNC_TYPE_MASK              (0x0Cu)

#define USBFS_1_EP_USAGE_TYPE_DATA             (0x00u)
#define USBFS_1_EP_USAGE_TYPE_FEEDBACK         (0x10u)
#define USBFS_1_EP_USAGE_TYPE_IMPLICIT         (0x20u)
#define USBFS_1_EP_USAGE_TYPE_RESERVED         (0x30u)
#define USBFS_1_EP_USAGE_TYPE_MASK             (0x30u)

/* Endpoint Status defines */
#define USBFS_1_EP_STATUS_LENGTH               (0x02u)

/* Endpoint Device defines */
#define USBFS_1_DEVICE_STATUS_LENGTH           (0x02u)

/* Transfer Completion Notification */
#define USBFS_1_XFER_IDLE                      (0x00u)
#define USBFS_1_XFER_STATUS_ACK                (0x01u)
#define USBFS_1_XFER_PREMATURE                 (0x02u)
#define USBFS_1_XFER_ERROR                     (0x03u)

/* Driver State defines */
#define USBFS_1_TRANS_STATE_IDLE               (0x00u)
#define USBFS_1_TRANS_STATE_CONTROL_READ       (0x02u)
#define USBFS_1_TRANS_STATE_CONTROL_WRITE      (0x04u)
#define USBFS_1_TRANS_STATE_NO_DATA_CONTROL    (0x06u)

/* String Descriptor defines */
#define USBFS_1_STRING_MSOS                    (0xEEu)


/***************************************
*              Registers
***************************************/

#define USBFS_1_ARB_CFG_PTR        (  (reg8 *) USBFS_1_USB__ARB_CFG)
#define USBFS_1_ARB_CFG_REG        (* (reg8 *) USBFS_1_USB__ARB_CFG)

#define USBFS_1_ARB_EP1_CFG_PTR    (  (reg8 *) USBFS_1_USB__ARB_EP1_CFG)
#define USBFS_1_ARB_EP1_CFG_REG    (* (reg8 *) USBFS_1_USB__ARB_EP1_CFG)
#define USBFS_1_ARB_EP1_INT_EN_PTR (  (reg8 *) USBFS_1_USB__ARB_EP1_INT_EN)
#define USBFS_1_ARB_EP1_INT_EN_REG (* (reg8 *) USBFS_1_USB__ARB_EP1_INT_EN)
#define USBFS_1_ARB_EP1_SR_PTR     (  (reg8 *) USBFS_1_USB__ARB_EP1_SR)
#define USBFS_1_ARB_EP1_SR_REG     (* (reg8 *) USBFS_1_USB__ARB_EP1_SR)

#define USBFS_1_ARB_EP2_CFG_PTR    (  (reg8 *) USBFS_1_USB__ARB_EP2_CFG)
#define USBFS_1_ARB_EP2_CFG_REG    (* (reg8 *) USBFS_1_USB__ARB_EP2_CFG)
#define USBFS_1_ARB_EP2_INT_EN_PTR (  (reg8 *) USBFS_1_USB__ARB_EP2_INT_EN)
#define USBFS_1_ARB_EP2_INT_EN_REG (* (reg8 *) USBFS_1_USB__ARB_EP2_INT_EN)
#define USBFS_1_ARB_EP2_SR_PTR     (  (reg8 *) USBFS_1_USB__ARB_EP2_SR)
#define USBFS_1_ARB_EP2_SR_REG     (* (reg8 *) USBFS_1_USB__ARB_EP2_SR)

#define USBFS_1_ARB_EP3_CFG_PTR    (  (reg8 *) USBFS_1_USB__ARB_EP3_CFG)
#define USBFS_1_ARB_EP3_CFG_REG    (* (reg8 *) USBFS_1_USB__ARB_EP3_CFG)
#define USBFS_1_ARB_EP3_INT_EN_PTR (  (reg8 *) USBFS_1_USB__ARB_EP3_INT_EN)
#define USBFS_1_ARB_EP3_INT_EN_REG (* (reg8 *) USBFS_1_USB__ARB_EP3_INT_EN)
#define USBFS_1_ARB_EP3_SR_PTR     (  (reg8 *) USBFS_1_USB__ARB_EP3_SR)
#define USBFS_1_ARB_EP3_SR_REG     (* (reg8 *) USBFS_1_USB__ARB_EP3_SR)

#define USBFS_1_ARB_EP4_CFG_PTR    (  (reg8 *) USBFS_1_USB__ARB_EP4_CFG)
#define USBFS_1_ARB_EP4_CFG_REG    (* (reg8 *) USBFS_1_USB__ARB_EP4_CFG)
#define USBFS_1_ARB_EP4_INT_EN_PTR (  (reg8 *) USBFS_1_USB__ARB_EP4_INT_EN)
#define USBFS_1_ARB_EP4_INT_EN_REG (* (reg8 *) USBFS_1_USB__ARB_EP4_INT_EN)
#define USBFS_1_ARB_EP4_SR_PTR     (  (reg8 *) USBFS_1_USB__ARB_EP4_SR)
#define USBFS_1_ARB_EP4_SR_REG     (* (reg8 *) USBFS_1_USB__ARB_EP4_SR)

#define USBFS_1_ARB_EP5_CFG_PTR    (  (reg8 *) USBFS_1_USB__ARB_EP5_CFG)
#define USBFS_1_ARB_EP5_CFG_REG    (* (reg8 *) USBFS_1_USB__ARB_EP5_CFG)
#define USBFS_1_ARB_EP5_INT_EN_PTR (  (reg8 *) USBFS_1_USB__ARB_EP5_INT_EN)
#define USBFS_1_ARB_EP5_INT_EN_REG (* (reg8 *) USBFS_1_USB__ARB_EP5_INT_EN)
#define USBFS_1_ARB_EP5_SR_PTR     (  (reg8 *) USBFS_1_USB__ARB_EP5_SR)
#define USBFS_1_ARB_EP5_SR_REG     (* (reg8 *) USBFS_1_USB__ARB_EP5_SR)

#define USBFS_1_ARB_EP6_CFG_PTR    (  (reg8 *) USBFS_1_USB__ARB_EP6_CFG)
#define USBFS_1_ARB_EP6_CFG_REG    (* (reg8 *) USBFS_1_USB__ARB_EP6_CFG)
#define USBFS_1_ARB_EP6_INT_EN_PTR (  (reg8 *) USBFS_1_USB__ARB_EP6_INT_EN)
#define USBFS_1_ARB_EP6_INT_EN_REG (* (reg8 *) USBFS_1_USB__ARB_EP6_INT_EN)
#define USBFS_1_ARB_EP6_SR_PTR     (  (reg8 *) USBFS_1_USB__ARB_EP6_SR)
#define USBFS_1_ARB_EP6_SR_REG     (* (reg8 *) USBFS_1_USB__ARB_EP6_SR)

#define USBFS_1_ARB_EP7_CFG_PTR    (  (reg8 *) USBFS_1_USB__ARB_EP7_CFG)
#define USBFS_1_ARB_EP7_CFG_REG    (* (reg8 *) USBFS_1_USB__ARB_EP7_CFG)
#define USBFS_1_ARB_EP7_INT_EN_PTR (  (reg8 *) USBFS_1_USB__ARB_EP7_INT_EN)
#define USBFS_1_ARB_EP7_INT_EN_REG (* (reg8 *) USBFS_1_USB__ARB_EP7_INT_EN)
#define USBFS_1_ARB_EP7_SR_PTR     (  (reg8 *) USBFS_1_USB__ARB_EP7_SR)
#define USBFS_1_ARB_EP7_SR_REG     (* (reg8 *) USBFS_1_USB__ARB_EP7_SR)

#define USBFS_1_ARB_EP8_CFG_PTR    (  (reg8 *) USBFS_1_USB__ARB_EP8_CFG)
#define USBFS_1_ARB_EP8_CFG_REG    (* (reg8 *) USBFS_1_USB__ARB_EP8_CFG)
#define USBFS_1_ARB_EP8_INT_EN_PTR (  (reg8 *) USBFS_1_USB__ARB_EP8_INT_EN)
#define USBFS_1_ARB_EP8_INT_EN_REG (* (reg8 *) USBFS_1_USB__ARB_EP8_INT_EN)
#define USBFS_1_ARB_EP8_SR_PTR     (  (reg8 *) USBFS_1_USB__ARB_EP8_SR)
#define USBFS_1_ARB_EP8_SR_REG     (* (reg8 *) USBFS_1_USB__ARB_EP8_SR)

#define USBFS_1_ARB_INT_EN_PTR     (  (reg8 *) USBFS_1_USB__ARB_INT_EN)
#define USBFS_1_ARB_INT_EN_REG     (* (reg8 *) USBFS_1_USB__ARB_INT_EN)
#define USBFS_1_ARB_INT_SR_PTR     (  (reg8 *) USBFS_1_USB__ARB_INT_SR)
#define USBFS_1_ARB_INT_SR_REG     (* (reg8 *) USBFS_1_USB__ARB_INT_SR)

#define USBFS_1_ARB_RW1_DR_PTR     ((reg8 *) USBFS_1_USB__ARB_RW1_DR)
#define USBFS_1_ARB_RW1_RA_PTR     ((reg8 *) USBFS_1_USB__ARB_RW1_RA)
#define USBFS_1_ARB_RW1_RA_MSB_PTR ((reg8 *) USBFS_1_USB__ARB_RW1_RA_MSB)
#define USBFS_1_ARB_RW1_WA_PTR     ((reg8 *) USBFS_1_USB__ARB_RW1_WA)
#define USBFS_1_ARB_RW1_WA_MSB_PTR ((reg8 *) USBFS_1_USB__ARB_RW1_WA_MSB)

#define USBFS_1_ARB_RW2_DR_PTR     ((reg8 *) USBFS_1_USB__ARB_RW2_DR)
#define USBFS_1_ARB_RW2_RA_PTR     ((reg8 *) USBFS_1_USB__ARB_RW2_RA)
#define USBFS_1_ARB_RW2_RA_MSB_PTR ((reg8 *) USBFS_1_USB__ARB_RW2_RA_MSB)
#define USBFS_1_ARB_RW2_WA_PTR     ((reg8 *) USBFS_1_USB__ARB_RW2_WA)
#define USBFS_1_ARB_RW2_WA_MSB_PTR ((reg8 *) USBFS_1_USB__ARB_RW2_WA_MSB)

#define USBFS_1_ARB_RW3_DR_PTR     ((reg8 *) USBFS_1_USB__ARB_RW3_DR)
#define USBFS_1_ARB_RW3_RA_PTR     ((reg8 *) USBFS_1_USB__ARB_RW3_RA)
#define USBFS_1_ARB_RW3_RA_MSB_PTR ((reg8 *) USBFS_1_USB__ARB_RW3_RA_MSB)
#define USBFS_1_ARB_RW3_WA_PTR     ((reg8 *) USBFS_1_USB__ARB_RW3_WA)
#define USBFS_1_ARB_RW3_WA_MSB_PTR ((reg8 *) USBFS_1_USB__ARB_RW3_WA_MSB)

#define USBFS_1_ARB_RW4_DR_PTR     ((reg8 *) USBFS_1_USB__ARB_RW4_DR)
#define USBFS_1_ARB_RW4_RA_PTR     ((reg8 *) USBFS_1_USB__ARB_RW4_RA)
#define USBFS_1_ARB_RW4_RA_MSB_PTR ((reg8 *) USBFS_1_USB__ARB_RW4_RA_MSB)
#define USBFS_1_ARB_RW4_WA_PTR     ((reg8 *) USBFS_1_USB__ARB_RW4_WA)
#define USBFS_1_ARB_RW4_WA_MSB_PTR ((reg8 *) USBFS_1_USB__ARB_RW4_WA_MSB)

#define USBFS_1_ARB_RW5_DR_PTR     ((reg8 *) USBFS_1_USB__ARB_RW5_DR)
#define USBFS_1_ARB_RW5_RA_PTR     ((reg8 *) USBFS_1_USB__ARB_RW5_RA)
#define USBFS_1_ARB_RW5_RA_MSB_PTR ((reg8 *) USBFS_1_USB__ARB_RW5_RA_MSB)
#define USBFS_1_ARB_RW5_WA_PTR     ((reg8 *) USBFS_1_USB__ARB_RW5_WA)
#define USBFS_1_ARB_RW5_WA_MSB_PTR ((reg8 *) USBFS_1_USB__ARB_RW5_WA_MSB)

#define USBFS_1_ARB_RW6_DR_PTR     ((reg8 *) USBFS_1_USB__ARB_RW6_DR)
#define USBFS_1_ARB_RW6_RA_PTR     ((reg8 *) USBFS_1_USB__ARB_RW6_RA)
#define USBFS_1_ARB_RW6_RA_MSB_PTR ((reg8 *) USBFS_1_USB__ARB_RW6_RA_MSB)
#define USBFS_1_ARB_RW6_WA_PTR     ((reg8 *) USBFS_1_USB__ARB_RW6_WA)
#define USBFS_1_ARB_RW6_WA_MSB_PTR ((reg8 *) USBFS_1_USB__ARB_RW6_WA_MSB)

#define USBFS_1_ARB_RW7_DR_PTR     ((reg8 *) USBFS_1_USB__ARB_RW7_DR)
#define USBFS_1_ARB_RW7_RA_PTR     ((reg8 *) USBFS_1_USB__ARB_RW7_RA)
#define USBFS_1_ARB_RW7_RA_MSB_PTR ((reg8 *) USBFS_1_USB__ARB_RW7_RA_MSB)
#define USBFS_1_ARB_RW7_WA_PTR     ((reg8 *) USBFS_1_USB__ARB_RW7_WA)
#define USBFS_1_ARB_RW7_WA_MSB_PTR ((reg8 *) USBFS_1_USB__ARB_RW7_WA_MSB)

#define USBFS_1_ARB_RW8_DR_PTR     ((reg8 *) USBFS_1_USB__ARB_RW8_DR)
#define USBFS_1_ARB_RW8_RA_PTR     ((reg8 *) USBFS_1_USB__ARB_RW8_RA)
#define USBFS_1_ARB_RW8_RA_MSB_PTR ((reg8 *) USBFS_1_USB__ARB_RW8_RA_MSB)
#define USBFS_1_ARB_RW8_WA_PTR     ((reg8 *) USBFS_1_USB__ARB_RW8_WA)
#define USBFS_1_ARB_RW8_WA_MSB_PTR ((reg8 *) USBFS_1_USB__ARB_RW8_WA_MSB)

#define USBFS_1_BUF_SIZE_PTR       (  (reg8 *) USBFS_1_USB__BUF_SIZE)
#define USBFS_1_BUF_SIZE_REG       (* (reg8 *) USBFS_1_USB__BUF_SIZE)
#define USBFS_1_BUS_RST_CNT_PTR    (  (reg8 *) USBFS_1_USB__BUS_RST_CNT)
#define USBFS_1_BUS_RST_CNT_REG    (* (reg8 *) USBFS_1_USB__BUS_RST_CNT)
#define USBFS_1_CWA_PTR            (  (reg8 *) USBFS_1_USB__CWA)
#define USBFS_1_CWA_REG            (* (reg8 *) USBFS_1_USB__CWA)
#define USBFS_1_CWA_MSB_PTR        (  (reg8 *) USBFS_1_USB__CWA_MSB)
#define USBFS_1_CWA_MSB_REG        (* (reg8 *) USBFS_1_USB__CWA_MSB)
#define USBFS_1_CR0_PTR            (  (reg8 *) USBFS_1_USB__CR0)
#define USBFS_1_CR0_REG            (* (reg8 *) USBFS_1_USB__CR0)
#define USBFS_1_CR1_PTR            (  (reg8 *) USBFS_1_USB__CR1)
#define USBFS_1_CR1_REG            (* (reg8 *) USBFS_1_USB__CR1)

#define USBFS_1_DMA_THRES_PTR      (  (reg8 *) USBFS_1_USB__DMA_THRES)
#define USBFS_1_DMA_THRES_REG      (* (reg8 *) USBFS_1_USB__DMA_THRES)
#define USBFS_1_DMA_THRES_MSB_PTR  (  (reg8 *) USBFS_1_USB__DMA_THRES_MSB)
#define USBFS_1_DMA_THRES_MSB_REG  (* (reg8 *) USBFS_1_USB__DMA_THRES_MSB)

#define USBFS_1_EP_ACTIVE_PTR      (  (reg8 *) USBFS_1_USB__EP_ACTIVE)
#define USBFS_1_EP_ACTIVE_REG      (* (reg8 *) USBFS_1_USB__EP_ACTIVE)
#define USBFS_1_EP_TYPE_PTR        (  (reg8 *) USBFS_1_USB__EP_TYPE)
#define USBFS_1_EP_TYPE_REG        (* (reg8 *) USBFS_1_USB__EP_TYPE)

#define USBFS_1_EP0_CNT_PTR        (  (reg8 *) USBFS_1_USB__EP0_CNT)
#define USBFS_1_EP0_CNT_REG        (* (reg8 *) USBFS_1_USB__EP0_CNT)
#define USBFS_1_EP0_CR_PTR         (  (reg8 *) USBFS_1_USB__EP0_CR)
#define USBFS_1_EP0_CR_REG         (* (reg8 *) USBFS_1_USB__EP0_CR)
#define USBFS_1_EP0_DR0_PTR        (  (reg8 *) USBFS_1_USB__EP0_DR0)
#define USBFS_1_EP0_DR0_REG        (* (reg8 *) USBFS_1_USB__EP0_DR0)
#define USBFS_1_EP0_DR1_PTR        (  (reg8 *) USBFS_1_USB__EP0_DR1)
#define USBFS_1_EP0_DR1_REG        (* (reg8 *) USBFS_1_USB__EP0_DR1)
#define USBFS_1_EP0_DR2_PTR        (  (reg8 *) USBFS_1_USB__EP0_DR2)
#define USBFS_1_EP0_DR2_REG        (* (reg8 *) USBFS_1_USB__EP0_DR2)
#define USBFS_1_EP0_DR3_PTR        (  (reg8 *) USBFS_1_USB__EP0_DR3)
#define USBFS_1_EP0_DR3_REG        (* (reg8 *) USBFS_1_USB__EP0_DR3)
#define USBFS_1_EP0_DR4_PTR        (  (reg8 *) USBFS_1_USB__EP0_DR4)
#define USBFS_1_EP0_DR4_REG        (* (reg8 *) USBFS_1_USB__EP0_DR4)
#define USBFS_1_EP0_DR5_PTR        (  (reg8 *) USBFS_1_USB__EP0_DR5)
#define USBFS_1_EP0_DR5_REG        (* (reg8 *) USBFS_1_USB__EP0_DR5)
#define USBFS_1_EP0_DR6_PTR        (  (reg8 *) USBFS_1_USB__EP0_DR6)
#define USBFS_1_EP0_DR6_REG        (* (reg8 *) USBFS_1_USB__EP0_DR6)
#define USBFS_1_EP0_DR7_PTR        (  (reg8 *) USBFS_1_USB__EP0_DR7)
#define USBFS_1_EP0_DR7_REG        (* (reg8 *) USBFS_1_USB__EP0_DR7)

#define USBFS_1_OSCLK_DR0_PTR      (  (reg8 *) USBFS_1_USB__OSCLK_DR0)
#define USBFS_1_OSCLK_DR0_REG      (* (reg8 *) USBFS_1_USB__OSCLK_DR0)
#define USBFS_1_OSCLK_DR1_PTR      (  (reg8 *) USBFS_1_USB__OSCLK_DR1)
#define USBFS_1_OSCLK_DR1_REG      (* (reg8 *) USBFS_1_USB__OSCLK_DR1)

#define USBFS_1_PM_ACT_CFG_PTR     (  (reg8 *) USBFS_1_USB__PM_ACT_CFG)
#define USBFS_1_PM_ACT_CFG_REG     (* (reg8 *) USBFS_1_USB__PM_ACT_CFG)
#define USBFS_1_PM_STBY_CFG_PTR    (  (reg8 *) USBFS_1_USB__PM_STBY_CFG)
#define USBFS_1_PM_STBY_CFG_REG    (* (reg8 *) USBFS_1_USB__PM_STBY_CFG)

#define USBFS_1_SIE_EP_INT_EN_PTR  (  (reg8 *) USBFS_1_USB__SIE_EP_INT_EN)
#define USBFS_1_SIE_EP_INT_EN_REG  (* (reg8 *) USBFS_1_USB__SIE_EP_INT_EN)
#define USBFS_1_SIE_EP_INT_SR_PTR  (  (reg8 *) USBFS_1_USB__SIE_EP_INT_SR)
#define USBFS_1_SIE_EP_INT_SR_REG  (* (reg8 *) USBFS_1_USB__SIE_EP_INT_SR)

#define USBFS_1_SIE_EP1_CNT0_PTR   (  (reg8 *) USBFS_1_USB__SIE_EP1_CNT0)
#define USBFS_1_SIE_EP1_CNT0_REG   (* (reg8 *) USBFS_1_USB__SIE_EP1_CNT0)
#define USBFS_1_SIE_EP1_CNT1_PTR   (  (reg8 *) USBFS_1_USB__SIE_EP1_CNT1)
#define USBFS_1_SIE_EP1_CNT1_REG   (* (reg8 *) USBFS_1_USB__SIE_EP1_CNT1)
#define USBFS_1_SIE_EP1_CR0_PTR    (  (reg8 *) USBFS_1_USB__SIE_EP1_CR0)
#define USBFS_1_SIE_EP1_CR0_REG    (* (reg8 *) USBFS_1_USB__SIE_EP1_CR0)

#define USBFS_1_SIE_EP2_CNT0_PTR   (  (reg8 *) USBFS_1_USB__SIE_EP2_CNT0)
#define USBFS_1_SIE_EP2_CNT0_REG   (* (reg8 *) USBFS_1_USB__SIE_EP2_CNT0)
#define USBFS_1_SIE_EP2_CNT1_PTR   (  (reg8 *) USBFS_1_USB__SIE_EP2_CNT1)
#define USBFS_1_SIE_EP2_CNT1_REG   (* (reg8 *) USBFS_1_USB__SIE_EP2_CNT1)
#define USBFS_1_SIE_EP2_CR0_PTR    (  (reg8 *) USBFS_1_USB__SIE_EP2_CR0)
#define USBFS_1_SIE_EP2_CR0_REG    (* (reg8 *) USBFS_1_USB__SIE_EP2_CR0)

#define USBFS_1_SIE_EP3_CNT0_PTR   (  (reg8 *) USBFS_1_USB__SIE_EP3_CNT0)
#define USBFS_1_SIE_EP3_CNT0_REG   (* (reg8 *) USBFS_1_USB__SIE_EP3_CNT0)
#define USBFS_1_SIE_EP3_CNT1_PTR   (  (reg8 *) USBFS_1_USB__SIE_EP3_CNT1)
#define USBFS_1_SIE_EP3_CNT1_REG   (* (reg8 *) USBFS_1_USB__SIE_EP3_CNT1)
#define USBFS_1_SIE_EP3_CR0_PTR    (  (reg8 *) USBFS_1_USB__SIE_EP3_CR0)
#define USBFS_1_SIE_EP3_CR0_REG    (* (reg8 *) USBFS_1_USB__SIE_EP3_CR0)

#define USBFS_1_SIE_EP4_CNT0_PTR   (  (reg8 *) USBFS_1_USB__SIE_EP4_CNT0)
#define USBFS_1_SIE_EP4_CNT0_REG   (* (reg8 *) USBFS_1_USB__SIE_EP4_CNT0)
#define USBFS_1_SIE_EP4_CNT1_PTR   (  (reg8 *) USBFS_1_USB__SIE_EP4_CNT1)
#define USBFS_1_SIE_EP4_CNT1_REG   (* (reg8 *) USBFS_1_USB__SIE_EP4_CNT1)
#define USBFS_1_SIE_EP4_CR0_PTR    (  (reg8 *) USBFS_1_USB__SIE_EP4_CR0)
#define USBFS_1_SIE_EP4_CR0_REG    (* (reg8 *) USBFS_1_USB__SIE_EP4_CR0)

#define USBFS_1_SIE_EP5_CNT0_PTR   (  (reg8 *) USBFS_1_USB__SIE_EP5_CNT0)
#define USBFS_1_SIE_EP5_CNT0_REG   (* (reg8 *) USBFS_1_USB__SIE_EP5_CNT0)
#define USBFS_1_SIE_EP5_CNT1_PTR   (  (reg8 *) USBFS_1_USB__SIE_EP5_CNT1)
#define USBFS_1_SIE_EP5_CNT1_REG   (* (reg8 *) USBFS_1_USB__SIE_EP5_CNT1)
#define USBFS_1_SIE_EP5_CR0_PTR    (  (reg8 *) USBFS_1_USB__SIE_EP5_CR0)
#define USBFS_1_SIE_EP5_CR0_REG    (* (reg8 *) USBFS_1_USB__SIE_EP5_CR0)

#define USBFS_1_SIE_EP6_CNT0_PTR   (  (reg8 *) USBFS_1_USB__SIE_EP6_CNT0)
#define USBFS_1_SIE_EP6_CNT0_REG   (* (reg8 *) USBFS_1_USB__SIE_EP6_CNT0)
#define USBFS_1_SIE_EP6_CNT1_PTR   (  (reg8 *) USBFS_1_USB__SIE_EP6_CNT1)
#define USBFS_1_SIE_EP6_CNT1_REG   (* (reg8 *) USBFS_1_USB__SIE_EP6_CNT1)
#define USBFS_1_SIE_EP6_CR0_PTR    (  (reg8 *) USBFS_1_USB__SIE_EP6_CR0)
#define USBFS_1_SIE_EP6_CR0_REG    (* (reg8 *) USBFS_1_USB__SIE_EP6_CR0)

#define USBFS_1_SIE_EP7_CNT0_PTR   (  (reg8 *) USBFS_1_USB__SIE_EP7_CNT0)
#define USBFS_1_SIE_EP7_CNT0_REG   (* (reg8 *) USBFS_1_USB__SIE_EP7_CNT0)
#define USBFS_1_SIE_EP7_CNT1_PTR   (  (reg8 *) USBFS_1_USB__SIE_EP7_CNT1)
#define USBFS_1_SIE_EP7_CNT1_REG   (* (reg8 *) USBFS_1_USB__SIE_EP7_CNT1)
#define USBFS_1_SIE_EP7_CR0_PTR    (  (reg8 *) USBFS_1_USB__SIE_EP7_CR0)
#define USBFS_1_SIE_EP7_CR0_REG    (* (reg8 *) USBFS_1_USB__SIE_EP7_CR0)

#define USBFS_1_SIE_EP8_CNT0_PTR   (  (reg8 *) USBFS_1_USB__SIE_EP8_CNT0)
#define USBFS_1_SIE_EP8_CNT0_REG   (* (reg8 *) USBFS_1_USB__SIE_EP8_CNT0)
#define USBFS_1_SIE_EP8_CNT1_PTR   (  (reg8 *) USBFS_1_USB__SIE_EP8_CNT1)
#define USBFS_1_SIE_EP8_CNT1_REG   (* (reg8 *) USBFS_1_USB__SIE_EP8_CNT1)
#define USBFS_1_SIE_EP8_CR0_PTR    (  (reg8 *) USBFS_1_USB__SIE_EP8_CR0)
#define USBFS_1_SIE_EP8_CR0_REG    (* (reg8 *) USBFS_1_USB__SIE_EP8_CR0)

#define USBFS_1_SOF0_PTR           (  (reg8 *) USBFS_1_USB__SOF0)
#define USBFS_1_SOF0_REG           (* (reg8 *) USBFS_1_USB__SOF0)
#define USBFS_1_SOF1_PTR           (  (reg8 *) USBFS_1_USB__SOF1)
#define USBFS_1_SOF1_REG           (* (reg8 *) USBFS_1_USB__SOF1)

#define USBFS_1_USB_CLK_EN_PTR     (  (reg8 *) USBFS_1_USB__USB_CLK_EN)
#define USBFS_1_USB_CLK_EN_REG     (* (reg8 *) USBFS_1_USB__USB_CLK_EN)

#define USBFS_1_USBIO_CR0_PTR      (  (reg8 *) USBFS_1_USB__USBIO_CR0)
#define USBFS_1_USBIO_CR0_REG      (* (reg8 *) USBFS_1_USB__USBIO_CR0)
#define USBFS_1_USBIO_CR1_PTR      (  (reg8 *) USBFS_1_USB__USBIO_CR1)
#define USBFS_1_USBIO_CR1_REG      (* (reg8 *) USBFS_1_USB__USBIO_CR1)
#define USBFS_1_USBIO_CR2_PTR      (  (reg8 *) USBFS_1_USB__USBIO_CR2)
#define USBFS_1_USBIO_CR2_REG      (* (reg8 *) USBFS_1_USB__USBIO_CR2)

#define USBFS_1_DIE_ID             CYDEV_FLSHID_CUST_TABLES_BASE

#if(USBFS_1_PSOC3_ES2 || USBFS_1_PSOC5_ES1)
    #define USBFS_1_PM_AVAIL_CR_PTR    (  (reg8 *) CYREG_PM_AVAIL_CR6)
    #define USBFS_1_PM_AVAIL_CR_REG    (* (reg8 *) CYREG_PM_AVAIL_CR6)
#else  /* USBFS_1_PSOC3_ES3 || USBFS_1_PSOC5_ES2 */  
    #define USBFS_1_PM_USB_CR0_PTR     (  (reg8 *) CYREG_PM_USB_CR0)
    #define USBFS_1_PM_USB_CR0_REG     (* (reg8 *) CYREG_PM_USB_CR0)
    #define USBFS_1_DYN_RECONFIG_PTR   (  (reg8 *) USBFS_1_USB__DYN_RECONFIG)
    #define USBFS_1_DYN_RECONFIG_REG   (* (reg8 *) USBFS_1_USB__DYN_RECONFIG)
#endif /* End USBFS_1_PSOC3_ES2 || USBFS_1_PSOC5_ES1 */    

#define USBFS_1_DM_INP_DIS_PTR     (  (reg8 *) USBFS_1_Dm__INP_DIS)
#define USBFS_1_DM_INP_DIS_REG     (* (reg8 *) USBFS_1_Dm__INP_DIS)
#define USBFS_1_DP_INP_DIS_PTR     (  (reg8 *) USBFS_1_Dp__INP_DIS)
#define USBFS_1_DP_INP_DIS_REG     (* (reg8 *) USBFS_1_Dp__INP_DIS)
#define USBFS_1_DP_INTSTAT_PTR     (  (reg8 *) USBFS_1_Dp__INTSTAT)
#define USBFS_1_DP_INTSTAT_REG     (* (reg8 *) USBFS_1_Dp__INTSTAT)

#if (USBFS_1_MON_VBUS == 1u)
    #define USBFS_1_VBUS_DR_PTR        (  (reg8 *) USBFS_1_VBUS__DR)
    #define USBFS_1_VBUS_DR_REG        (* (reg8 *) USBFS_1_VBUS__DR)
    #define USBFS_1_VBUS_PS_PTR        (  (reg8 *) USBFS_1_VBUS__PS)
    #define USBFS_1_VBUS_PS_REG        (* (reg8 *) USBFS_1_VBUS__PS)
    #define USBFS_1_VBUS_MASK          USBFS_1_VBUS__MASK
#endif /* End USBFS_1_MON_VBUS */

/* Renamed Registers for backward compatibility. 
*  Should not be used in new designs. 
*/
#define USBFS_1_ARB_CFG        USBFS_1_ARB_CFG_PTR

#define USBFS_1_ARB_EP1_CFG    USBFS_1_ARB_EP1_CFG_PTR
#define USBFS_1_ARB_EP1_INT_EN USBFS_1_ARB_EP1_INT_EN_PTR
#define USBFS_1_ARB_EP1_SR     USBFS_1_ARB_EP1_SR_PTR

#define USBFS_1_ARB_EP2_CFG    USBFS_1_ARB_EP2_CFG_PTR
#define USBFS_1_ARB_EP2_INT_EN USBFS_1_ARB_EP2_INT_EN_PTR
#define USBFS_1_ARB_EP2_SR     USBFS_1_ARB_EP2_SR_PTR

#define USBFS_1_ARB_EP3_CFG    USBFS_1_ARB_EP3_CFG_PTR
#define USBFS_1_ARB_EP3_INT_EN USBFS_1_ARB_EP3_INT_EN_PTR
#define USBFS_1_ARB_EP3_SR     USBFS_1_ARB_EP3_SR_PTR

#define USBFS_1_ARB_EP4_CFG    USBFS_1_ARB_EP4_CFG_PTR
#define USBFS_1_ARB_EP4_INT_EN USBFS_1_ARB_EP4_INT_EN_PTR
#define USBFS_1_ARB_EP4_SR     USBFS_1_ARB_EP4_SR_PTR

#define USBFS_1_ARB_EP5_CFG    USBFS_1_ARB_EP5_CFG_PTR
#define USBFS_1_ARB_EP5_INT_EN USBFS_1_ARB_EP5_INT_EN_PTR
#define USBFS_1_ARB_EP5_SR     USBFS_1_ARB_EP5_SR_PTR

#define USBFS_1_ARB_EP6_CFG    USBFS_1_ARB_EP6_CFG_PTR
#define USBFS_1_ARB_EP6_INT_EN USBFS_1_ARB_EP6_INT_EN_PTR
#define USBFS_1_ARB_EP6_SR     USBFS_1_ARB_EP6_SR_PTR

#define USBFS_1_ARB_EP7_CFG    USBFS_1_ARB_EP7_CFG_PTR
#define USBFS_1_ARB_EP7_INT_EN USBFS_1_ARB_EP7_INT_EN_PTR
#define USBFS_1_ARB_EP7_SR     USBFS_1_ARB_EP7_SR_PTR

#define USBFS_1_ARB_EP8_CFG    USBFS_1_ARB_EP8_CFG_PTR
#define USBFS_1_ARB_EP8_INT_EN USBFS_1_ARB_EP8_INT_EN_PTR
#define USBFS_1_ARB_EP8_SR     USBFS_1_ARB_EP8_SR_PTR

#define USBFS_1_ARB_INT_EN     USBFS_1_ARB_INT_EN_PTR
#define USBFS_1_ARB_INT_SR     USBFS_1_ARB_INT_SR_PTR

#define USBFS_1_ARB_RW1_DR     USBFS_1_ARB_RW1_DR_PTR
#define USBFS_1_ARB_RW1_RA     USBFS_1_ARB_RW1_RA_PTR
#define USBFS_1_ARB_RW1_RA_MSB USBFS_1_ARB_RW1_RA_MSB_PTR
#define USBFS_1_ARB_RW1_WA     USBFS_1_ARB_RW1_WA_PTR 
#define USBFS_1_ARB_RW1_WA_MSB USBFS_1_ARB_RW1_WA_MSB_PTR

#define USBFS_1_ARB_RW2_DR     USBFS_1_ARB_RW2_DR_PTR
#define USBFS_1_ARB_RW2_RA     USBFS_1_ARB_RW2_RA_PTR
#define USBFS_1_ARB_RW2_RA_MSB USBFS_1_ARB_RW2_RA_MSB_PTR
#define USBFS_1_ARB_RW2_WA     USBFS_1_ARB_RW2_WA_PTR
#define USBFS_1_ARB_RW2_WA_MSB USBFS_1_ARB_RW2_WA_MSB_PTR

#define USBFS_1_ARB_RW3_DR     USBFS_1_ARB_RW3_DR_PTR
#define USBFS_1_ARB_RW3_RA     USBFS_1_ARB_RW3_RA_PTR
#define USBFS_1_ARB_RW3_RA_MSB USBFS_1_ARB_RW3_RA_MSB_PTR
#define USBFS_1_ARB_RW3_WA     USBFS_1_ARB_RW3_WA_PTR
#define USBFS_1_ARB_RW3_WA_MSB USBFS_1_ARB_RW3_WA_MSB_PTR

#define USBFS_1_ARB_RW4_DR     USBFS_1_ARB_RW4_DR_PTR
#define USBFS_1_ARB_RW4_RA     USBFS_1_ARB_RW4_RA_PTR
#define USBFS_1_ARB_RW4_RA_MSB USBFS_1_ARB_RW4_RA_MSB_PTR
#define USBFS_1_ARB_RW4_WA     USBFS_1_ARB_RW4_WA_PTR
#define USBFS_1_ARB_RW4_WA_MSB USBFS_1_ARB_RW4_WA_MSB_PTR

#define USBFS_1_ARB_RW5_DR     USBFS_1_ARB_RW5_DR_PTR
#define USBFS_1_ARB_RW5_RA     USBFS_1_ARB_RW5_RA_PTR
#define USBFS_1_ARB_RW5_RA_MSB USBFS_1_ARB_RW5_RA_MSB_PTR
#define USBFS_1_ARB_RW5_WA     USBFS_1_ARB_RW5_WA_PTR
#define USBFS_1_ARB_RW5_WA_MSB USBFS_1_ARB_RW5_WA_MSB_PTR

#define USBFS_1_ARB_RW6_DR     USBFS_1_ARB_RW6_DR_PTR
#define USBFS_1_ARB_RW6_RA     USBFS_1_ARB_RW6_RA_PTR
#define USBFS_1_ARB_RW6_RA_MSB USBFS_1_ARB_RW6_RA_MSB_PTR
#define USBFS_1_ARB_RW6_WA     USBFS_1_ARB_RW6_WA_PTR
#define USBFS_1_ARB_RW6_WA_MSB USBFS_1_ARB_RW6_WA_MSB_PTR

#define USBFS_1_ARB_RW7_DR     USBFS_1_ARB_RW7_DR_PTR
#define USBFS_1_ARB_RW7_RA     USBFS_1_ARB_RW7_RA_PTR
#define USBFS_1_ARB_RW7_RA_MSB USBFS_1_ARB_RW7_RA_MSB_PTR
#define USBFS_1_ARB_RW7_WA     USBFS_1_ARB_RW7_WA_PTR
#define USBFS_1_ARB_RW7_WA_MSB USBFS_1_ARB_RW7_WA_MSB_PTR

#define USBFS_1_ARB_RW8_DR     USBFS_1_ARB_RW8_DR_PTR
#define USBFS_1_ARB_RW8_RA     USBFS_1_ARB_RW8_RA_PTR
#define USBFS_1_ARB_RW8_RA_MSB USBFS_1_ARB_RW8_RA_MSB_PTR
#define USBFS_1_ARB_RW8_WA     USBFS_1_ARB_RW8_WA_PTR
#define USBFS_1_ARB_RW8_WA_MSB USBFS_1_ARB_RW8_WA_MSB_PTR

#define USBFS_1_BUF_SIZE       USBFS_1_BUF_SIZE_PTR
#define USBFS_1_BUS_RST_CNT    USBFS_1_BUS_RST_CNT_PTR
#define USBFS_1_CR0            USBFS_1_CR0_PTR
#define USBFS_1_CR1            USBFS_1_CR1_PTR
#define USBFS_1_CWA            USBFS_1_CWA_PTR
#define USBFS_1_CWA_MSB        USBFS_1_CWA_MSB_PTR

#define USBFS_1_DMA_THRES      USBFS_1_DMA_THRES_PTR
#define USBFS_1_DMA_THRES_MSB  USBFS_1_DMA_THRES_MSB_PTR

#define USBFS_1_EP_ACTIVE      USBFS_1_EP_ACTIVE_PTR
#define USBFS_1_EP_TYPE        USBFS_1_EP_TYPE_PTR

#define USBFS_1_EP0_CNT        USBFS_1_EP0_CNT_PTR
#define USBFS_1_EP0_CR         USBFS_1_EP0_CR_PTR
#define USBFS_1_EP0_DR0        USBFS_1_EP0_DR0_PTR
#define USBFS_1_EP0_DR1        USBFS_1_EP0_DR1_PTR
#define USBFS_1_EP0_DR2        USBFS_1_EP0_DR2_PTR
#define USBFS_1_EP0_DR3        USBFS_1_EP0_DR3_PTR
#define USBFS_1_EP0_DR4        USBFS_1_EP0_DR4_PTR
#define USBFS_1_EP0_DR5        USBFS_1_EP0_DR5_PTR
#define USBFS_1_EP0_DR6        USBFS_1_EP0_DR6_PTR
#define USBFS_1_EP0_DR7        USBFS_1_EP0_DR7_PTR

#define USBFS_1_OSCLK_DR0      USBFS_1_OSCLK_DR0_PTR
#define USBFS_1_OSCLK_DR1      USBFS_1_OSCLK_DR1_PTR

#define USBFS_1_PM_ACT_CFG     USBFS_1_PM_ACT_CFG_PTR
#define USBFS_1_PM_STBY_CFG    USBFS_1_PM_STBY_CFG_PTR
#if(USBFS_1_PSOC3_ES2 || USBFS_1_PSOC5_ES1)
    #define USBFS_1_PM_AVAIL_CR    USBFS_1_PM_AVAIL_CR_PTR
#endif /* End USBFS_1_PSOC3_ES2 || USBFS_1_PSOC5_ES1 */
#define USBFS_1_SIE_EP_INT_EN  USBFS_1_SIE_EP_INT_EN_PTR
#define USBFS_1_SIE_EP_INT_SR  USBFS_1_SIE_EP_INT_SR_PTR

#define USBFS_1_SIE_EP1_CNT0   USBFS_1_SIE_EP1_CNT0_PTR
#define USBFS_1_SIE_EP1_CNT1   USBFS_1_SIE_EP1_CNT1_PTR
#define USBFS_1_SIE_EP1_CR0    USBFS_1_SIE_EP1_CR0_PTR

#define USBFS_1_SIE_EP2_CNT0   USBFS_1_SIE_EP2_CNT0_PTR
#define USBFS_1_SIE_EP2_CNT1   USBFS_1_SIE_EP2_CNT1_PTR
#define USBFS_1_SIE_EP2_CR0    USBFS_1_SIE_EP2_CR0_PTR

#define USBFS_1_SIE_EP3_CNT0   USBFS_1_SIE_EP3_CNT0_PTR
#define USBFS_1_SIE_EP3_CNT1   USBFS_1_SIE_EP3_CNT1_PTR
#define USBFS_1_SIE_EP3_CR0    USBFS_1_SIE_EP3_CR0_PTR

#define USBFS_1_SIE_EP4_CNT0   USBFS_1_SIE_EP4_CNT0_PTR
#define USBFS_1_SIE_EP4_CNT1   USBFS_1_SIE_EP4_CNT1_PTR
#define USBFS_1_SIE_EP4_CR0    USBFS_1_SIE_EP4_CR0_PTR

#define USBFS_1_SIE_EP5_CNT0   USBFS_1_SIE_EP5_CNT0_PTR
#define USBFS_1_SIE_EP5_CNT1   USBFS_1_SIE_EP5_CNT1_PTR
#define USBFS_1_SIE_EP5_CR0    USBFS_1_SIE_EP5_CR0_PTR

#define USBFS_1_SIE_EP6_CNT0   USBFS_1_SIE_EP6_CNT0_PTR
#define USBFS_1_SIE_EP6_CNT1   USBFS_1_SIE_EP6_CNT1_PTR
#define USBFS_1_SIE_EP6_CR0    USBFS_1_SIE_EP6_CR0_PTR

#define USBFS_1_SIE_EP7_CNT0   USBFS_1_SIE_EP7_CNT0_PTR
#define USBFS_1_SIE_EP7_CNT1   USBFS_1_SIE_EP7_CNT1_PTR
#define USBFS_1_SIE_EP7_CR0    USBFS_1_SIE_EP7_CR0_PTR

#define USBFS_1_SIE_EP8_CNT0   USBFS_1_SIE_EP8_CNT0_PTR
#define USBFS_1_SIE_EP8_CNT1   USBFS_1_SIE_EP8_CNT1_PTR
#define USBFS_1_SIE_EP8_CR0    USBFS_1_SIE_EP8_CR0_PTR

#define USBFS_1_SOF0           USBFS_1_SOF0_PTR
#define USBFS_1_SOF1           USBFS_1_SOF1_PTR

#define USBFS_1_USB_CLK_EN     USBFS_1_USB_CLK_EN_PTR

#define USBFS_1_USBIO_CR0      USBFS_1_USBIO_CR0_PTR
#define USBFS_1_USBIO_CR1      USBFS_1_USBIO_CR1_PTR
#define USBFS_1_USBIO_CR2      USBFS_1_USBIO_CR2_PTR

#if (USBFS_1_MON_VBUS == 1u)
    #define USBFS_1_VBUS_DR        USBFS_1_VBUS_DR_PTR
    #define USBFS_1_VBUS_PS        USBFS_1_VBUS_PS_PTR
#endif /* End USBFS_1_MON_VBUS */

#define USBFS_1_USB_MEM        ((reg8 *) CYDEV_USB_MEM_BASE)

#if(CYDEV_CHIP_DIE_EXPECT == CYDEV_CHIP_DIE_LEOPARD)
    /* PSoC3 interrupt registers*/
    #define USBFS_1_USB_ISR_PRIOR  ((reg8 *) CYDEV_INTC_PRIOR0)
    #define USBFS_1_USB_ISR_SET_EN ((reg8 *) CYDEV_INTC_SET_EN0)
    #define USBFS_1_USB_ISR_CLR_EN ((reg8 *) CYDEV_INTC_CLR_EN0)
    #define USBFS_1_USB_ISR_VECT   ((cyisraddress *) CYDEV_INTC_VECT_MBASE)
#elif(CYDEV_CHIP_DIE_EXPECT == CYDEV_CHIP_DIE_PANTHER)
    /* PSoC5 interrupt registers*/ 
    #define USBFS_1_USB_ISR_PRIOR  ((reg8 *) CYDEV_NVIC_PRI_0)
    #define USBFS_1_USB_ISR_SET_EN ((reg8 *) CYDEV_NVIC_SETENA0)
    #define USBFS_1_USB_ISR_CLR_EN ((reg8 *) CYDEV_NVIC_CLRENA0)
    #define USBFS_1_USB_ISR_VECT   ((cyisraddress *) CYDEV_NVIC_VECT_OFFSET)
#endif /* End CYDEV_CHIP_DIE_EXPECT */


/***************************************
* Interrupt vectors, masks and priorities
***************************************/

#define USBFS_1_BUS_RESET_PRIOR    USBFS_1_bus_reset__INTC_PRIOR_NUM
#define USBFS_1_BUS_RESET_MASK     USBFS_1_bus_reset__INTC_MASK
#define USBFS_1_BUS_RESET_VECT_NUM USBFS_1_bus_reset__INTC_NUMBER

#define USBFS_1_SOF_PRIOR          USBFS_1_sof_int__INTC_PRIOR_NUM
#define USBFS_1_SOF_MASK           USBFS_1_sof_int__INTC_MASK
#define USBFS_1_SOF_VECT_NUM       USBFS_1_sof_int__INTC_NUMBER

#define USBFS_1_EP_0_PRIOR         USBFS_1_ep_0__INTC_PRIOR_NUM
#define USBFS_1_EP_0_MASK          USBFS_1_ep_0__INTC_MASK
#define USBFS_1_EP_0_VECT_NUM      USBFS_1_ep_0__INTC_NUMBER

#define USBFS_1_EP_1_PRIOR         USBFS_1_ep_1__INTC_PRIOR_NUM
#define USBFS_1_EP_1_MASK          USBFS_1_ep_1__INTC_MASK
#define USBFS_1_EP_1_VECT_NUM      USBFS_1_ep_1__INTC_NUMBER

#define USBFS_1_EP_2_PRIOR         USBFS_1_ep_2__INTC_PRIOR_NUM
#define USBFS_1_EP_2_MASK          USBFS_1_ep_2__INTC_MASK
#define USBFS_1_EP_2_VECT_NUM      USBFS_1_ep_2__INTC_NUMBER

#define USBFS_1_EP_3_PRIOR         USBFS_1_ep_3__INTC_PRIOR_NUM
#define USBFS_1_EP_3_MASK          USBFS_1_ep_3__INTC_MASK
#define USBFS_1_EP_3_VECT_NUM      USBFS_1_ep_3__INTC_NUMBER

#define USBFS_1_EP_4_PRIOR         USBFS_1_ep_4__INTC_PRIOR_NUM
#define USBFS_1_EP_4_MASK          USBFS_1_ep_4__INTC_MASK
#define USBFS_1_EP_4_VECT_NUM      USBFS_1_ep_4__INTC_NUMBER

#define USBFS_1_EP_5_PRIOR         USBFS_1_ep_5__INTC_PRIOR_NUM
#define USBFS_1_EP_5_MASK          USBFS_1_ep_5__INTC_MASK
#define USBFS_1_EP_5_VECT_NUM      USBFS_1_ep_5__INTC_NUMBER

#define USBFS_1_EP_6_PRIOR         USBFS_1_ep_6__INTC_PRIOR_NUM
#define USBFS_1_EP_6_MASK          USBFS_1_ep_6__INTC_MASK
#define USBFS_1_EP_6_VECT_NUM      USBFS_1_ep_6__INTC_NUMBER

#define USBFS_1_EP_7_PRIOR         USBFS_1_ep_7__INTC_PRIOR_NUM
#define USBFS_1_EP_7_MASK          USBFS_1_ep_7__INTC_MASK
#define USBFS_1_EP_7_VECT_NUM      USBFS_1_ep_7__INTC_NUMBER

#define USBFS_1_EP_8_PRIOR         USBFS_1_ep_8__INTC_PRIOR_NUM
#define USBFS_1_EP_8_MASK          USBFS_1_ep_8__INTC_MASK
#define USBFS_1_EP_8_VECT_NUM      USBFS_1_ep_8__INTC_NUMBER

#define USBFS_1_DP_INTC_PRIOR      USBFS_1_dp_int__INTC_PRIOR_NUM
#define USBFS_1_DP_INTC_MASK       USBFS_1_dp_int__INTC_MASK
#define USBFS_1_DP_INTC_VECT_NUM   USBFS_1_dp_int__INTC_NUMBER


/***************************************
 *  Endpoint 0 offsets (Table 9-2)
 **************************************/

#define USBFS_1_bmRequestType      USBFS_1_EP0_DR0_PTR
#define USBFS_1_bRequest           USBFS_1_EP0_DR1_PTR
#define USBFS_1_wValue             USBFS_1_EP0_DR2_PTR
#define USBFS_1_wValueHi           USBFS_1_EP0_DR3_PTR
#define USBFS_1_wValueLo           USBFS_1_EP0_DR2_PTR
#define USBFS_1_wIndex             USBFS_1_EP0_DR4_PTR
#define USBFS_1_wIndexHi           USBFS_1_EP0_DR5_PTR
#define USBFS_1_wIndexLo           USBFS_1_EP0_DR4_PTR
#define USBFS_1_length             USBFS_1_EP0_DR6_PTR
#define USBFS_1_lengthHi           USBFS_1_EP0_DR7_PTR
#define USBFS_1_lengthLo           USBFS_1_EP0_DR6_PTR


/***************************************
*       Register Constants
***************************************/
#define USBFS_1_VDDD_MV                    CYDEV_VDDD_MV
#define USBFS_1_3500MV                     (3500u)

#define USBFS_1_CR1_REG_ENABLE             (0x01u)
#define USBFS_1_CR1_ENABLE_LOCK            (0x02u)
#define USBFS_1_CR1_BUS_ACTIVITY_SHIFT     (0x02u)
#define USBFS_1_CR1_BUS_ACTIVITY           (0x01u << USBFS_1_CR1_BUS_ACTIVITY_SHIFT)
#if(USBFS_1_PSOC3_ES3 || USBFS_1_PSOC5_ES2)
    #define USBFS_1_CR1_TRIM_MSB_EN            (0x08u)
#endif /* End USBFS_1_PSOC3_ES3 || USBFS_1_PSOC5_ES2 */    

#define USBFS_1_EP0_CNT_DATA_TOGGLE        (0x80u)
#define USBFS_1_EPX_CNT_DATA_TOGGLE        (0x80u)
#define USBFS_1_EPX_CNT0_MASK              (0x07u)
#define USBFS_1_EPX_CNTX_ADDR_SHIFT        (0x04u)
#define USBFS_1_EPX_CNTX_CRC_COUNT         (0x02u)
#define USBFS_1_EPX_DATA_BUF_MAX           (512u)

#define USBFS_1_CR0_ENABLE                 (0x80u)

#if(USBFS_1_PSOC3_ES2 || USBFS_1_PSOC5_ES1)
    #define USBFS_1_USBIO_CR1_IOMODE           (0x80u)
    #define USBFS_1_USBIO_CR1_DRIVE_MODE       (0x40u)
    #define USBFS_1_USBIO_CR1_DPI              (0x20u)
    #define USBFS_1_USBIO_CR1_DMI              (0x10u)
    #define USBFS_1_USBIO_CR1_P2PUEN           (0x08u)
#else  /* USBFS_1_PSOC3_ES3 || USBFS_1_PSOC5_ES2 */  
    #define USBFS_1_USBIO_CR1_IOMODE           (0x20u)
#endif /* End USBFS_1_PSOC3_ES2 || USBFS_1_PSOC5_ES1 */    
#define USBFS_1_USBIO_CR1_USBPUEN          (0x04u)
#define USBFS_1_USBIO_CR1_DP0              (0x02u)
#define USBFS_1_USBIO_CR1_DM0              (0x01u)

#define USBFS_1_USBIO_CR0_TEN              (0x80u)
#define USBFS_1_USBIO_CR0_TSE0             (0x40u)
#define USBFS_1_USBIO_CR0_TD               (0x20u)
#define USBFS_1_USBIO_CR0_RD               (0x01u)

#define USBFS_1_FASTCLK_IMO_CR_USBCLK_ON   (0x40u)
#define USBFS_1_FASTCLK_IMO_CR_XCLKEN      (0x20u)
#define USBFS_1_FASTCLK_IMO_CR_FX2ON       (0x10u)

#define USBFS_1_ARB_EPX_CFG_RESET          (0x08u)
#define USBFS_1_ARB_EPX_CFG_CRC_BYPASS     (0x04u)
#define USBFS_1_ARB_EPX_CFG_DMA_REQ        (0x02u)
#define USBFS_1_ARB_EPX_CFG_IN_DATA_RDY    (0x01u)

#define USBFS_1_ARB_CFG_AUTO_MEM           (0x10u)
#define USBFS_1_ARB_CFG_MANUAL_DMA         (0x20u)
#define USBFS_1_ARB_CFG_AUTO_DMA           (0x40u)
#define USBFS_1_ARB_CFG_CFG_CPM            (0x80u)

#define USBFS_1_SIE_EP_INT_EP1_MASK        (0x01u)
#define USBFS_1_SIE_EP_INT_EP2_MASK        (0x02u)
#define USBFS_1_SIE_EP_INT_EP3_MASK        (0x04u)
#define USBFS_1_SIE_EP_INT_EP4_MASK        (0x08u)
#define USBFS_1_SIE_EP_INT_EP5_MASK        (0x10u)
#define USBFS_1_SIE_EP_INT_EP6_MASK        (0x20u)
#define USBFS_1_SIE_EP_INT_EP7_MASK        (0x40u)
#define USBFS_1_SIE_EP_INT_EP8_MASK        (0x80u)

#define USBFS_1_PM_ACT_EN_FSUSB            USBFS_1_USB__PM_ACT_MSK
#define USBFS_1_PM_STBY_EN_FSUSB           USBFS_1_USB__PM_STBY_MSK
#define USBFS_1_PM_AVAIL_EN_FSUSBIO        (0x10u)

#define USBFS_1_PM_USB_CR0_REF_EN          (0x01u)
#define USBFS_1_PM_USB_CR0_PD_N            (0x02u)
#define USBFS_1_PM_USB_CR0_PD_PULLUP_N     (0x04u)

#define USBFS_1_USB_CLK_ENABLE             (0x01u)

#define USBFS_1_BUS_RST_COUNT              (0x03u)

#define USBFS_1_DM_MASK                    USBFS_1_Dm__0__MASK
#define USBFS_1_DP_MASK                    USBFS_1_Dp__0__MASK


#endif /* End CY_USBFS_USBFS_1_H */


/* [] END OF FILE */
