*
* Copyright (c) 1994, American Radio Relay League, Inc.
* All Rights Reserved
*
* J. Bloom, KE3Z
* 04 January, 1995
*
;-----------------------------------------------------------;
	.include	"respi.asm"
TEMP	.set	060h
BITLEN	.set	066h
TBUF	.set	0400h
RBUF	.set	0600h
; DSK_COMM routines
DRECV16	.set	0fa18h
DRECV	.set	0fa16h
DXMIT	.set	0fa1ah
;
func	.set	068h
resp	.set	069h
sudly	.set	06ah
xsamp	.set	06bh
rsamp	.set	06ch
txcnt	.set	06dh
rxcnt	.set	06eh
;----------------------------------------------------------------
;    SECONDARY VECTOR TABLE LOACTED IN B0 PROGRAM RAM
;----------------------------------------------------------------
        .include  "mmregs.asm"  ;     > USERCODE SHOULD NOT OVERWRITE DSKD  <
        .ps     0fa00h          ;     > VECTORS.  ON LOAD, INT2 IS RESTORED <
        B       start           ;RS   > BY DSKD, BUT TRAP IS NOT            <
        B       start           ;INT0
        B       start           ;INT1
        B       start           ;INT2  > DSKD LOAD IGNORES INT2 VECTOR
        B       start           ;TINT
        B       RINT		;RINT  Branch to receive interrupt routine
        eint                    ;XINT  XINT is only for timing, so just return
        ret                     ;
      ; Begin TRAP/DSKD Kernal  ;DSKD load does not restore this code!
;----------------------------------------------------------------
;    APPLICATION CODE IS LOCATED ABOVE DSKD KERNAL
;----------------------------------------------------------------
	.ps	0FB00h
	.entry
start:	ldpk	0		; All direct addressing is to MMRs and B2
	fort	0		; Serial port : 16 bit
	rtxm			;             : ext. FSX
	sfsm			;             ; burst mode
	lack	080h		; AIC reset by pulsing /BR (Global Data)
	sach	DXR		; send 0 to DXR (AIC)
	sacl	GREG		; 256 * 100 nS /BR pulse
	lrlk    AR0,0FFFFh
	rptk	255		; read junk from address 0xFFFF
	lac	*,0,AR0
	conf	1
	sovm			; catch accumulator overflows
;--------------------------------
AIC_RS2 lack	024h		; Turn on XINT
        sacl	IMR
        idle
        lalk	AIC_1		; Load each AIC configuration word
        call	AIC_2nd		; and load it into the AIC
        lalk	AIC_2
        call	AIC_2nd
        lalk	AIC_3
        call	AIC_2nd
        lalk	AIC_CMD
        call	AIC_2nd
;----------------------------------------------------------------
	rsxm

	zac
	sacl	IMR

	b	waity		; Wait for command

; Receive and respond to new command

docmd:
	call	RECV		; Get function command from host
	sacl	func		; Save function ID
	subk	053h		; S = Set startup delay
	bnz	docmd2
	call	RECV16
	sacl	sudly
docmd2:
	lac	func
	subk	054h		; T = tx sample list
	bnz	docmd3
	call	RECV16		; Get TX count
	sacl	txcnt
	lrlk	AR2,TBUF	; TX sample buffer pointer
	lar	AR3,txcnt
	larp	AR3
	mar	*-
tfill:				; Get list of TX samples
	call	RECV16
	larp	AR2
	sacl	*+,0,AR3
	banz	tfill,*-
docmd3:
	lac	func
	subk	052h		; R = rx count
	bnz	docmd4
	call	RECV16
	sacl	rxcnt
docmd4:
	lac	func
	subk	47h		; G = go
	bnz	docmd5
	lar	AR5,sudly	; Start-up delay
	lrlk	AR1,TBUF	; TX data buffer pointer
	lrlk	AR2,RBUF	; RX data buffer pointer
	lar	AR3,txcnt	; TX sample count
	larp	AR3
	mar	*-
	lar	AR4,rxcnt	; RX sample count
	b	runit
docmd5:
	b	waity		; Ignore invalid commands
runit:
	zac
	sacl	resp
; Enable RINTs to start processing
stint:
	ldpk	0
	lack    010h            ; AIC RINT
	sacl    IMR             ; where INT0 indicates EOC (End Of Conv)
	eint
; Idle loop. Just processes RINTs until BIO goes low (incoming
; command from host).
AGN:	idle
	bioz	docomm
	lac	resp
	bz	AGN		; Loop
*
* Dump the receive buffer to the host
*
dump:
	ldpk	0
	zac
	sacl	IMR
	sacl	DXR
	lrlk	AR2,RBUF
	lar	AR4,rxcnt	; Buffer count
	larp	AR4
	mar	*-
	larp	AR2
dumpl:				; Send each 16-bit value
	lac	*+
	call	XMIT16
	larp	AR4
	banz	dumpl,*-,AR2
*
* Wait for a command
*
waity:
	bioz	docomm		; Get new command
	b	waity
; Here when host wants to talk to us. Respond with R(eady)
docomm:
	ldpk	0
	zac			;Turn off interrupts
	sacl	IMR
	lark	AR1,40
	larp	AR1
waitx	rptk	255
	nop
	banz	waitx,*-
	lack	052h		; Send the response char
	call	XMIT
	b	docmd

RINT:
*
* I/O the sample values
*
	ldpk	0
	lac	xsamp
	sacl	DXR
	lac	DRR
	sacl	rsamp
*
* Generate the next output sample
*
	larp	AR1		; Point to TX buffer
	lac	*+,0,AR3
	sacl	xsamp
	banz	chksu,*-	; Not at end of buffer, go do delay
	; End of TX buffer--start over
	lar	AR3,txcnt
	mar	*-
	lrlk	AR1,TBUF
*
* Count down the start-up delay, if any
*
chksu:
	larp	AR5
	banz	cntsu,*		; Count down if in start-up delay
	b	getrx		; Not in delay, store input samples
cntsu:
	mar	*-		; Count down start-up delay
	b	outcor
*
* Store the input sample in the RX buffer
*
getrx:
	larp	AR4		; Check receive count
	banz	getrx1,*
	b	outcor
getrx1	larp	AR2
	lac	rsamp
	sacl	*+,0,AR4	; Store the sample
	mar	*-
	banz	outcor,*	; Buffer, not full, continue
	lack	1		; Flag foreground routine to stop
	sacl	resp
outcor:
	lac	xsamp
finint:	andk	0fffch
	sacl	xsamp
	eint
	ret
******************************************************************
AIC_2nd adlk    6,15            ;set ACCU_hi = 3 for secondary XMIT
        idle                    ;Wait for a XINT
        sach    DXR             ;
        idle                    ;ACCU_hi requests 2nd XMIT
        sacl    DXR             ;
        idle                    ;ACCU_lo sets up registers
        sacl    DXR,2           ;close command with LSB = 00
        idle                    ;
        eint                    ;
        ret                     ;
;====================================================================
; Serial I/O subroutines

;============================================================
; XMIT assumes word is in bottom 8 bits of ACCL
;============================================================
XMIT16: call    XMIT            ;xmit LO
	call    XMIT            ;xmit HI
	ret                     ;
RECV	call	DRECV
	ret
XMIT	call	DXMIT
	ret
RECV16	call	DRECV16
	ret
