//
//    Modifications and changes to the original Anchor Chips software
//	  are Copyright 2004, Thomas C. McDermott, N5EG. Only the modifications
//	  and changes constitute the GPL licensed software.
//
//    This file is part of VNAR - the Vector Network Analyzer program.
//
//    VNAR is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    VNAR is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with VNAR, if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//	  Version 1.0 target application code - VNA for Cypress AN2135 target.
//
//	  4-01-04  TCM	Version 1.0
//	  4-26-04  TCM  Version 1.0.1 - Add measurement integration option: 1x, 2x, 4x, 8x, 16x
//	  6-04-04  TCM  Version 1.1.0 - Add FAST measurement mode (collect 5 readings per USB packet)  
//



#pragma NOIV					// Do not generate interrupt vectors
//-----------------------------------------------------------------------------
//	File:		periph.c
//	Contents:	Hooks required to implement USB peripheral function.
//
//	Copyright (c) 1997 AnchorChips, Inc. All rights reserved
//-----------------------------------------------------------------------------
#include "ezusb.h"
#include "ezregs.h"

extern BOOL	GotSUD;			// Received setup data flag
extern BOOL	Sleep;
extern BOOL	Rwuen;
extern BOOL	Selfpwr;

BYTE	Configuration;		// Current configuration
BYTE	AlternateSetting;	// Alternate settings

// ---------------------------------------------------------------------------
// internal function prototypes
// ---------------------------------------------------------------------------

BOOL ADC_Read(WORD *dat);
BOOL ADC_Write(BYTE dat);
BYTE DDS_Read(BYTE addr);
void DDS_Write(BYTE addr, BYTE dat);

// ----------------------------------------------------------------------------
// our global variables
// ----------------------------------------------------------------------------

int	exhaust;					// for DDS test routines
int	in2owner;					// for arming IN2EP
BOOL ScanNeeded;				// Flag set when Host has requested a data set
BYTE	ADC_Status;				// ADC Errors BIT7=TX_ERR BIT6=RX_ERR
WORD IntegCount;					// Integration Count (1x, 2x, 4x, 8x, 16x)
int TxType;						// Requested Tx buffer Format
								// Measurements
WORD	S11MIR, S11PIR, VREF1I, S21MIR, S21PIR, VREF2I;
WORD	S11MIF, S11PIF;
WORD	S11MQR, S11PQR, VREF1Q, S21MQR, S21PQR, VREF2Q;
WORD	S11MQF, S11PQF; 

//struct Type0TxBuf {
//	BYTE freq0, freq1, freq2, freq3, freq4, freq5, freq6, freq7;
//	WORD ILevel;
//	WORD S11MIR, S11PIR, VREF1I, S21MIR, S21PIR, VREF2I;
//	WORD S11MIF, S11PIF;
//	WORD S11MQR, S11PQR, VREF1Q, S21MQR, S21PQR, VREF2Q;
//	WORD S11MQF, S11PQF; } TxBuf0;	

	// 4 additional TX frequency control words (48 bits each)

BYTE	TX_FREQ_MSB0[4], TX_FREQ_MSB1[4], TX_FREQ_MSB2[4];
BYTE	TX_FREQ_MSB3[4], TX_FREQ_MSB4[4], TX_FREQ_MSB5[4];


//-----------------------------------------------------------------------------
// Task Dispatcher hooks
//	The following hooks are called by the task dispatcher.
//-----------------------------------------------------------------------------

void TD_Init(void) 				// Called once at startup
{

	int i;

	exhaust = 1000;				// number of poll cycles to wait for DDS to wake up
	in2owner = 0;				// input 2 owned by polling loop (=1 is by interrupt loop)
	Rwuen = TRUE;				// Enable remote-wakeup
	ScanNeeded = FALSE;

// Initialization routines for the Vector Network Analyzer

	CPUCS |= bmCLK24OE;			// enable 24 Mhz output buffer
	OEC = 0xff;					// enable PC7:PC0 outputs
	USBPAIR = 0;				// Don't pair any endpoints

	PORTACFG = 0;				// PA4 and PA5 are port pins
	OEA = 0x30;					// PA4 and PA5 are outputs
	OUTA = 0;					// Set PA4 and PA5 low

//	ISODISAB |= bmBIT0;			// disable ISOCHRONOUS transfers (freeing memory)

// Enable endpoints 2 IN and OUT
	IN07VAL |= bmEP2;
	OUT07VAL |= bmEP2;

// Enable interrupts for endpoints 2 IN and OUT 
	OUT07IEN |= bmEP2;
	IN07IEN |= bmEP2;

// Have some known bad data ready for the first Host Request

	IN2BUF[0] = 0xFF;

	for (i=1; i<64; i++)
		IN2BUF[i] = 0x0;
    IN2CS = 0;					// clear STALL
	IN2BC = 64;					// Arm the input buffer

}

void TD_Poll(void) 				// Called repeatedly while the device is idle
{

//	int a;
	int j;
	WORD Result;

	// The DDS wakes up later than the EZUSB processor.
	// Wait about a 1000 polling loops before initializing it.

if(exhaust > 0)
	{
		exhaust--;
		return;						// Wait for DDS to wake up
	}

if (exhaust == 0)				// DDS probably awake - initialize  it
	{
		DDS_Write(0x1D, 0x10);		// Same as default, COMPARATOR powered down
		DDS_Write(0x1E, 0x4C);		// High speed PLL, REFMULT = 12x (288 MHz)
		DDS_Write(0x1F, 0x01);		// Same as default, CW output

//		DDS_Write(0x20, 0x40);		// Bypass invsinc, no shaping of the outputs

		DDS_Write(0x20, 0x60);		// Bypass invsinc, enable I and Q DAC level controls
		DDS_Write(0x21, 0x0F);		// I-DAC MSB = maximum  (4095 decimal is max)
		DDS_Write(0x22, 0xFF);		// I-DAC LSB = maximum
		DDS_Write(0x23, 0x0F);		// Q-DAC MSB = maximum  (4095 decimal is max)
		DDS_Write(0x24, 0xFF);		// Q-DAC LSB = maximum

		DDS_Write(0x4, 0x08);		// DDS synthesizer wakes up
		DDS_Write(0x5, 0x0E3);		// at a default value of 10.0 MHz

		exhaust--;					// set it to -1 so this initialization code only gets called once
	}

if (!in2owner)						// if polling loop owns IN2
	{
	    if (!IN2CS)					// if IN2 isn't busy - it should be
		{
			IN2CS = 0;				// clear stall
			IN2BC = 64;
		}
	}

if (ScanNeeded)			// If scan needed, build a response packet for the host
	{

		if (TxType == 0)	// FULL response type
		{
	
			// clear out data values
	
			S11MIR =0; S11PIR =0; VREF1I =0; S21MIR =0; S21PIR =0; VREF2I =0;
			S11MIF =0; S11PIF =0;
			S11MQR =0; S11PQR =0; VREF1Q =0; S21MQR =0; S21PQR =0; VREF2Q =0;
			S11MQF =0; S11PQF =0; 
	
			for(j=0; j<IntegCount; j++)		// Read each value IntegCount times
			{
		

// FORMAT of the Type 0 FULL Response:
//
//  Offset  Word (LSB first, MSB second)		Condition
//  ------  -------------------------------     --------------
//	0000    0100 								Valid frame
//  0002    S11M S11P VREF1 S21M S21P VREF2 	Ref=I, TX=REFL
//  000E    S11M S11P							Ref=I, TX=FWD
//  0012    S11M S11P VREF1 S21M S21P VREF2		Ref=Q, TX=REFL
//  001E    S11M S11P							Ref=Q, TX=FWD
//  0022    0000 0000 0000						filler
//  0028	8-byte value of TxFreq Accumulator	__int64
//  0030	remainder is 00

				OUTA = 0;						// PA4 = 0, PA5 = 0 -> Ref=I, TX=REFL
				ADC_Status = 0;					// Clear I2C error bits
				if (!ADC_Write(0x0D6))				// SETUP ADC
					ADC_Status |= bmBIT7;			// I2C TX error
		
				if (!ADC_Write(0x61)) 			// request ADC measure chan 0
						ADC_Status |= bmBIT7;		// I2C TX error
			  	if (!ADC_Read(&Result))				// 12-bit result, unsigned int format
			    		ADC_Status |= bmBIT6;
				S11MIR += Result;
	
				if (!ADC_Write(0x63)) 			// request ADC measure chan 1
						ADC_Status |= bmBIT7;		// I2C TX error
			  	if (!ADC_Read(&Result))				// 12-bit result, unsigned int format
			    		ADC_Status |= bmBIT6;
				S11PIR += Result;
	
				if (!ADC_Write(0x65)) 			// request ADC measure chan 2
						ADC_Status |= bmBIT7;		// I2C TX error
			  	if (!ADC_Read(&Result))				// 12-bit result, unsigned int format
		    		ADC_Status |= bmBIT6;
				VREF1I += Result;
	
				if (!ADC_Write(0x67)) 			// request ADC measure chan 3
						ADC_Status |= bmBIT7;		// I2C TX error
			  	if (!ADC_Read(&Result))				// 12-bit result, unsigned int format
			    		ADC_Status |= bmBIT6;
				S21MIR += Result;
	
				if (!ADC_Write(0x69)) 			// request ADC measure chan 4
						ADC_Status |= bmBIT7;		// I2C TX error
			  	if (!ADC_Read(&Result))				// 12-bit result, unsigned int format
			    		ADC_Status |= bmBIT6;
				S21PIR += Result;
	
				if (!ADC_Write(0x6B)) 			// request ADC measure chan 5
						ADC_Status |= bmBIT7;		// I2C TX error
			  	if (!ADC_Read(&Result))				// 12-bit result, unsigned int format
			    		ADC_Status |= bmBIT6;
				VREF2I += Result;
	
	
	
				OUTA = 0x10;					// PA5 = 0 PA4 = 1 -> Ref=I, TX=FWD
				ADC_Status = 0;					// Clear I2C error bits
				if (!ADC_Write(0x0D6))				// SETUP ADC
					ADC_Status |= bmBIT7;			// I2C TX error
		
	   	  		if (!ADC_Write(0x61))			// request ADC measure chan 0
					ADC_Status |= bmBIT7;		// I2C TX error
		  		if (!ADC_Read(&Result))			// 12-bit result, unsigned int format
		    		ADC_Status |= bmBIT6;		// I2C RX error
				S11MIF += Result;
	
	   	  		if (!ADC_Write(0x63))			// request ADC measure chan 1
					ADC_Status |= bmBIT7;		// I2C TX error
		  		if (!ADC_Read(&Result))			// 12-bit result, unsigned int format
		    		ADC_Status |= bmBIT6;		// I2C RX error
				S11PIF += Result;
		
		
				OUTA = 0x20;					// PA5 = 1 PA4 = 0 -> Ref=Q, Tx=REFL
				ADC_Status = 0;					// Clear I2C error bits
				if (!ADC_Write(0x0D6))				// SETUP ADC
					ADC_Status |= bmBIT7;			// I2C TX error
		
				if (!ADC_Write(0x61)) 			// request ADC measure chan 0
						ADC_Status |= bmBIT7;		// I2C TX error
			  	if (!ADC_Read(&Result))				// 12-bit result, unsigned int format
			    		ADC_Status |= bmBIT6;
				S11MQR += Result;
	
				if (!ADC_Write(0x63)) 			// request ADC measure chan 1
						ADC_Status |= bmBIT7;		// I2C TX error
			  	if (!ADC_Read(&Result))				// 12-bit result, unsigned int format
			    		ADC_Status |= bmBIT6;
				S11PQR += Result;

				if (!ADC_Write(0x65)) 			// request ADC measure chan 2
						ADC_Status |= bmBIT7;		// I2C TX error
			  	if (!ADC_Read(&Result))				// 12-bit result, unsigned int format
			    		ADC_Status |= bmBIT6;
				VREF1Q += Result;
	
				if (!ADC_Write(0x67)) 			// request ADC measure chan 3
						ADC_Status |= bmBIT7;		// I2C TX error
			  	if (!ADC_Read(&Result))				// 12-bit result, unsigned int format
			    		ADC_Status |= bmBIT6;
				S21MQR += Result;
	
				if (!ADC_Write(0x69)) 			// request ADC measure chan 4
						ADC_Status |= bmBIT7;		// I2C TX error
			  	if (!ADC_Read(&Result))				// 12-bit result, unsigned int format
			    		ADC_Status |= bmBIT6;
				S21PQR += Result;
	
				if (!ADC_Write(0x6B)) 			// request ADC measure chan 5
						ADC_Status |= bmBIT7;		// I2C TX error
			  	if (!ADC_Read(&Result))				// 12-bit result, unsigned int format
			    		ADC_Status |= bmBIT6;
				VREF2Q += Result;
		
		
				OUTA = 0x30;					// PA5 = 1 PA4 = 1 -> Ref=Q, TX=FWD
				ADC_Status = 0;					// Clear I2C error bits
				if (!ADC_Write(0x0D6))				// SETUP ADC
					ADC_Status |= bmBIT7;			// I2C TX error
		
				if (!ADC_Write(0x61))			// request ADC measure chan 0
					ADC_Status |= bmBIT7;		// I2C TX error
		  		if (!ADC_Read(&Result))			// 12-bit result, unsigned int format
		    		ADC_Status |= bmBIT6;		// I2C RX error
				S11MQF += Result;
	
	 	  		if (!ADC_Write(0x63))			// request ADC measure chan 1
					ADC_Status |= bmBIT7;		// I2C TX error
		  		if (!ADC_Read(&Result))			// 12-bit result, unsigned int format
		    		ADC_Status |= bmBIT6;		// I2C RX error
			S11PQF += Result;

			}									// End integration loop

			S11MIR /= IntegCount;		// divide by Integration Count
			S11PIR /= IntegCount;
			VREF1I /= IntegCount;
			S21MIR /= IntegCount;
			S21PIR /= IntegCount;
			VREF2I /= IntegCount;
			S11MIF /= IntegCount;
			S11PIF /= IntegCount;
			S11MQR /= IntegCount;
			S11PQR /= IntegCount;
			VREF1Q /= IntegCount;
			S21MQR /= IntegCount;
			S21PQR /= IntegCount;
			VREF2Q /= IntegCount;
			S11MQF /= IntegCount;
			S11PQF /= IntegCount; 
	
			IN2BUF[2] = LSB(S11MIR);	IN2BUF[3] = MSB(S11MIR);
			IN2BUF[4] = LSB(S11PIR);	IN2BUF[5] = MSB(S11PIR);
			IN2BUF[6] = LSB(VREF1I);	IN2BUF[7] = MSB(VREF1I);
			IN2BUF[8] = LSB(S21MIR);	IN2BUF[9] = MSB(S21MIR);
			IN2BUF[10] = LSB(S21PIR);	IN2BUF[11] = MSB(S21PIR);
			IN2BUF[12] = LSB(VREF2I);	IN2BUF[13] = MSB(VREF2I);
	
			IN2BUF[14] = LSB(S11MIF);	IN2BUF[15] = MSB(S11MIF);
			IN2BUF[16] = LSB(S11PIF);	IN2BUF[17] = MSB(S11PIF);
	
			IN2BUF[18] = LSB(S11MQR);	IN2BUF[19] = MSB(S11MQR);
			IN2BUF[20] = LSB(S11PQR);	IN2BUF[21] = MSB(S11PQR);
			IN2BUF[22] = LSB(VREF1Q);	IN2BUF[23] = MSB(VREF1Q);
			IN2BUF[24] = LSB(S21MQR);	IN2BUF[25] = MSB(S21MQR);
			IN2BUF[26] = LSB(S21PQR);	IN2BUF[27] = MSB(S21PQR);
			IN2BUF[28] = LSB(VREF2Q);	IN2BUF[29] = MSB(VREF2Q);
			
			IN2BUF[30] = LSB(S11MQF);	IN2BUF[31] = MSB(S11MQF);
			IN2BUF[32] = LSB(S11PQF);	IN2BUF[33] = MSB(S11PQF);
	
			OUTA = 0;						// PA4, PA5 both zero at end of loop

		} // end if FULL reponse type






		if (TxType == 1)				// FAST Response type
		{

			ADC_Status = 0;					// Clear I2C error bits
			if (!ADC_Write(0x0D6))				// SETUP ADC
				ADC_Status |= bmBIT7;			// I2C TX error


// FORMAT of the Type 1 FAST Response:
//
//  Offset  Word (LSB first, MSB second)		Condition
//  ------  -------------------------------     --------------
//	0000    0100 								Valid frame
//  0002    S11MQ S11PI S11PQ S21MQ S21PI S21PQ Freq1
//  000E    S11MQ S11PI S11PQ S21MQ S21PI S21PQ Freq2
//  001A    S11MQ S11PI S11PQ S21MQ S21PI S21PQ Freq3
//  0026    S11MQ S11PI S11PQ S21MQ S21PI S21PQ Freq4							
//  0032    S11MQ S11PI S11PQ S21MQ S21PI S21PQ Freq5
//  003E	0000								fill

			for (j=0; j<5; j++)				// perform readings at 5 frequencies
											// DDS already programmed at Freq 1
			{

				OUTA = 0x0;						// PA4 = 0 PA5 = 0 -> Ref=I, TX=REFL


				if (!ADC_Write(0x63)) 			// request ADC measure chan 1
						ADC_Status |= bmBIT7;		// I2C TX error
			  	if (!ADC_Read(&Result))				// 12-bit result, unsigned int format
			    		ADC_Status |= bmBIT6;
				IN2BUF[j*0x0C + 4]= LSB(Result);	// S11PI
				IN2BUF[j*0x0C + 5]= MSB(Result);


				if (!ADC_Write(0x69)) 			// request ADC measure chan 4
						ADC_Status |= bmBIT7;		// I2C TX error
			  	if (!ADC_Read(&Result))				// 12-bit result, unsigned int format
			    		ADC_Status |= bmBIT6;
				IN2BUF[j*0x0C + 0x0A]= LSB(Result);	// S21PI
				IN2BUF[j*0x0C + 0x0B]= MSB(Result);



				OUTA = 0x20;					// PA5 = 1 PA4 = 0 -> Ref=Q, Tx=REFL


				if (!ADC_Write(0x61)) 			// request ADC measure chan 0
						ADC_Status |= bmBIT7;		// I2C TX error
			  	if (!ADC_Read(&Result))				// 12-bit result, unsigned int format
			    		ADC_Status |= bmBIT6;
				IN2BUF[j*0x0C + 2]= LSB(Result);	// S11MQ
				IN2BUF[j*0x0C + 3]= MSB(Result);

	
				if (!ADC_Write(0x63)) 			// request ADC measure chan 1
						ADC_Status |= bmBIT7;		// I2C TX error
			  	if (!ADC_Read(&Result))				// 12-bit result, unsigned int format
			    		ADC_Status |= bmBIT6;
				IN2BUF[j*0x0C + 6]= LSB(Result);	// S11PQ
				IN2BUF[j*0x0C + 7]= MSB(Result);

				if (!ADC_Write(0x67)) 			// request ADC measure chan 3
						ADC_Status |= bmBIT7;		// I2C TX error
			  	if (!ADC_Read(&Result))				// 12-bit result, unsigned int format
			    		ADC_Status |= bmBIT6;
				IN2BUF[j*0x0C + 8]= LSB(Result);	// S21MQ
				IN2BUF[j*0x0C + 9]= MSB(Result);
	
				if (!ADC_Write(0x69)) 			// request ADC measure chan 4
						ADC_Status |= bmBIT7;		// I2C TX error
			  	if (!ADC_Read(&Result))				// 12-bit result, unsigned int format
			    		ADC_Status |= bmBIT6;
				IN2BUF[j*0x0C + 0x0C]= LSB(Result);	// S21PQ
				IN2BUF[j*0x0C + 0x0D]= MSB(Result);

				if (j==4)							// don't attempt to program DDS at Freq 6
					break;
													// Program DDS to next frequency
				DDS_Write(0x4, TX_FREQ_MSB0[j]);		// MS byte of Freq divisor
				DDS_Write(0x5, TX_FREQ_MSB1[j]);		//    byte of Freq divisor
				DDS_Write(0x6, TX_FREQ_MSB2[j]);		//    byte of Freq divisor
				DDS_Write(0x7, TX_FREQ_MSB3[j]);		//    byte of Freq divisor
				DDS_Write(0x8, TX_FREQ_MSB4[j]);		//    byte of Freq divisor
				DDS_Write(0x9, TX_FREQ_MSB5[j]);		// LS byte of Freq divisor

			}

			OUTA = 0x0;					// return to Ref=I, Tx=REFL mode
		}								// end if FAST response type



/* WORKING CODE between markers
***
***
		OUTA = 0;						// PA4 = 0, PA5 = 0 -> Ref=I, TX=REFL
		ADC_Status = 0;					// Clear I2C error bits
		if (!ADC_Write(0x0D6))				// SETUP ADC
			ADC_Status |= bmBIT7;			// I2C TX error

    	for (a=0; a<12; a+=2)				// Scan all 6 ADC channels
    	{
   	  		if (!ADC_Write(0x61+a))			// request ADC measure chan 'a'
				ADC_Status |= bmBIT7;		// I2C TX error
	  		if (!ADC_Read(&Result))			// 12-bit result, unsigned int format
	    		ADC_Status |= bmBIT6;		// I2C RX error
			IN2BUF[a+2] = LSB(Result);
			IN2BUF[a+3] = MSB(Result);
		}


		OUTA = 0x10;					// PA5 = 0 PA4 = 1 -> Ref=I, TX=FWD
		ADC_Status = 0;					// Clear I2C error bits
		if (!ADC_Write(0x0D6))				// SETUP ADC
			ADC_Status |= bmBIT7;			// I2C TX error

    	for (a=0; a<4; a+=2)				// Scan first 2 ADC channels
    	{
   	  		if (!ADC_Write(0x61+a))			// request ADC measure chan 'a'
				ADC_Status |= bmBIT7;		// I2C TX error
	  		if (!ADC_Read(&Result))			// 12-bit result, unsigned int format
	    		ADC_Status |= bmBIT6;		// I2C RX error
			IN2BUF[a+14] = LSB(Result);
			IN2BUF[a+15] = MSB(Result);
		}


		OUTA = 0x20;					// PA5 = 1 PA4 = 0 -> Ref=Q, Tx=REFL
		ADC_Status = 0;					// Clear I2C error bits
		if (!ADC_Write(0x0D6))				// SETUP ADC
			ADC_Status |= bmBIT7;			// I2C TX error

    	for (a=0; a<12; a+=2)				// Scan 6 ADC channels
    	{
   	  		if (!ADC_Write(0x61+a))			// request ADC measure chan 'a'
				ADC_Status |= bmBIT7;		// I2C TX error
	  		if (!ADC_Read(&Result))			// 12-bit result, unsigned int format
	    		ADC_Status |= bmBIT6;		// I2C RX error
			IN2BUF[a+18] = LSB(Result);
			IN2BUF[a+19] = MSB(Result);
		}


		OUTA = 0x30;					// PA5 = 1 PA4 = 1 -> Ref=Q, TX=FWD
		ADC_Status = 0;					// Clear I2C error bits
		if (!ADC_Write(0x0D6))				// SETUP ADC
			ADC_Status |= bmBIT7;			// I2C TX error

    	for (a=0; a<4; a+=2)				// Scan first 2 ADC channels
    	{
   	  		if (!ADC_Write(0x61+a))			// request ADC measure chan 'a'
				ADC_Status |= bmBIT7;		// I2C TX error
	  		if (!ADC_Read(&Result))			// 12-bit result, unsigned int format
	    		ADC_Status |= bmBIT6;		// I2C RX error
			IN2BUF[a+30] = LSB(Result);
			IN2BUF[a+31] = MSB(Result);
		}
***
***
*/


		IN2BUF[0] = 0x01;				// 01 = Valid Scan buffer
		IN2BUF[1] = ADC_Status;			// 00 = No I2C errors
		IN2CS = 0;						// clear stall
		ScanNeeded = FALSE;				// Scan now valid - don't reply with dummies
		IN2BC = 64;						// arm buffer
	}


}


// Since VNA is self-powered, suspend and resume do not have any meaning
// but will leave the interrupt handlers here just in case the host tries
// to suspend,resume us.

BOOL TD_Suspend(void) 			// Called before the device goes into suspend mode
{
	return(TRUE);
}

BOOL TD_Resume(void) 			// Called after the device resumes
{
	return(TRUE);
}

//-----------------------------------------------------------------------------
// Device Request hooks
//	The following hooks are called by the end point 0 device request parser.
//-----------------------------------------------------------------------------

BOOL DR_GetDescriptor(void)
{
	return(TRUE);
}

BOOL DR_SetConfiguration(void)	// Called when a Set Configuration command is received
{
	Configuration = SETUPDAT[2];
	return(TRUE);				// Handled by user code
}

BOOL DR_GetConfiguration(void)	// Called when a Get Configuration command is received
{
	IN0BUF[0] = Configuration;
	EZUSB_SET_EP_BYTES(IN0BUF_ID,1);
	return(TRUE);				// Handled by user code
}

BOOL DR_SetInterface(void) 		// Called when a Set Interface command is received
{
	AlternateSetting = SETUPDAT[2];
	return(TRUE);				// Handled by user code
}

BOOL DR_GetInterface(void) 		// Called when a Set Interface command is received
{
	IN0BUF[0] = AlternateSetting;
	EZUSB_SET_EP_BYTES(IN0BUF_ID,1);
	return(TRUE);				// Handled by user code
}

BOOL DR_GetStatus(void)
{
	return(TRUE);
}

BOOL DR_ClearFeature(void)
{
	return(TRUE);
}

BOOL DR_SetFeature(void)
{
	return(TRUE);
}

BOOL DR_VendorCmnd(void)
{
	return(TRUE);
}

//-----------------------------------------------------------------------------
// USB Interrupt Handlers
//	The following functions are called by the USB interrupt jump table.
//-----------------------------------------------------------------------------

// Setup Data Available Interrupt Handler
void ISR_Sudav(void) interrupt 0
{
	GotSUD = TRUE;				// Set flag
	EZUSB_IRQ_CLEAR();
	USBIRQ = bmSUDAV;			// Clear SUDAV IRQ
}

// Setup Token Interrupt Handler
void ISR_Sutok(void) interrupt 0
{
	EZUSB_IRQ_CLEAR();
	USBIRQ = bmSUTOK;			// Clear SUTOK IRQ
}
// SOF happens every 1 millisecond
void ISR_Sof(void) interrupt 0
{
	EZUSB_IRQ_CLEAR();
	USBIRQ = bmSOF;				// Clear SOF IRQ
}
// USB Bus Reset detected
void ISR_Ures(void) interrupt 0
{

    EPIO[OUT2BUF_ID].bytes = 0;	// Arm EP2 out so it can receive from host

	EZUSB_IRQ_CLEAR();
	USBIRQ = bmURES;			// Clear URES IRQ
}

void ISR_IBN(void) interrupt 0
{
}

void ISR_Susp(void) interrupt 0
{
	Sleep = TRUE;
	EZUSB_IRQ_CLEAR();
	USBIRQ = bmSUSP;
}

void ISR_Ep0in(void) interrupt 0
{
}

void ISR_Ep0out(void) interrupt 0
{
}

void ISR_Ep1in(void) interrupt 0
{
}

void ISR_Ep1out(void) interrupt 0
{
}

// This IN interrupt occurs on completion of IN2BUF transfer to
// the host, signifying that IN2BUF is now empty and can be reloaded.
// IN2BUF is the 64-byte buffer, IN2BC is the byte count.
// Loading IN2BC auto-arms the buffer, and sets the BUSY flag.
// Sucessful ACK by the host of the transfer clears the BUSY flag
// (and generates this interrupt).
// EZUSB will NAK the host on it's attempt to read an un-armed buffer.
// Note the EP1-7 are UNARMed by a processor reset, and any read by the
// host will be NAKed until they are explicitly ARMed by us.
void ISR_Ep2in(void) interrupt 0
{
	in2owner = 1;				// interrupt routine now owns IN2

	if(!ScanNeeded)				// arm buffer unless we have a scan pending
	{
	    IN2BUF[0] = 0xFE;			// empty frame type
	    IN2BUF[1] = 0x00;			// no IIC errors
		IN2CS = 0;					// clear STALL
		IN2BC = 64;					// buffer is ready
	}

    // clear the IRQ
	EZUSB_IRQ_CLEAR();
	IN07IRQ = bmEP2;

}

// This OUT interrupt occurs when the host has completed a transfer to us.
// OUT2BUF is the buffer, OUT2BC is the byte count, and BUSY is set.
// Writing OUT2BC with any value re-arms the buffer, and clears the BUSY flag.
// EZUSB will NAK the host on it's attempt to write to a still-busy buffer.
// Note that EP1-7 are ARMed by a processor reset, and is able to accept
// one buffer immediately.
void ISR_Ep2out(void) interrupt 0
{
	// Load the DDS synthesizer with the 6-byte frequency from the packet
	// OUT2BUF is an __int64 type - 8 bytes. We care about the lower 6 bytes.
	// It is sent to us reversed:
	// OUT2BUF[0] = LSByte, OUT2BUF[7] = MSByte

	BYTE i;
	for (i=0; i<6; i++)					// use lower 48 bits of value
	{
		DDS_Write((0x4+i), OUT2BUF[5-i]);
	}

	// Set the DAC output I- and Q- levels.
	// Ref Level comes as a 16 bit unsigned int, byte-reversed in the buffer

	DDS_Write(0x21, OUT2BUF[9]);	// I-DAC MSB
	DDS_Write(0x22, OUT2BUF[8]);	// I-DAC LSB
	DDS_Write(0x23, OUT2BUF[11]);	// Q-DAC MSB
	DDS_Write(0x24, OUT2BUF[10]);	// Q-DAC MSB		

	// Record the TxType format and Integration count requested

	TxType = (unsigned int)OUT2BUF[12];		// LSB goes to TxType (MSB set to zero)
	IntegCount = (unsigned int)OUT2BUF[14];	// LSB goes to IntegCount (MSB set to zero)

	if (TxType == 0)	// FULL buffer response type
	{
		// Copy the entire __int64 to the IN2BUF to send it back to host with reply
		for (i=0; i<7; i++)
		{
			IN2BUF[i+40] = OUT2BUF[i];
		}
	}
	if (TxType == 1)	// FAST buffer response type
	{
		for (i=2; i<6; i++)		// Save remaining 4 frequencies to be measured
		{
			TX_FREQ_MSB0[i-2] = OUT2BUF[i*8 + 5];	// Most significant byte
			TX_FREQ_MSB1[i-2] = OUT2BUF[i*8 + 4];
			TX_FREQ_MSB2[i-2] = OUT2BUF[i*8 + 3];
			TX_FREQ_MSB3[i-2] = OUT2BUF[i*8 + 2];
			TX_FREQ_MSB4[i-2] = OUT2BUF[i*8 + 1];
			TX_FREQ_MSB5[i-2] = OUT2BUF[i*8 + 0];	// Least significant byte
		}
	};			

	ScanNeeded = TRUE;	// Need to Scan ADC and build packet for host

	OUT2BC = 0;			// Release the buffer, rearm the output

    // clear the IRQ
	EZUSB_IRQ_CLEAR();
	OUT07IRQ = bmEP2;
}

void ISR_Ep3in(void) interrupt 0
{
}

void ISR_Ep3out(void) interrupt 0
{
}

void ISR_Ep4in(void) interrupt 0
{
}

void ISR_Ep4out(void) interrupt 0
{
}

void ISR_Ep5in(void) interrupt 0
{
}

void ISR_Ep5out(void) interrupt 0
{
}

void ISR_Ep6in(void) interrupt 0
{
}

void ISR_Ep6out(void) interrupt 0
{
}

void ISR_Ep7in(void) interrupt 0
{
}

void ISR_Ep7out(void) interrupt 0
{
}


//-----------------------------------------------------------------------------
// Added Support Routines for the VNA project.
//	Write to I2C ADC and Read from I2C ADC
//	The ADC has an I2C bus address of 6Ah for writes and 06Bh for reads
//	Returns TRUE = OK, FALSE = Error
//-----------------------------------------------------------------------------


BOOL ADC_Write(BYTE dat)	// write byte to ADC via I2C port
{
	BYTE status;

	while (I2CS & bmSTOP)	// wait until STOP is low
		;

	I2CS = bmSTART;		// set START bit
	I2DAT = 0x6A;		// ADC address + Write
	while (!(I2CS & bmDONE))
		 ; 		// wait for done bit

	status = (I2CS &(bmBERR | bmACK)); // get status register
	if (status != bmACK)
	{
		I2CS = bmSTOP;	// stop the I2C bus
		return(FALSE);	// I2C bus error
	}
	I2DAT = dat;		// write byte to I2C device
	while (!(I2CS & bmDONE))
		 ; 		// wait for done bit

	status = (I2CS &(bmBERR | bmACK)); // get status register

	I2CS = bmSTOP;		// stop the I2C bus
	if (status != bmACK)
		return(FALSE);	// I2C bus error
	return(TRUE);
}

BOOL ADC_Read(WORD *dat)	// read data from ADC via I2C port
{
	BYTE status, dummy, low, high;

	while (I2CS & bmSTOP)	// wait until STOP is low
		;

	I2CS = bmSTART;		// set START bit
	I2DAT = 0x6B;		// ADC address + Read
	while (!(I2CS & bmDONE))
		 ; 		// wait for done bit

	status = (I2CS &(bmBERR | bmACK)); // get status register
	if (status != bmACK)
	{
		I2CS = bmSTOP;	// stop the I2C bus
		return(FALSE);	// I2C bus error
	}

	dummy = I2DAT;		// trigger the read

	while (!(I2CS & bmDONE))
		 ; 		// wait for done bit

	if (I2CS & bmBERR)	// if I2C Bus Error
	{
		I2CS = bmSTOP;
		return(FALSE);
	}

	I2CS = bmLASTRD;	// last read comes after trigger
	high = I2DAT;		// get high byte of data
				// and trigger last read
	while (!(I2CS & bmDONE))
		 ; 		// wait for done bit

	if (I2CS & bmBERR)	// if I2C Bus Error
	{
		I2CS = bmSTOP;
		return(FALSE);
	}

	I2CS = bmSTOP;		// don't trigger another read
	low = I2DAT;

	high &= 0x0F;		// 4 MS bits of high aren't present
	*dat = ((high << 8) + low);

	return(TRUE);
}

// --------------------------------------------------------------------
// Routine to write and read the DDS synthesizer registers via the
// the databus, using PC5:0 as the address bus
// --------------------------------------------------------------------

xdata volatile BYTE dds	_at_	0x2000;	// force external memory access for dds

void DDS_Write(BYTE addr, BYTE dat)	// Write dat to the 6-bit DDS addr
{
	OUTC = addr;			// PC7-PC6 are ignored
	dds = dat;
	return;
}

BYTE DDS_Read(BYTE addr)	// Read dat from the 6-bit DDS addr
{
	OUTC = addr;			// PC7-PC6 are ignored
	return(dds);
}


