//
//    Copyright 2004, Thomas C. McDermott, N5EG
//    This file is part of VNAR - the Vector Network Analyzer program.
//
//    VNAR is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    VNAR is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with VNAR, if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

#pragma once

#include "NumEntBox.h"
#include "USB_EZ_interface.h"
#include "DisplayRoutines.h"
#include "Calibration.h"
#include "DataDisplay.h"
#include "InstrumentCal.h"
#include "MarkerEntry.h"
#include "About.h"

namespace VNAR2
{
	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;
	using namespace System::Drawing::Drawing2D;
	using namespace System::Drawing::Printing;
	using namespace System::IO;
	using namespace System::Reflection;

	/// <summary> 
	/// Summary for Form1
	///
	/// WARNING: If you change the name of this class, you will need to change the 
	///          'Resource File Name' property for the managed resource compiler tool 
	///          associated with all .resx files this class depends on.  Otherwise,
	///          the designers will not be able to interact properly with localized
	///          resources associated with this form.
	/// </summary>
	public __gc class Form1 : public System::Windows::Forms::Form
	{	
	public:
		Form1(void)
		{
			InitializeComponent();
			VNA_Initialize();
      	}
  
	protected:
		void Dispose(Boolean disposing)
		{
			if (disposing && components)
			{
				components->Dispose();
			}
			__super::Dispose(disposing);
		}

	private:
		Point p1,p2;
		int txLevel;					// transmit level
		int refLevel;					// display reference level

		Rectangle rect;					// client size for render (given to us by Paint & Redraw)
		Rectangle scopeDisp;			// rectangular scope display area
		Rectangle polarBox;				// box holding the polar display
		int RectVertScaledB;			// Rectangular vertical display in db/division
		unsigned int Marker __gc[];		// Frequency Marker
		int ShowMarkerNumbers;			// Number Display control

		unsigned short trace1 __gc[], trace2 __gc[];		// traces on scope display
		unsigned short trace3 __gc[], trace4 __gc[];		// traces on scope display
		unsigned short trace5 __gc[], trace6 __gc[];		// traces on scope display
		unsigned short trace7 __gc[], trace8 __gc[];		// traces on scope display
		unsigned short trace9 __gc[], trace10 __gc[];		// traces on scope display

		double stS11Mag __gc[], stS11Phs __gc[];				// storage for S11
		double stS21Mag __gc[], stS21Phs __gc[];				// storage for S21
		double stS12Mag __gc[], stS12Phs __gc[];				// storage for S12
		double stS22Mag __gc[], stS22Phs __gc[];				// storage for S22

		PrintDocument* pdoc;            // Printer document

		VNADevice* VNA;					// Vector Network Analyzer hardware object
		FrequencyGrid* FG;				// Frequency Grid for display
		CalDataSet* CalData;			// Calibration Data Set
		String* StartUpPath;			// Directory path we started execution in


	private: System::Windows::Forms::MainMenu *  mainMenu1;


	private: System::Windows::Forms::Label *  startF;
	private: System::Windows::Forms::Label *  stopF;
	private: System::Windows::Forms::Label *  txL;
	private: System::Windows::Forms::Label *  refL;
	private: System::Windows::Forms::Button *  stopFdown;
	private: System::Windows::Forms::Button *  stopFup;
	private: System::Windows::Forms::Button *  startFdown;
	private: System::Windows::Forms::Button *  startFup;
	private: System::Windows::Forms::Label *  label1;
	private: System::Windows::Forms::Label *  label2;
	private: System::Windows::Forms::Label *  label3;
	private: System::Windows::Forms::Label *  label4;
	private: System::Windows::Forms::Button *  txLup;
	private: System::Windows::Forms::Button *  txLdown;
	private: System::Windows::Forms::Button *  refLup;
	private: System::Windows::Forms::Button *  refLdown;
	private: System::Windows::Forms::MenuItem *  fileMenu;
	private: System::Windows::Forms::MenuItem *  viewMenu;
	private: System::Windows::Forms::MenuItem *  calibrateMenu;
	private: System::Windows::Forms::MenuItem *  markerMenu;
	private: System::Windows::Forms::MenuItem *  traceMenu;
	private: System::Windows::Forms::MenuItem *  trigMenu;
	private: System::Windows::Forms::MenuItem *  printItem;
	private: System::Windows::Forms::MenuItem *  printSetupItem;
	private: System::Windows::Forms::MenuItem *  printPreviewItem;
	private: System::Windows::Forms::MenuItem *  exitItem;
	private: System::Windows::Forms::MenuItem *  rectItem;
	private: System::Windows::Forms::MenuItem *  polarItem;
	private: System::Windows::Forms::MenuItem *  runItem;
	private: System::Windows::Forms::MenuItem *  loadItem;


	private: System::Windows::Forms::MenuItem *  s11magItem;
	private: System::Windows::Forms::MenuItem *  s11phsItem;
	private: System::Windows::Forms::MenuItem *  s21magItem;
	private: System::Windows::Forms::MenuItem *  s21phsItem;
	private: System::Windows::Forms::MenuItem *  trigItem;
	private: System::Windows::Forms::ToolTip *  toolTip1;
	private: System::Windows::Forms::MenuItem *  s21groupdelayItem;
	private: System::Windows::Forms::CheckBox *  calCheckBox;
	private: System::Windows::Forms::MenuItem *  EtTrace;
	private: System::Windows::Forms::MenuItem *  EsTrace;
	private: System::Windows::Forms::MenuItem *  EdTrace;
	private: System::Windows::Forms::MenuItem *  calSshort;
	private: System::Windows::Forms::MenuItem *  calSopen;
	private: System::Windows::Forms::MenuItem *  calSterm;
	private: System::Windows::Forms::MenuItem *  menuItem1;
	private: System::Windows::Forms::Label *  label5;
	private: System::Windows::Forms::MenuItem *  VertScaleItem;
	private: System::Windows::Forms::MenuItem *  Scale10dB;
	private: System::Windows::Forms::MenuItem *  Scale5dB;
	private: System::Windows::Forms::MenuItem *  Scale2dB;
	private: System::Windows::Forms::MenuItem *  Scale1dB;
	private: System::Windows::Forms::MenuItem *  menuItem3;
	private: System::Windows::Forms::MenuItem *  menuItem2;
	private: System::Windows::Forms::MenuItem *  menuItem4;
	private: System::Windows::Forms::MenuItem *  scalemicroSec;
	private: System::Windows::Forms::MenuItem *  scalenanoSec;
	private: System::Windows::Forms::MenuItem *  calSthru;
	private: System::Windows::Forms::MenuItem *  menuItem6;
	private: System::Windows::Forms::MenuItem *  scale100psec;
	private: System::Windows::Forms::MenuItem *  scale10nsec;
	private: System::Windows::Forms::MenuItem *  scale100nsec;
	private: System::Windows::Forms::MenuItem *  scale10microsec;
	private: System::Windows::Forms::MenuItem *  menuItem5;
	private: System::Windows::Forms::MenuItem *  grid101menu;
	private: System::Windows::Forms::MenuItem *  grid201menu;
	private: System::Windows::Forms::MenuItem *  grid401menu;
	private: System::Windows::Forms::MenuItem *  grid1024menu;
	private: System::Windows::Forms::MenuItem *  HelpItem;
private: System::Windows::Forms::MenuItem *  instrumentCalItem;
private: System::Windows::Forms::MenuItem *  HelpMenuItem;
private: System::Windows::Forms::MenuItem *  AboutMenuItem;
private: System::Windows::Forms::MenuItem *  ChangeMarker;
private: System::Windows::Forms::MenuItem *  menuItem7;
private: System::Windows::Forms::MenuItem *  menuItem8;
private: System::Windows::Forms::MenuItem *  ExportRectFmt;
private: System::Windows::Forms::MenuItem *  ExportPolarFmt;
private: System::Windows::Forms::MenuItem *  menuItem11;
private: System::Windows::Forms::MenuItem *  menuItem9;
private: System::Windows::Forms::MenuItem *  MarkerNumEnable;
private: System::Windows::Forms::MenuItem *  MarkerNumDisable;
private: System::Windows::Forms::MenuItem *  storeForward;
private: System::Windows::Forms::MenuItem *  storeReverse;






	private: System::ComponentModel::IContainer *  components;



	private:
		/// <summary>
		/// Required designer variable.
		/// </summary>


		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			this->components = new System::ComponentModel::Container();
			this->mainMenu1 = new System::Windows::Forms::MainMenu();
			this->fileMenu = new System::Windows::Forms::MenuItem();
			this->printItem = new System::Windows::Forms::MenuItem();
			this->printSetupItem = new System::Windows::Forms::MenuItem();
			this->printPreviewItem = new System::Windows::Forms::MenuItem();
			this->menuItem7 = new System::Windows::Forms::MenuItem();
			this->storeForward = new System::Windows::Forms::MenuItem();
			this->storeReverse = new System::Windows::Forms::MenuItem();
			this->menuItem8 = new System::Windows::Forms::MenuItem();
			this->ExportRectFmt = new System::Windows::Forms::MenuItem();
			this->ExportPolarFmt = new System::Windows::Forms::MenuItem();
			this->menuItem11 = new System::Windows::Forms::MenuItem();
			this->exitItem = new System::Windows::Forms::MenuItem();
			this->viewMenu = new System::Windows::Forms::MenuItem();
			this->rectItem = new System::Windows::Forms::MenuItem();
			this->polarItem = new System::Windows::Forms::MenuItem();
			this->calibrateMenu = new System::Windows::Forms::MenuItem();
			this->instrumentCalItem = new System::Windows::Forms::MenuItem();
			this->runItem = new System::Windows::Forms::MenuItem();
			this->loadItem = new System::Windows::Forms::MenuItem();
			this->traceMenu = new System::Windows::Forms::MenuItem();
			this->menuItem3 = new System::Windows::Forms::MenuItem();
			this->s11magItem = new System::Windows::Forms::MenuItem();
			this->s11phsItem = new System::Windows::Forms::MenuItem();
			this->s21magItem = new System::Windows::Forms::MenuItem();
			this->s21phsItem = new System::Windows::Forms::MenuItem();
			this->s21groupdelayItem = new System::Windows::Forms::MenuItem();
			this->menuItem6 = new System::Windows::Forms::MenuItem();
			this->calSthru = new System::Windows::Forms::MenuItem();
			this->menuItem1 = new System::Windows::Forms::MenuItem();
			this->EtTrace = new System::Windows::Forms::MenuItem();
			this->EsTrace = new System::Windows::Forms::MenuItem();
			this->EdTrace = new System::Windows::Forms::MenuItem();
			this->menuItem2 = new System::Windows::Forms::MenuItem();
			this->calSshort = new System::Windows::Forms::MenuItem();
			this->calSopen = new System::Windows::Forms::MenuItem();
			this->calSterm = new System::Windows::Forms::MenuItem();
			this->VertScaleItem = new System::Windows::Forms::MenuItem();
			this->Scale10dB = new System::Windows::Forms::MenuItem();
			this->Scale5dB = new System::Windows::Forms::MenuItem();
			this->Scale2dB = new System::Windows::Forms::MenuItem();
			this->Scale1dB = new System::Windows::Forms::MenuItem();
			this->menuItem4 = new System::Windows::Forms::MenuItem();
			this->scale10microsec = new System::Windows::Forms::MenuItem();
			this->scalemicroSec = new System::Windows::Forms::MenuItem();
			this->scale100nsec = new System::Windows::Forms::MenuItem();
			this->scale10nsec = new System::Windows::Forms::MenuItem();
			this->scalenanoSec = new System::Windows::Forms::MenuItem();
			this->scale100psec = new System::Windows::Forms::MenuItem();
			this->markerMenu = new System::Windows::Forms::MenuItem();
			this->ChangeMarker = new System::Windows::Forms::MenuItem();
			this->menuItem9 = new System::Windows::Forms::MenuItem();
			this->MarkerNumEnable = new System::Windows::Forms::MenuItem();
			this->MarkerNumDisable = new System::Windows::Forms::MenuItem();
			this->menuItem5 = new System::Windows::Forms::MenuItem();
			this->grid101menu = new System::Windows::Forms::MenuItem();
			this->grid201menu = new System::Windows::Forms::MenuItem();
			this->grid401menu = new System::Windows::Forms::MenuItem();
			this->grid1024menu = new System::Windows::Forms::MenuItem();
			this->trigMenu = new System::Windows::Forms::MenuItem();
			this->trigItem = new System::Windows::Forms::MenuItem();
			this->HelpItem = new System::Windows::Forms::MenuItem();
			this->HelpMenuItem = new System::Windows::Forms::MenuItem();
			this->AboutMenuItem = new System::Windows::Forms::MenuItem();
			this->stopFdown = new System::Windows::Forms::Button();
			this->stopFup = new System::Windows::Forms::Button();
			this->startFdown = new System::Windows::Forms::Button();
			this->startFup = new System::Windows::Forms::Button();
			this->startF = new System::Windows::Forms::Label();
			this->stopF = new System::Windows::Forms::Label();
			this->txL = new System::Windows::Forms::Label();
			this->refL = new System::Windows::Forms::Label();
			this->txLup = new System::Windows::Forms::Button();
			this->txLdown = new System::Windows::Forms::Button();
			this->refLup = new System::Windows::Forms::Button();
			this->refLdown = new System::Windows::Forms::Button();
			this->label1 = new System::Windows::Forms::Label();
			this->label2 = new System::Windows::Forms::Label();
			this->label3 = new System::Windows::Forms::Label();
			this->label4 = new System::Windows::Forms::Label();
			this->toolTip1 = new System::Windows::Forms::ToolTip(this->components);
			this->label5 = new System::Windows::Forms::Label();
			this->calCheckBox = new System::Windows::Forms::CheckBox();
			this->SuspendLayout();
			// 
			// mainMenu1
			// 
			System::Windows::Forms::MenuItem* __mcTemp__1[] = new System::Windows::Forms::MenuItem*[9];
			__mcTemp__1[0] = this->fileMenu;
			__mcTemp__1[1] = this->viewMenu;
			__mcTemp__1[2] = this->calibrateMenu;
			__mcTemp__1[3] = this->traceMenu;
			__mcTemp__1[4] = this->VertScaleItem;
			__mcTemp__1[5] = this->markerMenu;
			__mcTemp__1[6] = this->menuItem5;
			__mcTemp__1[7] = this->trigMenu;
			__mcTemp__1[8] = this->HelpItem;
			this->mainMenu1->MenuItems->AddRange(__mcTemp__1);
			// 
			// fileMenu
			// 
			this->fileMenu->Index = 0;
			System::Windows::Forms::MenuItem* __mcTemp__2[] = new System::Windows::Forms::MenuItem*[9];
			__mcTemp__2[0] = this->printItem;
			__mcTemp__2[1] = this->printSetupItem;
			__mcTemp__2[2] = this->printPreviewItem;
			__mcTemp__2[3] = this->menuItem7;
			__mcTemp__2[4] = this->storeForward;
			__mcTemp__2[5] = this->storeReverse;
			__mcTemp__2[6] = this->menuItem8;
			__mcTemp__2[7] = this->menuItem11;
			__mcTemp__2[8] = this->exitItem;
			this->fileMenu->MenuItems->AddRange(__mcTemp__2);
			this->fileMenu->Text = S"&File";
			// 
			// printItem
			// 
			this->printItem->Index = 0;
			this->printItem->Shortcut = System::Windows::Forms::Shortcut::CtrlP;
			this->printItem->Text = S"&Print";
			this->printItem->Click += new System::EventHandler(this, printItem_Click);
			// 
			// printSetupItem
			// 
			this->printSetupItem->Index = 1;
			this->printSetupItem->Text = S"Print &Setup";
			this->printSetupItem->Click += new System::EventHandler(this, printSetupItem_Click);
			// 
			// printPreviewItem
			// 
			this->printPreviewItem->Index = 2;
			this->printPreviewItem->Text = S"Print Pre&view";
			this->printPreviewItem->Click += new System::EventHandler(this, printPreviewItem_Click);
			// 
			// menuItem7
			// 
			this->menuItem7->Index = 3;
			this->menuItem7->Text = S"-";
			// 
			// storeForward
			// 
			this->storeForward->Index = 4;
			this->storeForward->Text = S"Store &Forward Parameters";
			this->storeForward->Click += new System::EventHandler(this, storeForward_Click);
			// 
			// storeReverse
			// 
			this->storeReverse->Index = 5;
			this->storeReverse->Text = S"Store &Reverse Parameters";
			this->storeReverse->Click += new System::EventHandler(this, storeReverse_Click);
			// 
			// menuItem8
			// 
			this->menuItem8->Index = 6;
			System::Windows::Forms::MenuItem* __mcTemp__3[] = new System::Windows::Forms::MenuItem*[2];
			__mcTemp__3[0] = this->ExportRectFmt;
			__mcTemp__3[1] = this->ExportPolarFmt;
			this->menuItem8->MenuItems->AddRange(__mcTemp__3);
			this->menuItem8->Text = S"E&xport S-parameter File";
			// 
			// ExportRectFmt
			// 
			this->ExportRectFmt->Index = 0;
			this->ExportRectFmt->Text = S"Rectangular Format";
			this->ExportRectFmt->Click += new System::EventHandler(this, ExportRectFmt_Click);
			// 
			// ExportPolarFmt
			// 
			this->ExportPolarFmt->Index = 1;
			this->ExportPolarFmt->Text = S"Polar Format";
			this->ExportPolarFmt->Click += new System::EventHandler(this, ExportPolarFmt_Click);
			// 
			// menuItem11
			// 
			this->menuItem11->Index = 7;
			this->menuItem11->Text = S"-";
			// 
			// exitItem
			// 
			this->exitItem->Index = 8;
			this->exitItem->Text = S"&Exit";
			this->exitItem->Click += new System::EventHandler(this, exitItem_Click);
			// 
			// viewMenu
			// 
			this->viewMenu->Index = 1;
			System::Windows::Forms::MenuItem* __mcTemp__4[] = new System::Windows::Forms::MenuItem*[2];
			__mcTemp__4[0] = this->rectItem;
			__mcTemp__4[1] = this->polarItem;
			this->viewMenu->MenuItems->AddRange(__mcTemp__4);
			this->viewMenu->Text = S"&View";
			// 
			// rectItem
			// 
			this->rectItem->Checked = true;
			this->rectItem->Index = 0;
			this->rectItem->Text = S"&Rectangular";
			this->rectItem->Click += new System::EventHandler(this, rectItem_Click);
			// 
			// polarItem
			// 
			this->polarItem->Index = 1;
			this->polarItem->Text = S"&Polar";
			this->polarItem->Click += new System::EventHandler(this, polarItem_Click);
			// 
			// calibrateMenu
			// 
			this->calibrateMenu->Index = 2;
			System::Windows::Forms::MenuItem* __mcTemp__5[] = new System::Windows::Forms::MenuItem*[3];
			__mcTemp__5[0] = this->instrumentCalItem;
			__mcTemp__5[1] = this->runItem;
			__mcTemp__5[2] = this->loadItem;
			this->calibrateMenu->MenuItems->AddRange(__mcTemp__5);
			this->calibrateMenu->Shortcut = System::Windows::Forms::Shortcut::CtrlR;
			this->calibrateMenu->Text = S"&Calibration";
			// 
			// instrumentCalItem
			// 
			this->instrumentCalItem->Index = 0;
			this->instrumentCalItem->Text = S"&Detector Calibration...";
			this->instrumentCalItem->Click += new System::EventHandler(this, instrumentCalItem_Click);
			// 
			// runItem
			// 
			this->runItem->Index = 1;
			this->runItem->Text = S"&Fixture Calibration...";
			this->runItem->Click += new System::EventHandler(this, runItem_Click);
			// 
			// loadItem
			// 
			this->loadItem->Index = 2;
			this->loadItem->Shortcut = System::Windows::Forms::Shortcut::CtrlO;
			this->loadItem->Text = S"&Load Fixture Calibration File...";
			this->loadItem->Click += new System::EventHandler(this, loadItem_Click);
			// 
			// traceMenu
			// 
			this->traceMenu->Index = 3;
			System::Windows::Forms::MenuItem* __mcTemp__6[] = new System::Windows::Forms::MenuItem*[16];
			__mcTemp__6[0] = this->menuItem3;
			__mcTemp__6[1] = this->s11magItem;
			__mcTemp__6[2] = this->s11phsItem;
			__mcTemp__6[3] = this->s21magItem;
			__mcTemp__6[4] = this->s21phsItem;
			__mcTemp__6[5] = this->s21groupdelayItem;
			__mcTemp__6[6] = this->menuItem6;
			__mcTemp__6[7] = this->calSthru;
			__mcTemp__6[8] = this->menuItem1;
			__mcTemp__6[9] = this->EtTrace;
			__mcTemp__6[10] = this->EsTrace;
			__mcTemp__6[11] = this->EdTrace;
			__mcTemp__6[12] = this->menuItem2;
			__mcTemp__6[13] = this->calSshort;
			__mcTemp__6[14] = this->calSopen;
			__mcTemp__6[15] = this->calSterm;
			this->traceMenu->MenuItems->AddRange(__mcTemp__6);
			this->traceMenu->Text = S"&Trace";
			// 
			// menuItem3
			// 
			this->menuItem3->Index = 0;
			this->menuItem3->Text = S"-";
			// 
			// s11magItem
			// 
			this->s11magItem->Index = 1;
			this->s11magItem->Text = S"S11 Magnitude (rectangular)";
			this->s11magItem->Click += new System::EventHandler(this, s11magItem_Click);
			// 
			// s11phsItem
			// 
			this->s11phsItem->Index = 2;
			this->s11phsItem->Text = S"S11 Phase (rectangular)";
			this->s11phsItem->Click += new System::EventHandler(this, s11phsItem_Click);
			// 
			// s21magItem
			// 
			this->s21magItem->Checked = true;
			this->s21magItem->Index = 3;
			this->s21magItem->Text = S"S21 Magnitude (rectangular)";
			this->s21magItem->Click += new System::EventHandler(this, s21magItem_Click);
			// 
			// s21phsItem
			// 
			this->s21phsItem->Checked = true;
			this->s21phsItem->Index = 4;
			this->s21phsItem->Text = S"S21 Phase (rectangular)";
			this->s21phsItem->Click += new System::EventHandler(this, s21phsItem_Click);
			// 
			// s21groupdelayItem
			// 
			this->s21groupdelayItem->Index = 5;
			this->s21groupdelayItem->Text = S"S21 Group Delay (rectangular)";
			this->s21groupdelayItem->Click += new System::EventHandler(this, s21groupdelayItem_Click);
			// 
			// menuItem6
			// 
			this->menuItem6->Index = 6;
			this->menuItem6->Text = S"-";
			// 
			// calSthru
			// 
			this->calSthru->Index = 7;
			this->calSthru->Text = S"Raw Calibration Data - S21thru (rectangular)";
			this->calSthru->Click += new System::EventHandler(this, calSthru_Click);
			// 
			// menuItem1
			// 
			this->menuItem1->Index = 8;
			this->menuItem1->Text = S"-";
			// 
			// EtTrace
			// 
			this->EtTrace->Index = 9;
			this->EtTrace->Text = S"Et - Tracking Error Compensation (polar)";
			this->EtTrace->Click += new System::EventHandler(this, EtTrace_Click);
			// 
			// EsTrace
			// 
			this->EsTrace->Index = 10;
			this->EsTrace->Text = S"Es - Source Mismatch Error Compensation (polar)";
			this->EsTrace->Click += new System::EventHandler(this, EsTrace_Click);
			// 
			// EdTrace
			// 
			this->EdTrace->Index = 11;
			this->EdTrace->Text = S"Ed - Directivity Error Compensation (polar)";
			this->EdTrace->Click += new System::EventHandler(this, EdTrace_Click);
			// 
			// menuItem2
			// 
			this->menuItem2->Index = 12;
			this->menuItem2->Text = S"-";
			// 
			// calSshort
			// 
			this->calSshort->Index = 13;
			this->calSshort->Text = S"Raw Calibration Data - S11short (polar)";
			this->calSshort->Click += new System::EventHandler(this, calSshort_Click);
			// 
			// calSopen
			// 
			this->calSopen->Index = 14;
			this->calSopen->Text = S"Raw Calibration Data - S11open (polar)";
			this->calSopen->Click += new System::EventHandler(this, calSopen_Click);
			// 
			// calSterm
			// 
			this->calSterm->Index = 15;
			this->calSterm->Text = S"Raw Calibration Data - S11term (polar)";
			this->calSterm->Click += new System::EventHandler(this, calSterm_Click);
			// 
			// VertScaleItem
			// 
			this->VertScaleItem->Index = 4;
			System::Windows::Forms::MenuItem* __mcTemp__7[] = new System::Windows::Forms::MenuItem*[11];
			__mcTemp__7[0] = this->Scale10dB;
			__mcTemp__7[1] = this->Scale5dB;
			__mcTemp__7[2] = this->Scale2dB;
			__mcTemp__7[3] = this->Scale1dB;
			__mcTemp__7[4] = this->menuItem4;
			__mcTemp__7[5] = this->scale10microsec;
			__mcTemp__7[6] = this->scalemicroSec;
			__mcTemp__7[7] = this->scale100nsec;
			__mcTemp__7[8] = this->scale10nsec;
			__mcTemp__7[9] = this->scalenanoSec;
			__mcTemp__7[10] = this->scale100psec;
			this->VertScaleItem->MenuItems->AddRange(__mcTemp__7);
			this->VertScaleItem->Text = S"Vert&Scale";
			// 
			// Scale10dB
			// 
			this->Scale10dB->Checked = true;
			this->Scale10dB->Index = 0;
			this->Scale10dB->RadioCheck = true;
			this->Scale10dB->Text = S"10 dB / div";
			this->Scale10dB->Click += new System::EventHandler(this, Scale10dB_Click);
			// 
			// Scale5dB
			// 
			this->Scale5dB->Index = 1;
			this->Scale5dB->RadioCheck = true;
			this->Scale5dB->Text = S"5 dB / div";
			this->Scale5dB->Click += new System::EventHandler(this, Scale5dB_Click);
			// 
			// Scale2dB
			// 
			this->Scale2dB->Index = 2;
			this->Scale2dB->RadioCheck = true;
			this->Scale2dB->Text = S"2 dB / div";
			this->Scale2dB->Click += new System::EventHandler(this, Scale2dB_Click);
			// 
			// Scale1dB
			// 
			this->Scale1dB->Index = 3;
			this->Scale1dB->RadioCheck = true;
			this->Scale1dB->Text = S"1 dB / div";
			this->Scale1dB->Click += new System::EventHandler(this, Scale1dB_Click);
			// 
			// menuItem4
			// 
			this->menuItem4->Index = 4;
			this->menuItem4->Text = S"-";
			// 
			// scale10microsec
			// 
			this->scale10microsec->Index = 5;
			this->scale10microsec->RadioCheck = true;
			this->scale10microsec->Text = S"10 microsec / div";
			this->scale10microsec->Click += new System::EventHandler(this, scale10microsec_Click);
			// 
			// scalemicroSec
			// 
			this->scalemicroSec->Checked = true;
			this->scalemicroSec->Index = 6;
			this->scalemicroSec->RadioCheck = true;
			this->scalemicroSec->Text = S"1 microsec / div";
			this->scalemicroSec->Click += new System::EventHandler(this, scalemicroSec_Click);
			// 
			// scale100nsec
			// 
			this->scale100nsec->Index = 7;
			this->scale100nsec->RadioCheck = true;
			this->scale100nsec->Text = S"100 nanosec / div";
			this->scale100nsec->Click += new System::EventHandler(this, scale100nsec_Click);
			// 
			// scale10nsec
			// 
			this->scale10nsec->Index = 8;
			this->scale10nsec->RadioCheck = true;
			this->scale10nsec->Text = S"10 nanosec / div";
			this->scale10nsec->Click += new System::EventHandler(this, scale10nsec_Click);
			// 
			// scalenanoSec
			// 
			this->scalenanoSec->Index = 9;
			this->scalenanoSec->RadioCheck = true;
			this->scalenanoSec->Text = S"1 nanosec / div";
			this->scalenanoSec->Click += new System::EventHandler(this, scalenanoSec_Click);
			// 
			// scale100psec
			// 
			this->scale100psec->Index = 10;
			this->scale100psec->RadioCheck = true;
			this->scale100psec->Text = S"100 picosec / div";
			this->scale100psec->Click += new System::EventHandler(this, scale100psec_Click);
			// 
			// markerMenu
			// 
			this->markerMenu->Index = 5;
			System::Windows::Forms::MenuItem* __mcTemp__8[] = new System::Windows::Forms::MenuItem*[2];
			__mcTemp__8[0] = this->ChangeMarker;
			__mcTemp__8[1] = this->menuItem9;
			this->markerMenu->MenuItems->AddRange(__mcTemp__8);
			this->markerMenu->Text = S"&Marker";
			// 
			// ChangeMarker
			// 
			this->ChangeMarker->Index = 0;
			this->ChangeMarker->Text = S"&Change Marker Frequencies";
			this->ChangeMarker->Click += new System::EventHandler(this, ChangeMarker_Click);
			// 
			// menuItem9
			// 
			this->menuItem9->Index = 1;
			System::Windows::Forms::MenuItem* __mcTemp__9[] = new System::Windows::Forms::MenuItem*[2];
			__mcTemp__9[0] = this->MarkerNumEnable;
			__mcTemp__9[1] = this->MarkerNumDisable;
			this->menuItem9->MenuItems->AddRange(__mcTemp__9);
			this->menuItem9->Text = S"Marker &Numbers";
			// 
			// MarkerNumEnable
			// 
			this->MarkerNumEnable->Index = 0;
			this->MarkerNumEnable->Text = S"&Enable";
			this->MarkerNumEnable->Click += new System::EventHandler(this, MarkerNumEnable_Click);
			// 
			// MarkerNumDisable
			// 
			this->MarkerNumDisable->Index = 1;
			this->MarkerNumDisable->Text = S"&Disable";
			this->MarkerNumDisable->Click += new System::EventHandler(this, MarkerNumDisable_Click);
			// 
			// menuItem5
			// 
			this->menuItem5->Index = 6;
			System::Windows::Forms::MenuItem* __mcTemp__10[] = new System::Windows::Forms::MenuItem*[4];
			__mcTemp__10[0] = this->grid101menu;
			__mcTemp__10[1] = this->grid201menu;
			__mcTemp__10[2] = this->grid401menu;
			__mcTemp__10[3] = this->grid1024menu;
			this->menuItem5->MenuItems->AddRange(__mcTemp__10);
			this->menuItem5->Text = S"Freq&Grid";
			// 
			// grid101menu
			// 
			this->grid101menu->Index = 0;
			this->grid101menu->RadioCheck = true;
			this->grid101menu->Text = S"101 points";
			this->grid101menu->Click += new System::EventHandler(this, grid101menu_Click);
			// 
			// grid201menu
			// 
			this->grid201menu->Checked = true;
			this->grid201menu->Index = 1;
			this->grid201menu->RadioCheck = true;
			this->grid201menu->Text = S"201 points";
			this->grid201menu->Click += new System::EventHandler(this, grid201menu_Click);
			// 
			// grid401menu
			// 
			this->grid401menu->Index = 2;
			this->grid401menu->RadioCheck = true;
			this->grid401menu->Text = S"401 points";
			this->grid401menu->Click += new System::EventHandler(this, grid401menu_Click);
			// 
			// grid1024menu
			// 
			this->grid1024menu->Index = 3;
			this->grid1024menu->RadioCheck = true;
			this->grid1024menu->Text = S"1024 points";
			this->grid1024menu->Click += new System::EventHandler(this, grid1024menu_Click);
			// 
			// trigMenu
			// 
			this->trigMenu->Index = 7;
			System::Windows::Forms::MenuItem* __mcTemp__11[] = new System::Windows::Forms::MenuItem*[1];
			__mcTemp__11[0] = this->trigItem;
			this->trigMenu->MenuItems->AddRange(__mcTemp__11);
			this->trigMenu->Text = S"&ReadTrig";
			// 
			// trigItem
			// 
			this->trigItem->Index = 0;
			this->trigItem->Text = S"trigger reading";
			this->trigItem->Click += new System::EventHandler(this, trigItem_Click);
			// 
			// HelpItem
			// 
			this->HelpItem->Index = 8;
			this->HelpItem->MdiList = true;
			System::Windows::Forms::MenuItem* __mcTemp__12[] = new System::Windows::Forms::MenuItem*[2];
			__mcTemp__12[0] = this->HelpMenuItem;
			__mcTemp__12[1] = this->AboutMenuItem;
			this->HelpItem->MenuItems->AddRange(__mcTemp__12);
			this->HelpItem->Text = S"&Help";
			// 
			// HelpMenuItem
			// 
			this->HelpMenuItem->Index = 0;
			this->HelpMenuItem->Text = S"&Display Help";
			this->HelpMenuItem->Click += new System::EventHandler(this, HelpMenuItem_Click);
			// 
			// AboutMenuItem
			// 
			this->AboutMenuItem->Index = 1;
			this->AboutMenuItem->Text = S"&About";
			this->AboutMenuItem->Click += new System::EventHandler(this, AboutMenuItem_Click);
			// 
			// stopFdown
			// 
			this->stopFdown->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->stopFdown->Location = System::Drawing::Point(384, 415);
			this->stopFdown->Name = S"stopFdown";
			this->stopFdown->Size = System::Drawing::Size(24, 16);
			this->stopFdown->TabIndex = 0;
			this->stopFdown->Text = S"-";
			this->stopFdown->Click += new System::EventHandler(this, stopFdown_Click);
			// 
			// stopFup
			// 
			this->stopFup->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->stopFup->Location = System::Drawing::Point(384, 399);
			this->stopFup->Name = S"stopFup";
			this->stopFup->Size = System::Drawing::Size(24, 16);
			this->stopFup->TabIndex = 1;
			this->stopFup->Text = S"+";
			this->stopFup->Click += new System::EventHandler(this, stopFup_Click);
			// 
			// startFdown
			// 
			this->startFdown->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->startFdown->Location = System::Drawing::Point(384, 367);
			this->startFdown->Name = S"startFdown";
			this->startFdown->Size = System::Drawing::Size(24, 16);
			this->startFdown->TabIndex = 2;
			this->startFdown->Text = S"-";
			this->startFdown->Click += new System::EventHandler(this, startFdown_Click);
			// 
			// startFup
			// 
			this->startFup->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->startFup->Location = System::Drawing::Point(384, 351);
			this->startFup->Name = S"startFup";
			this->startFup->Size = System::Drawing::Size(24, 16);
			this->startFup->TabIndex = 3;
			this->startFup->Text = S"+";
			this->startFup->Click += new System::EventHandler(this, startFup_Click);
			// 
			// startF
			// 
			this->startF->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->startF->BackColor = System::Drawing::Color::Black;
			this->startF->Font = new System::Drawing::Font(S"Verdana", 15.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->startF->ForeColor = System::Drawing::Color::Aquamarine;
			this->startF->Location = System::Drawing::Point(216, 351);
			this->startF->Name = S"startF";
			this->startF->Size = System::Drawing::Size(168, 32);
			this->startF->TabIndex = 4;
			this->startF->TextAlign = System::Drawing::ContentAlignment::MiddleRight;
			this->toolTip1->SetToolTip(this->startF, S"Double-click to directly enter value");
			// 
			// stopF
			// 
			this->stopF->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->stopF->BackColor = System::Drawing::Color::Black;
			this->stopF->Font = new System::Drawing::Font(S"Verdana", 15.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->stopF->ForeColor = System::Drawing::Color::Aquamarine;
			this->stopF->Location = System::Drawing::Point(216, 399);
			this->stopF->Name = S"stopF";
			this->stopF->Size = System::Drawing::Size(168, 32);
			this->stopF->TabIndex = 5;
			this->stopF->TextAlign = System::Drawing::ContentAlignment::MiddleRight;
			this->toolTip1->SetToolTip(this->stopF, S"Double-click to directly enter value");
			// 
			// txL
			// 
			this->txL->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->txL->BackColor = System::Drawing::Color::Black;
			this->txL->Font = new System::Drawing::Font(S"Verdana", 15.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->txL->ForeColor = System::Drawing::Color::Aquamarine;
			this->txL->Location = System::Drawing::Point(632, 351);
			this->txL->Name = S"txL";
			this->txL->Size = System::Drawing::Size(120, 32);
			this->txL->TabIndex = 6;
			this->txL->TextAlign = System::Drawing::ContentAlignment::MiddleRight;
			this->toolTip1->SetToolTip(this->txL, S"Double-click to directly enter value");
			// 
			// refL
			// 
			this->refL->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->refL->BackColor = System::Drawing::Color::Black;
			this->refL->Font = new System::Drawing::Font(S"Verdana", 15.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->refL->ForeColor = System::Drawing::Color::Aquamarine;
			this->refL->Location = System::Drawing::Point(632, 399);
			this->refL->Name = S"refL";
			this->refL->Size = System::Drawing::Size(120, 32);
			this->refL->TabIndex = 7;
			this->refL->TextAlign = System::Drawing::ContentAlignment::MiddleRight;
			this->toolTip1->SetToolTip(this->refL, S"Double-click to directly enter value");
			// 
			// txLup
			// 
			this->txLup->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->txLup->Location = System::Drawing::Point(752, 351);
			this->txLup->Name = S"txLup";
			this->txLup->Size = System::Drawing::Size(24, 16);
			this->txLup->TabIndex = 8;
			this->txLup->Text = S"+";
			this->txLup->Click += new System::EventHandler(this, txLup_Click);
			// 
			// txLdown
			// 
			this->txLdown->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->txLdown->Location = System::Drawing::Point(752, 367);
			this->txLdown->Name = S"txLdown";
			this->txLdown->Size = System::Drawing::Size(24, 16);
			this->txLdown->TabIndex = 9;
			this->txLdown->Text = S"-";
			this->txLdown->Click += new System::EventHandler(this, txLdown_Click);
			// 
			// refLup
			// 
			this->refLup->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->refLup->Location = System::Drawing::Point(752, 399);
			this->refLup->Name = S"refLup";
			this->refLup->Size = System::Drawing::Size(24, 16);
			this->refLup->TabIndex = 10;
			this->refLup->Text = S"+";
			this->refLup->Click += new System::EventHandler(this, refLup_Click);
			// 
			// refLdown
			// 
			this->refLdown->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->refLdown->Location = System::Drawing::Point(752, 415);
			this->refLdown->Name = S"refLdown";
			this->refLdown->Size = System::Drawing::Size(24, 16);
			this->refLdown->TabIndex = 11;
			this->refLdown->Text = S"-";
			this->refLdown->Click += new System::EventHandler(this, refLdown_Click);
			// 
			// label1
			// 
			this->label1->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->label1->Font = new System::Drawing::Font(S"Verdana", 15.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->label1->Location = System::Drawing::Point(8, 351);
			this->label1->Name = S"label1";
			this->label1->Size = System::Drawing::Size(208, 32);
			this->label1->TabIndex = 12;
			this->label1->Text = S"Start Frequency";
			// 
			// label2
			// 
			this->label2->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->label2->Font = new System::Drawing::Font(S"Verdana", 15.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->label2->Location = System::Drawing::Point(8, 399);
			this->label2->Name = S"label2";
			this->label2->Size = System::Drawing::Size(200, 32);
			this->label2->TabIndex = 13;
			this->label2->Text = S"Stop Frequency";
			// 
			// label3
			// 
			this->label3->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->label3->Font = new System::Drawing::Font(S"Verdana", 15.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->label3->Location = System::Drawing::Point(424, 351);
			this->label3->Name = S"label3";
			this->label3->Size = System::Drawing::Size(184, 24);
			this->label3->TabIndex = 14;
			this->label3->Text = S"Tx Level, dbm.";
			// 
			// label4
			// 
			this->label4->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->label4->Font = new System::Drawing::Font(S"Verdana", 15.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->label4->Location = System::Drawing::Point(424, 399);
			this->label4->Name = S"label4";
			this->label4->Size = System::Drawing::Size(208, 24);
			this->label4->TabIndex = 15;
			this->label4->Text = S"Ref. Level, dB.";
			// 
			// label5
			// 
			this->label5->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->label5->Location = System::Drawing::Point(784, 400);
			this->label5->Name = S"label5";
			this->label5->Size = System::Drawing::Size(120, 24);
			this->label5->TabIndex = 18;
			this->label5->Text = S"Apply Fixture Calibration";
			this->label5->TextAlign = System::Drawing::ContentAlignment::MiddleRight;
			this->toolTip1->SetToolTip(this->label5, S"Load Cal file or Run Cal to enable");
			// 
			// calCheckBox
			// 
			this->calCheckBox->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->calCheckBox->CheckAlign = System::Drawing::ContentAlignment::MiddleRight;
			this->calCheckBox->Enabled = false;
			this->calCheckBox->Location = System::Drawing::Point(912, 400);
			this->calCheckBox->Name = S"calCheckBox";
			this->calCheckBox->Size = System::Drawing::Size(16, 24);
			this->calCheckBox->TabIndex = 17;
			this->calCheckBox->CheckedChanged += new System::EventHandler(this, calCheckBox_CheckedChanged);
			// 
			// Form1
			// 
			this->AutoScaleBaseSize = System::Drawing::Size(5, 13);
			this->ClientSize = System::Drawing::Size(942, 445);
			this->Controls->Add(this->label5);
			this->Controls->Add(this->calCheckBox);
			this->Controls->Add(this->label4);
			this->Controls->Add(this->label3);
			this->Controls->Add(this->label2);
			this->Controls->Add(this->label1);
			this->Controls->Add(this->refLdown);
			this->Controls->Add(this->refLup);
			this->Controls->Add(this->txLdown);
			this->Controls->Add(this->txLup);
			this->Controls->Add(this->refL);
			this->Controls->Add(this->txL);
			this->Controls->Add(this->stopF);
			this->Controls->Add(this->startF);
			this->Controls->Add(this->startFup);
			this->Controls->Add(this->startFdown);
			this->Controls->Add(this->stopFup);
			this->Controls->Add(this->stopFdown);
			this->Menu = this->mainMenu1;
			this->MinimumSize = System::Drawing::Size(860, 400);
			this->Name = S"Form1";
			this->Text = S"TAPR Vector Network Analyzer";
			this->Load += new System::EventHandler(this, Form1_Load);
			this->ResumeLayout(false);

		}	

private: System::Void Form1_Load(System::Object *  sender, System::EventArgs *  e)
		{
			FG = new FrequencyGrid(201);	// Grid containing 201 frequencies (default size)
			FG->SetStartF(200000);			// Default start frequency to 200 KHz.
			FG->SetStopF(100000000);		// Default stop frequency to 100 MHz.

			CalData = new CalDataSet(StartUpPath);		// Allocate cal data set

			txLevel = 0;				// default to 0 dbm
			refLevel = 0;               // default to 0 dB

			RectVertScaledB = 10;		// default to 10 dB/div

			Marker = new unsigned int __gc[5];	// allocate and initialize 5 frequenecy markers
			for (int i=0; i<5; i++)
				Marker[i] = 0;			// Marker frequency = 0 means disabled

			ShowMarkerNumbers = 1;		// non-zero means number display enabled

			// load numeric indicators with text
			startF->Text = FG->StartF.ToString("N0");
			stopF->Text = FG->StopF.ToString("N0");

			txL->Text = txLevel.ToString();
		    refL->Text = refLevel.ToString();

			// Add double-click handlers
			this->startF->DoubleClick += new System::EventHandler(this, startF_DoubleClick);
			this->stopF->DoubleClick += new System::EventHandler(this, stopF_DoubleClick);
			this->txL->DoubleClick += new System::EventHandler(this, txL_DoubleClick);
			this->refL->DoubleClick += new System::EventHandler(this, refL_DoubleClick);

			//Add Mouse event handlers
			MouseDown += new MouseEventHandler(this, Form_MouseDown);
			MouseUp += new MouseEventHandler(this, Form_MouseUp);

			// Add paint event handler
			Paint += new PaintEventHandler(this, Form_Paint);
			// Add resize event handler
			Resize += new EventHandler(this, Form_Resize);

			// Instantiate PrintDocument to hold printer settings
			pdoc = new PrintDocument();
			// Add the page handler
			pdoc->PrintPage += new PrintPageEventHandler(this, PrintAPage);
		}

private: System::Void printItem_Click(System::Object *  sender, System::EventArgs *  e)
    {
        // Create a dialog and attach it to the document
        PrintDialog* pd = new PrintDialog();
        pd->Document = pdoc;
        // show the dialog
        if (pd->ShowDialog() == DialogResult::OK)
        {
            // Print the page
            pdoc->Print();
        }
    }
private: System::Void printSetupItem_Click(System::Object *  sender, System::EventArgs *  e)
	{
        // Create a page setup dialog and attach it to the printer document
        PageSetupDialog* ps = new PageSetupDialog();
        ps->Document = pdoc;

        // Print Setup fails when there is no printer...
        try
        {
            ps->ShowDialog();
        }
        catch(Exception *pe)
        {
            MessageBox::Show(pe->Message, "Error");
        }
    }			
private: System::Void PrintAPage(Object* pSender, PrintPageEventArgs * pe)
	{
		// Get the printer's Graphic object and Margins
		Form_Render(pe->Graphics, pe->MarginBounds);
	}
private: System::Void Form_Paint(Object* pSender, PaintEventArgs* pe)
	{
		Form_Render(pe->Graphics, ClientSize);
	}
private: System::Void Form_Resize(Object* pSender, EventArgs* pe)
	{
		Graphics* pg = CreateGraphics();
		Form_Render(pg, ClientSize);
		pg->Dispose();
	}
private: System::Void Form_Render(Graphics* gr, Rectangle rect)		// rect is our clientsize
	{
		#define LEFTMARGIN	100			// margin between form window and scope display
		#define RIGHTMARGIN 15
		#define TOPMARGIN	15
		#define BOTMARGIN	130

		Pen* pen1 = new Pen(Color::Black);
		Pen* pen2 = new Pen(Color::Black, 2);
		Pen* pen3 = new Pen(Color::Red, 2);
		Pen* pen4 = new Pen(Color::Blue, 2);
		Pen* pen5 = new Pen(Color::Green, 2);
		Pen* pen6 = new Pen(Color::Purple, 2);
		Pen* pen7 = new Pen(Color::Aqua, 2);
		Pen* pen8 = new Pen(Color::Brown, 2);
		Pen* pen9 = new Pen(Color::DarkCyan, 2);
		Pen* pen10 = new Pen(Color::DeepPink, 2);
		Pen* pen11 = new Pen(Color::Fuchsia, 2);
		Pen* pen12 = new Pen(Color::DarkGoldenrod, 2);
		Pen* pengray = new Pen(Color::Gray);

		SolidBrush* brush1 = new SolidBrush(Color::Black);
		SolidBrush* brush3 = new SolidBrush(Color::Red);
		SolidBrush* brush4 = new SolidBrush(Color::Blue);
		SolidBrush* brush5 = new SolidBrush(Color::Green);
		SolidBrush* brush6 = new SolidBrush(Color::Purple);
		SolidBrush* brush7 = new SolidBrush(Color::Aqua);

		System::Drawing::Font * Markerfont = new System::Drawing::Font("Arial", 7, FontStyle::Regular);
		System::Drawing::Font * Statusfont = new System::Drawing::Font("Arial", 10, FontStyle::Regular);

		SolidBrush* brwhite = new SolidBrush(Color::White);

		Point leftTick, rightTick, topTick, bottomTick, minorTopTick, minorBotTick; // rectangular display
		Point traceStart, traceStop;							// incremental trace drawing points
		Point polarCenter, polarRightCenter;					// polar display bounding box

		float PixelsPerGrid;
		int polarRadius;										// radius of the polar display
		int scalefactor;										// Group delay

		// clear the entire client window
		gr->Clear(Color::FromKnownColor(KnownColor::Control));

		// Determine the rectangle coordinates for the scope display
		// anchored to top/left, and leaving room for the Freq & Level controls

		Rectangle tempPolarBox;					// scope display area
		scopeDisp.X = rect.Left + LEFTMARGIN;			// leave some space on left side of display
		scopeDisp.Y = rect.Top + TOPMARGIN;			// leave some space on top of display
		scopeDisp.Height = rect.Height - (BOTMARGIN + TOPMARGIN);	// leave room for controls at bottom of display
		scopeDisp.Width = rect.Width - (RIGHTMARGIN + LEFTMARGIN);		// leave some space on right side of display
		polarCenter.X = scopeDisp.X + scopeDisp.Width/2;
		polarCenter.Y = scopeDisp.Y + scopeDisp.Height/2;
		polarRightCenter.Y = polarCenter.Y;		// (X-location of right center depends on display size)

		Point topleft(scopeDisp.X, rect.Top);
		Point topleftcenter(scopeDisp.X + scopeDisp.Width/3, rect.Top);
		Point topright(scopeDisp.X + scopeDisp.Width - scopeDisp.Width/8, rect.Top);
		Point botleft(scopeDisp.X, scopeDisp.Y + scopeDisp.Height);
		Point botright(scopeDisp.X + scopeDisp.Width + RIGHTMARGIN - scopeDisp.Width/6, scopeDisp.Y + scopeDisp.Height);
		Point botleftcenter(scopeDisp.X + scopeDisp.Width/2 + RIGHTMARGIN - scopeDisp.Width/4, scopeDisp.Y + scopeDisp.Height);
		Point botrightcenter(scopeDisp.X + scopeDisp.Width/2 + RIGHTMARGIN, scopeDisp.Y + scopeDisp.Height);
		Point leftstatuspoint(scopeDisp.X - LEFTMARGIN + 10, scopeDisp.Y);


		if (rectItem->Checked == true)  // render screen in rectangular mode
		{
			gr->FillRectangle(brwhite, scopeDisp);
			gr->DrawRectangle(pen2, scopeDisp);

			for (int i=0; i<9; i++)				// draw major grid
			{
				leftTick.X = scopeDisp.X;
				leftTick.Y = scopeDisp.Y + scopeDisp.Height * (i+1) /10;
				rightTick.X = scopeDisp.X + scopeDisp.Width;
				rightTick.Y = scopeDisp.Y + scopeDisp.Height * (i+1) /10;
				topTick.X = scopeDisp.X + scopeDisp.Width * (i+1) / 10;
				topTick.Y = scopeDisp.Y;
				bottomTick.X = scopeDisp.X + scopeDisp.Width * (i+1) / 10;
				bottomTick.Y = scopeDisp.Y + scopeDisp.Height;
				gr->DrawLine(pen1, leftTick, rightTick);
				gr->DrawLine(pen1, topTick, bottomTick);
			};

			// draw minor grid along center horizontal line
			minorTopTick.Y = scopeDisp.Y + scopeDisp.Height/2 + 3;
			minorBotTick.Y = minorTopTick.Y - 6;
			for (int i=0; i<50; i++)
			{
				minorTopTick.X = scopeDisp.X + scopeDisp.Width * i /50;
				minorBotTick.X = scopeDisp.X + scopeDisp.Width * i /50;
				gr->DrawLine(pen1, minorTopTick, minorBotTick);
			}

			// draw minor grid along center vertical line
			minorTopTick.X = scopeDisp.X + scopeDisp.Width/2 + 3;
			minorBotTick.X = minorTopTick.X - 6;
			for (int i=0; i<50; i++)
			{
				minorTopTick.Y = scopeDisp.Y + scopeDisp.Height * i /50;
				minorBotTick.Y = scopeDisp.Y + scopeDisp.Height * i /50;
				gr->DrawLine(pen1, minorTopTick, minorBotTick);
			}

			
			// Display status in margin above top of scope display

			String * text;						// Vertical Magnitude, dB/div
			if (RectVertScaledB == 10)
				text = S"VERT: 10 dB/DIV";
			else if (RectVertScaledB == 5)
				text = S"VERT:  5 dB/DIV";
			else if (RectVertScaledB == 2)
				text = S"VERT:  2 dB/DIV";
			else if (RectVertScaledB == 1)
				text = S"VERT:  1 dB/DIV";

			gr->DrawString(text, Statusfont, brush1, topleft);

			if (scale100psec->Checked)
			{
				scalefactor = 1;
				text = S"VERT: 100 PICOSEC/DIV";
			}
			else if (scalenanoSec->Checked)
			{
				scalefactor = 10;
				text = S"VERT:   1 NANOSEC/DIV";
			}
			else if (scale10nsec->Checked)
			{
				scalefactor = 100;
				text = S"VERT:  10 NANOSEC/DIV";
			}
			else if (scale100nsec->Checked)
			{
				scalefactor = 1000;
				text = S"VERT: 100 NANOSEC/DIV";
			}
			else if (scalemicroSec->Checked)
			{
				scalefactor = 10000;
				text = S"VERT:   1 MICROSEC/DIV";
			}
			else if (scale10microsec->Checked)
			{
				scalefactor = 100000;
				text = S"VERT:  10 MICROSEC/DIV";
			}
			if(s21groupdelayItem->Checked)
                gr->DrawString(text, Statusfont, brush1, topleftcenter);	// time, sec/div

            gr->DrawString(S"TAPR VNA", Statusfont, brush1, topright);	// TAPR
		

			// Display status in margin below botton of scope display

			gr->DrawString(String::Concat(S"START: ", FG->StartF.ToString("N0")), Statusfont, brush1, botleft);

			gr->DrawString(String::Concat(S"STOP: ", FG->StopF.ToString("N0")),	Statusfont, brush1, botright);

			int span = FG->StopF - FG->StartF;
			gr->DrawString(String::Concat(S"SPAN: ", span.ToString("N0")), Statusfont, brush1, botleftcenter);

			span = span / 10;			// per division
			gr->DrawString(String::Concat(S"HORIZ: ", span.ToString("N0"), S" Hz/DIV"),
				Statusfont, brush1, botrightcenter);


			// Display marker status in margin on left side of scope display
			for (int i = 0; i<5; i++)
			{
				if (Marker[i] > 0)
					gr->DrawString(String::Concat(S"Marker ",Convert::ToString(i+1),S"\n", Marker[i].ToString("N0")),
						Statusfont, brush1, leftstatuspoint);

				leftstatuspoint.Y += 40;
			}

			// Display Reference Level
			leftstatuspoint.Y = scopeDisp.Y + 250;
			gr->DrawString(String::Concat(S"Ref Lvl:\n", refLevel.ToString(), S" dB"),
				Statusfont, brush1, leftstatuspoint);


			PixelsPerGrid = (float)scopeDisp.Width / (float)FG->Points;

			double fmagnitude;			// 0 to 1
			double fphase;				// -180 to +180	
			double& rmag = fmagnitude;
			double& rphs = fphase;
			int	oldY =0;				// for group delay
//			int dBPerDivision;			// dB per division for rectangular magnitude display

			// draw traces as selected by Trace menu checkmarks

			// ***********************************
			// ***********************************
			// temp debugging ********************
			//FileStream* fs;
			//StreamWriter* sw;
			//fs = new FileStream("VNAdebug.txt", FileMode::Create, FileAccess::Write);
			//sw = new StreamWriter(fs);
			// end temp debugging **********************
			// ***********************************
			// ***********************************

			for (int i=1; i<FG->Points; i++)	// Display measurements on the frequency grid
			{
				traceStart.X = scopeDisp.X + (int)(((float)i-1.0) * PixelsPerGrid); // previous point
				traceStop.X = scopeDisp.X + (int)((float)i * PixelsPerGrid);		// current point

// *********************** debugging code to display raw data  ***************************
				////	Reflected Phase
				//traceStop.Y = scopeDisp.Bottom - trace3[i] * scopeDisp.Height / 3800;
				//traceStart.Y = scopeDisp.Bottom - trace3[i-1] * scopeDisp.Height / 3800;
				//gr->DrawLine(pen5, traceStart, traceStop);
				//traceStop.Y = scopeDisp.Bottom - trace4[i] * scopeDisp.Height / 3800;
				//traceStart.Y = scopeDisp.Bottom - trace4[i-1] * scopeDisp.Height / 3800;
				//gr->DrawLine(pen6, traceStart, traceStop);
				////	Reference Voltages
				//traceStop.Y = scopeDisp.Bottom - trace5[i] * scopeDisp.Height / 3800;
				//traceStart.Y = scopeDisp.Bottom - trace5[i-1] * scopeDisp.Height / 3800;
				//gr->DrawLine(pen7, traceStart, traceStop);
				//traceStop.Y = scopeDisp.Bottom - trace10[i] * scopeDisp.Height / 3800;
				//traceStart.Y = scopeDisp.Bottom - trace10[i-1] * scopeDisp.Height / 3800;
				//gr->DrawLine(pen8, traceStart, traceStop);
				////	Transmit Phase
				//traceStop.Y = scopeDisp.Bottom - trace8[i] * scopeDisp.Height / 3800;
				//traceStart.Y = scopeDisp.Bottom - trace8[i-1] * scopeDisp.Height / 3800;
				//gr->DrawLine(pen5, traceStart, traceStop);
				//traceStop.Y = scopeDisp.Bottom - trace9[i] * scopeDisp.Height / 3800;
				//traceStart.Y = scopeDisp.Bottom - trace9[i-1] * scopeDisp.Height / 3800;
				//gr->DrawLine(pen6, traceStart, traceStop);


				// code to dump raw data to file
				//sw->Write(FG->Frequency(i));
				//sw->Write(", ");
				//sw->Write(trace8[i]);
				//sw->Write(", ");
				//sw->WriteLine(trace9[i]);

//
// ******************************* end debuging code **************************************


				if(s21magItem->Checked)
				{
					// previous point
					CalData->ResolveTranPolar(trace8[i-1], trace9[i-1], trace7[i-1], FG->Frequency(i-1), rmag, rphs);
					if (calCheckBox->Checked)
						CorrectS21(CalData, FG->Frequency(i-1), fmagnitude, fphase, rmag, rphs);
					traceStart.Y = scopeDisp.Y + ToDisplayRectMag(fmagnitude, scopeDisp.Height, RectVertScaledB, refLevel);

					// current point
					CalData->ResolveTranPolar(trace8[i], trace9[i], trace7[i], FG->Frequency(i), rmag, rphs);
					if (calCheckBox->Checked)
						CorrectS21(CalData, FG->Frequency(i), fmagnitude, fphase, rmag, rphs);
					traceStop.Y = scopeDisp.Y + ToDisplayRectMag(fmagnitude, scopeDisp.Height, RectVertScaledB, refLevel);

					gr->DrawLine(pen3, traceStart, traceStop);

	// debug using the MQ indicators
	//
	//
					//CalData->ResolveTranPolar(trace8[i-1], trace9[i-1], trace7[i-1], rmag, rphs);
					//if (calCheckBox->Checked)
					//	CorrectS21(CalData, FG->Frequency(i-1), fmagnitude, fphase, rmag, rphs);
					//traceStart.Y = scopeDisp.Y + ToDisplayRectMag(fmagnitude, scopeDisp.Height, RectVertScaledB, refLevel);

					//// current point
					//CalData->ResolveTranPolar(trace8[i], trace9[i], trace7[i], rmag, rphs);
					//if (calCheckBox->Checked)
					//	CorrectS21(CalData, FG->Frequency(i), fmagnitude, fphase, rmag, rphs);
					//traceStop.Y = scopeDisp.Y + ToDisplayRectMag(fmagnitude, scopeDisp.Height, RectVertScaledB, refLevel);

					//gr->DrawLine(pen8, traceStart, traceStop);
	//
	//
	// end using MQ indicators


					DrawMarkers(gr, pen3, brush3, traceStop, Markerfont, i);					
				}
				if(s21phsItem->Checked)
				{
					// previous point
					CalData->ResolveTranPolar(trace8[i-1], trace9[i-1], trace7[i-1], FG->Frequency(i-1), rmag, rphs);
					if (calCheckBox->Checked)
						CorrectS21(CalData, FG->Frequency(i-1), fmagnitude, fphase, rmag, rphs);
					traceStart.Y = scopeDisp.Bottom - ToDisplayRectPhs(fphase, scopeDisp.Height);

					// current point
					CalData->ResolveTranPolar(trace8[i], trace9[i], trace7[i], FG->Frequency(i), rmag, rphs);
					if (calCheckBox->Checked)
						CorrectS21(CalData, FG->Frequency(i), fmagnitude, fphase, rmag, rphs);
					traceStop.Y = scopeDisp.Bottom - ToDisplayRectPhs(fphase, scopeDisp.Height);

					gr->DrawLine(pen4, traceStart, traceStop);

					DrawMarkers(gr, pen4, brush4, traceStop, Markerfont, i);					
				}

				if(s11magItem->Checked)
				{
					// previous point
					CalData->ResolveReflPolar(trace3[i-1], trace4[i-1], trace2[i-1], FG->Frequency(i-1), rmag, rphs);
					if (calCheckBox->Checked)
						CorrectS11(CalData, FG->Frequency(i-1), fmagnitude, fphase, rmag, rphs);
					traceStart.Y = scopeDisp.Y + ToDisplayRectMag(fmagnitude, scopeDisp.Height, RectVertScaledB, refLevel);

					// current point
					CalData->ResolveReflPolar(trace3[i], trace4[i], trace2[i], FG->Frequency(i), rmag, rphs);
					if (calCheckBox->Checked)
						CorrectS11(CalData, FG->Frequency(i), fmagnitude, fphase, rmag, rphs);
					traceStop.Y = scopeDisp.Y + ToDisplayRectMag(fmagnitude, scopeDisp.Height, RectVertScaledB, refLevel);

					gr->DrawLine(pen5, traceStart, traceStop);

		// debug using RelMQ indicators
		//
		//
					//CalData->ResolveReflPolar(trace3[i-1], trace4[i-1], trace2[i-1], rmag, rphs);
					//if (calCheckBox->Checked)
					//	CorrectS11(CalData, FG->Frequency(i-1), fmagnitude, fphase, rmag, rphs);
					//traceStart.Y = scopeDisp.Y + ToDisplayRectMag(fmagnitude, scopeDisp.Height, RectVertScaledB, refLevel);

					//// current point
					//CalData->ResolveReflPolar(trace3[i], trace4[i], trace2[i], rmag, rphs);
					//if (calCheckBox->Checked)
					//	CorrectS11(CalData, FG->Frequency(i), fmagnitude, fphase, rmag, rphs);
					//traceStop.Y = scopeDisp.Y + ToDisplayRectMag(fmagnitude, scopeDisp.Height, RectVertScaledB, refLevel);

					//gr->DrawLine(pen12, traceStart, traceStop);
		//
		//
		// end debug using refl MQ indicators

					DrawMarkers(gr, pen5, brush5, traceStop, Markerfont, i);					
				}

				if(s11phsItem->Checked)
				{
					// previous point
					CalData->ResolveReflPolar(trace3[i-1], trace4[i-1], trace1[i-1], FG->Frequency(i-1), rmag, rphs);
					if (calCheckBox->Checked)
						CorrectS11(CalData, FG->Frequency(i-1), fmagnitude, fphase, rmag, rphs);
					traceStart.Y = scopeDisp.Bottom - ToDisplayRectPhs(fphase, scopeDisp.Height);

					// current point
					CalData->ResolveReflPolar(trace3[i], trace4[i], trace1[i], FG->Frequency(i), rmag, rphs);
					if (calCheckBox->Checked)
						CorrectS11(CalData, FG->Frequency(i), fmagnitude, fphase, rmag, rphs);
					traceStop.Y = scopeDisp.Bottom - ToDisplayRectPhs(fphase, scopeDisp.Height);

					gr->DrawLine(pen6, traceStart, traceStop);

					DrawMarkers(gr, pen6, brush6, traceStop, Markerfont, i);					
				}

				if(s21groupdelayItem->Checked)
				{
					// previous point
					CalData->ResolveTranPolar(trace8[i-1], trace9[i-1], trace7[i-1], FG->Frequency(i-1), rmag, rphs);
					if (calCheckBox->Checked)
						CorrectS21(CalData, FG->Frequency(i-1), fmagnitude, fphase, rmag, rphs);
					double prevphs = fphase;
					int prevfreq = FG->Frequency(i-1);

					// current point
					CalData->ResolveTranPolar(trace8[i], trace9[i], trace7[i], FG->Frequency(i), rmag, rphs);
					if (calCheckBox->Checked)
						CorrectS21(CalData, FG->Frequency(i), fmagnitude, fphase, rmag, rphs);
					double currphs = fphase;
					int currfreq = FG->Frequency(i);

					// test to see if phase wrapped around -180 degrees point, and correct for G.D.
					if ((prevphs < -135.0) && (currphs > 135.0))
						prevphs += 360.0;

					// phs is in degrees, frequency in hertz), need to divide by 360.0
					// to convert to (radians / radians-per-second) to yield group delay in seconds
					double groupdelay = - ((currphs - prevphs) / (double)(currfreq - prevfreq) / 360.0);

					if (groupdelay < 0.0)		// prevent display of negative (i.e. wrong) values
						groupdelay = 0.0;

					traceStop.Y = scopeDisp.Bottom - ToDisplayRectGD(groupdelay, scopeDisp.Height, scalefactor);

					traceStart.Y = oldY;

					if (i>1)
						gr->DrawLine(pen7, traceStart, traceStop);

					DrawMarkers(gr, pen7, brush7, traceStop, Markerfont, i);					

					oldY = traceStop.Y;		// save stopping point for next iteration
				}

				if(calSthru->Checked)
				{
					// Convert results to polar coordinates
					double xx = CalData->ThReal[i];
					double yy = CalData->ThImag[i];

					fphase = 180.0/3.1415926 * atan2(yy, xx);
					fmagnitude = sqrt(xx*xx + yy*yy);

					// current point - magnitude
					int scaleFactor;
					if (Scale10dB->Checked)	scaleFactor = 10;
					else if (Scale5dB->Checked)	scaleFactor = 5;
					else if (Scale2dB->Checked)	scaleFactor = 2;
					else if (Scale1dB->Checked)	scaleFactor = 1;

					traceStop.Y = scopeDisp.Y + ToDisplayRectMag(fmagnitude, scopeDisp.Height, scaleFactor, refLevel);

					gr->DrawLine(pen7, traceStop.X, traceStop.Y, traceStop.X+2, traceStop.Y+2);

					// current point - phase
					traceStop.Y = scopeDisp.Y + ToDisplayRectPhs(fphase, scopeDisp.Height);
					gr->DrawLine(pen8, traceStop.X, traceStop.Y, traceStop.X+2, traceStop.Y+2);
				}

			}


			// temp debugging code *****************************************
			// ***************************************
			//sw->Flush();
			//sw->Close();
			// ******* end temp debugging code **********************
			// **************************************************
		}
		else							// render screen in polar mode
		{
			// find the smaller of the horizontal or vertical size & set RightCenter coordinates
			if (scopeDisp.Height > scopeDisp.Width)
				polarRadius = scopeDisp.Width/2;
			else
				polarRadius = scopeDisp.Height/2;

			polarRightCenter.X = polarCenter.X + polarRadius;

			// build the bounding rectangle for the polar display
			polarBox.X = polarCenter.X - polarRadius;
			polarBox.Width = polarRadius * 2;
			polarBox.Y = polarCenter.Y - polarRadius;
			polarBox.Height = polarRadius *2;

			// draw polar display and outside circle
			gr->FillEllipse(brwhite, polarBox);
			gr->DrawEllipse(pen2, polarBox);

			// build and set circular clipping region for subsequent drawing
			GraphicsPath *gpUnit = new GraphicsPath();		// Holds just the unit circle
			GraphicsPath *gpLarger = new GraphicsPath();	// Holds more that unit circle

			// to make polar plot larger than unit circle
			Rectangle tempbox;
			tempbox.X = polarBox.X -10;
			tempbox.Y = polarBox.Y -10;
			tempbox.Width = polarBox.Width + 20;
			tempbox.Height = polarBox.Height + 20;

			gpUnit->AddEllipse(polarBox);
			gpLarger->AddEllipse(tempbox);

            gr->SetClip(gpUnit);	// Set unit circle for drawing background grids

//
//	Table for value of gamma (reflection coefficient) vs. resistance, and radius of resistance circle
//
			//  0 ohms  ->  gamma = 1       radius = (1+1.00)/2 = 1.000 (no need to draw)
			//	10 ohms ->  gamma = .666	radius = (1+.666)/2 = 0.833
			//	25 ohms ->  gamma = .333	radius = (1+.333)/2 = 0.666
			//	50 ohms ->  gamma = 0		radius = (1+.000)/2 = 0.500
			//	100 ohms -> gamma = .333	radius = (1-.333)/2 = 0.333
			//	250 ohms -> gamma = .666	radius = (1-.666)/2 = 0.167
			//	500 ohms -> gamma = .818	radius = (1-.818)/2 = 0.091

			int resCircleRadius[6] = { 83, 66, 50, 33, 17, 9 };		// radius * 100

//
//  Table for reactance circles and equivalent radius
//  Taking a guess that the formula for radius is 50/reactance
//
			//  0 ohms			radius = 50/0 = infinite (straight line)
			//	10 ohms			radius = 50/10 = 5
			//	25 ohms			radius = 50/25 = 2
			//	50 ohms			radius = 50/50 = 1
			// 100 ohms			radius = 50/100 = 0.50
			// 250 ohms			radius = 50/250 = 0.20
			// 500 ohms			radius = 50/500 = 0.10

			int reacCircleRadius[6] = { 500, 200, 100, 50, 20, 10 };	// radius * 100


			// draw resistance circles
			for (int i=0; i<6; i++)
			{
				// resize the radius (using integer math)
				tempPolarBox.Width = polarBox.Width * resCircleRadius[i]; tempPolarBox.Width /= 100;
				tempPolarBox.Height = polarBox.Height * resCircleRadius[i]; tempPolarBox.Height /= 100;
				// recenter circle on the right-hand side, centered vertically to chart center
				tempPolarBox.X = polarBox.X + (polarBox.Width - tempPolarBox.Width);
				tempPolarBox.Y = polarBox.Y + (polarBox.Height - tempPolarBox.Height)/2;

				gr->DrawEllipse(pengray, tempPolarBox);	
			}

			// draw center horizontal line (zero reactance line, infinite radius)
			gr->DrawLine(pengray, polarBox.X, polarBox.Y + polarRadius, polarBox.Right, polarBox.Y + polarRadius);

			// draw upper reactance circles
			for (int i=0; i<6; i++)
			{
				// resize the radius (using integer math)
				tempPolarBox.Width = polarBox.Width * reacCircleRadius[i]; tempPolarBox.Width /= 100;
				tempPolarBox.Height = polarBox.Height * reacCircleRadius[i]; tempPolarBox.Height /= 100;
				// recenter circle on the right hand side, bottom of circle at vertical center of chart
				tempPolarBox.X = polarBox.X + polarBox.Width - tempPolarBox.Width/2;
				tempPolarBox.Y = polarBox.Y + polarBox.Height/2 - tempPolarBox.Height;

				gr->DrawEllipse(pengray, tempPolarBox);
			}

			// draw lower reactance circles
			for (int i=0; i<6; i++)
			{
				// resize the radius (using integer math)
				tempPolarBox.Width = polarBox.Width * reacCircleRadius[i]; tempPolarBox.Width /= 100;
				tempPolarBox.Height = polarBox.Height * reacCircleRadius[i]; tempPolarBox.Height /= 100;
				// recenter circle on the right hand side, top of circle at vertical center of chart
				tempPolarBox.X = polarBox.X + polarBox.Width - tempPolarBox.Width/2;
				tempPolarBox.Y = polarBox.Y + polarBox.Height/2;

				gr->DrawEllipse(pengray, tempPolarBox);
			}

			// Draw reflection measurements on Polar Chart
			// Requires resolving the phase quandrant from I/Q measurements
			//   and magnitude from the reflection magnitude (which is a logrithmic value).
			//
			// when ReflPI is low,  the phase is near   0 degrees
			// when ReflPI is high, the phase is near 180 degrees
			// when ReflPQ is low,  the phase is near  90 degrees
			// when ReflPQ is high, the phase is near -90 degrees
			//
			// The I and Q phase readings saturates near the bottom and top of the reading,
			//   but the other reading is then in the middle of it's useful range.
			//   This it's always possible to accurately resolve the phase and quadrant.
			//
			// Quadrant 1 is 0 to +90 degrees, quadrant 2 is +90 to +180,
			//   quadrant 3 is -180 to -90, quadrant 4 is 0 to -90 degrees.
			//


			// For this test code, the trace[] arrays have been loaded as follows
			//
			// trace1[] = ReflMI	trace2[] =	ReflMQ
			// trace3[] = ReflPI	trace4[] =  ReflPQ
			// trace5[] = Vref1
			//

			double fmagnitude;			// 0 to 1
			double fphase;				// -180 to +180	
			double& rmag = fmagnitude;
			double& rphs = fphase;
			int	x,y;					// display coordinate
			int& rx = x;
			int& ry = y;

			gr->SetClip(gpLarger);	// Set enlarged circle for drawing points a bit outside the unit circle

			for (int i=0; i<FG->Points; i++)	// Display the frequency grid
			{
				// convert measurements into polar S11
				CalData->ResolveReflPolar(trace3[i], trace4[i], trace2[i], FG->Frequency(i), rmag, rphs);

				// Correct S11 measured values against Calibration data

				if (calCheckBox->Checked)
					CorrectS11(CalData, FG->Frequency(i), fmagnitude, fphase, rmag, rphs);

				// Convert from polar to rectangular format, scale to chart size,
				// and align with respect the center of the chart.
				ToDisplayPolar(fmagnitude, fphase, polarRadius, polarBox.X, polarBox.Y, rx, ry);

				// store the display point
				traceStop.X = x;
				traceStop.Y = y;

				// draw from previous to current point
				if (i > 0)
					gr->DrawLine(pen3, traceStart, traceStop);

				DrawMarkers(gr, pen3, brush3, traceStop, Markerfont, i);					

				// store as previous point
				traceStart.X = x;
				traceStart.Y = y;

				//Display error correction parameters -- for debugging
				// There are 1024 calibration frequencies, find the one nearest to the measured frequency.

				double delta = (120000000 - 200000)/ (1024 - 1);		// frequency separation of cal points
				int j = (int)((((float)FG->Frequency(i) - 200000) + delta/2.0) / delta); // nearest one

				if (EtTrace->Checked == true)
				{
							// Convert results to polar coordinates
					double xx = CalData->EtReal[i];
					double yy = CalData->EtImag[i];

					fphase = 180/3.1415926 * atan2(yy, xx);
					fmagnitude = sqrt(xx*xx + yy*yy);

					ToDisplayPolar(fmagnitude, fphase, polarRadius, polarBox.X, polarBox.Y, rx, ry);
					gr->DrawLine(pen4, x, y, x+2, y+2);
				}


				if (EsTrace->Checked == true)
				{
							// Convert results to polar coordinates
					double xx = CalData->EsReal[i];
					double yy = CalData->EsImag[i];

					fphase = 180/3.1415926 * atan2(yy, xx);
					fmagnitude = sqrt(xx*xx + yy*yy);

					ToDisplayPolar(fmagnitude, fphase, polarRadius, polarBox.X, polarBox.Y, rx, ry);
					gr->DrawLine(pen5, x, y, x+2, y+2);
				}


				if (EdTrace->Checked == true)
				{
							// Convert results to polar coordinates
					double xx = CalData->EdReal[i];
					double yy = CalData->EdImag[i];

					fphase = 180/3.1415926 * atan2(yy, xx);
					fmagnitude = sqrt(xx*xx + yy*yy);

					ToDisplayPolar(fmagnitude, fphase, polarRadius, polarBox.X, polarBox.Y, rx, ry);
					gr->DrawLine(pen6, x, y, x+2, y+2);
				}

				if (calSshort->Checked == true)
				{
							// Convert results to polar coordinates
					double xx = CalData->S11shortReal[i];
					double yy = CalData->S11shortImag[i];

					fphase = 180/3.1415926 * atan2(yy, xx);
					fmagnitude = sqrt(xx*xx + yy*yy);

					ToDisplayPolar(fmagnitude, fphase, polarRadius, polarBox.X, polarBox.Y, rx, ry);
					gr->DrawLine(pen4, x, y, x+2, y+2);
				}

				if (calSopen->Checked == true)
				{
							// Convert results to polar coordinates
					double xx = CalData->S11openReal[i];
					double yy = CalData->S11openImag[i];

					fphase = 180/3.1415926 * atan2(yy, xx);
					fmagnitude = sqrt(xx*xx + yy*yy);

					ToDisplayPolar(fmagnitude, fphase, polarRadius, polarBox.X, polarBox.Y, rx, ry);
					gr->DrawLine(pen5, x, y, x+2, y+2);
				}

				if (calSterm->Checked == true)
				{
							// Convert results to polar coordinates
					double xx = CalData->S11termReal[i];
					double yy = CalData->S11termImag[i];

					fphase = 180/3.1415926 * atan2(yy, xx);
					fmagnitude = sqrt(xx*xx + yy*yy);

					ToDisplayPolar(fmagnitude, fphase, polarRadius, polarBox.X, polarBox.Y, rx, ry);
					gr->DrawLine(pen6, x, y, x+2, y+2);
				}



			}
		}
	}

private: System::Void Form_Render(Graphics* gr, System::Drawing::Size size)
{
    // Resize & Paint give us their size.
    // Convert the size to a rectangle with 0,0 as the (Top,Left) origin
    // then call the Render with the resultant rectangle.
    // (PrintPage calls Render directly with a rectangle region).
    rect.set_Size(size);
    rect.set_X(0);
    rect.set_Y(0);
    Form_Render(gr, rect);
}
private: System::Void Form_MouseDown(Object * pSender, MouseEventArgs* pe)
{
    p1.X = pe->X;
    p1.Y = pe->Y;
}
private: System::Void Form_MouseUp(Object* pSender, MouseEventArgs* pe)
{

    if(pe->Button == MouseButtons::Left)
    {
    }
    else if(pe->Button == MouseButtons::Right)
    {
    }

}
private: System::Void VNA_Initialize(void)
		{
   
			trace1 = new unsigned short __gc[2048];	// allocate arrays for traces to display
			trace2 = new unsigned short __gc[2048];
			trace3 = new unsigned short __gc[2048];
			trace4 = new unsigned short __gc[2048];
			trace5 = new unsigned short __gc[2048];
			trace6 = new unsigned short __gc[2048];
			trace7 = new unsigned short __gc[2048];
			trace8 = new unsigned short __gc[2048];
			trace9 = new unsigned short __gc[2048];
			trace10 = new unsigned short __gc[2048];

			stS11Mag = new double __gc[1024];		// allocate space for S-param storage
			stS11Phs = new double __gc[1024];		
			stS21Mag = new double __gc[1024];
			stS21Phs = new double __gc[1024];		
			stS12Mag = new double __gc[1024];
			stS12Phs = new double __gc[1024];		
			stS22Mag = new double __gc[1024];
			stS22Phs = new double __gc[1024];		

			StartUpPath = Directory::GetCurrentDirectory();		// Save start-up directory path

	// Open the target 8051 binary file, and prepare to download it

			FileStream* fs;
			Byte Codebuffer __gc[];
			int Length;

			OpenFileDialog* infile = new OpenFileDialog();

	// User-select the name of the code to download to the VNA
	//		infile->Filter = "binary files (*.bin)|*.bin";
	//		infile->Title = S"Select binary file to download to target";
	//		infile->ShowDialog();

	// Hard code the name of the code to download to the VNA
			infile->FileName = String::Concat(StartUpPath, S"\\VNA_target.bin");

			try
			{
				fs = new FileStream(infile->FileName,FileMode::Open, FileAccess::Read);
			}
			catch(System::Exception* pe)
			{
				MessageBox::Show(pe->Message,S"Error");
				Environment::Exit(1);
			}
			
			Length = static_cast<int>(fs->Length);

			if (Length < 4096)
				Codebuffer = new Byte __gc[4096];
			else
			{
				MessageBox::Show(S" Download file too long",S"Error");
				Environment::Exit(1);
			}

			fs->Read(Codebuffer, 0, Length);
			fs->Close();

			VNA = new VNADevice;
			if (VNA->State == 1)		// EZUSBDRV found our device handle
			{
				bool result;

				result = VNA->Stop();				// Make sure 8051 is halted
				if (!result)
					MessageBox::Show(S"VNA Device Error: Stop",S"Error");

				result = VNA->Download(Codebuffer, Length, 0);
				if (!result)
					MessageBox::Show(S"VNA Device Error: Download",S"Error");

				result = VNA->Start();				// Start the 8051 processor
				if (!result)
					MessageBox::Show(S"VNA Device Error: Start",S"Error");

				for (int k=0; k<3; k++)
				{
					result = VNA->Init();				// Build VNA descriptor tables, get pipes
					if (!result)
						MessageBox::Show(S"VNA Device Error: Init",S"Error");
				};

			}
			else
			{
				MessageBox::Show(S"Cannot open VNA Device",S"Error");
				Environment::Exit(1);
			}
		}

private: System::Void startFup_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 if (FG->StartF < 120000000) // max allowed frequency
				{
					FG->SetStartF(FG->StartF + 1);
					startF->Text = FG->StartF.ToString("N0");
				}
		 }

private: System::Void startFdown_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			if (FG->StartF > 200000)    // min allowed frequency
				{
					FG->SetStartF(FG->StartF - 1);
					startF->Text = FG->StartF.ToString("N0");
				}
		 }

private: System::Void stopFup_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 if (FG->StopF < 120000000)  // max allowed frequency
				{
					FG->SetStopF(FG->StopF + 1);
					stopF->Text = FG->StopF.ToString("N0");
				}
		 }

private: System::Void stopFdown_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			if (FG->StopF > 200000) // min allowed frequency
				{
					FG->SetStopF(FG->StopF - 1);
					stopF->Text = FG->StopF.ToString("N0");
				}
		 }

private: System::Void txLup_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			if (txLevel < 0)   // maximum allowed value
				{
					txLevel += 1;
					txL->Text = txLevel.ToString();
				}

		 }

private: System::Void txLdown_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			if (txLevel > -60)  // minimum allowed value
				{
					txLevel -= 1;
					txL->Text = txLevel.ToString();
				}
		 }

private: System::Void refLup_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			if (refLevel < 10)  // maximum allowed value
			{
				refLevel += 1;
				refL->Text = refLevel.ToString();
			}
			Refresh();
		 }

private: System::Void refLdown_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			if (refLevel > -50) // minimum allowed value
				{
					refLevel -= 1;
					refL->Text = refLevel.ToString();
				}
			Refresh();
		 }

private: System::Void startF_DoubleClick(System::Object *  sender, System::EventArgs *  e)
			{
				// pop up a direct entry window
				NumEntBox* nb = new NumEntBox();
				nb->set_NumericValue(FG->StartF);
				if (nb->ShowDialog() == DialogResult::OK)
				{
					int tempF = nb->get_NumericValue();
					// check for legitimate values for startF
					if (tempF >= 200000 && tempF <= 120000000)
					{
						FG->SetStartF(tempF);
						startF->Text = FG->StartF.ToString("N0");
					}
					else
						MessageBox::Show("Frequency must be between 200,000 and 120,000,000",
							"Out of Range");
				}
			}
private: System::Void stopF_DoubleClick(System::Object *  sender, System::EventArgs *  e)
			 {
				// pop up a direct entry window
				NumEntBox* nb = new NumEntBox();
				nb->set_NumericValue(FG->StopF);
				if (nb->ShowDialog() == DialogResult::OK)
				{
					int tempF = nb->get_NumericValue();
					if (tempF >= 200000 && tempF <= 120000000)
					{
						FG->SetStopF(tempF);
						stopF->Text = FG->StopF.ToString("N0");
					}
					else
						MessageBox::Show("Frequency must be between 200,000 and 120,000,000",
							"Out of Range");
				}
			}

private: System::Void txL_DoubleClick(System::Object *  sender, System::EventArgs *  e)
		 	{
				// pop up a direct entry window
				NumEntBox* nb = new NumEntBox();
				nb->set_NumericValue(txLevel);
				if (nb->ShowDialog() == DialogResult::OK)
				{
					int tempL = nb->get_NumericValue();
					if (tempL >= -60 && tempL <= 0)
					{
						txLevel = tempL;
						txL->Text = txLevel.ToString("N0");
					}
					else
						MessageBox::Show("Level must be between -60 and 0",
							"Out of Range");
				}

			}

private: System::Void refL_DoubleClick(System::Object *  sender, System::EventArgs *  e)
		 	{
				// pop up a direct entry window
				NumEntBox* nb = new NumEntBox();
				nb->set_NumericValue(refLevel);
				if (nb->ShowDialog() == DialogResult::OK)
				{
					int tempL = nb->get_NumericValue();
					if (tempL >= -50 && tempL <= 10)
					{
						refLevel = tempL;
						refL->Text = refLevel.ToString("N0");
					}
					else
						MessageBox::Show("Level must be between -50 and +10",
							"Out of Range");
				}
				Refresh();
			}



private: System::Void printPreviewItem_Click(System::Object *  sender, System::EventArgs *  e)
        {
            // Create a print preview control and attach it to the printer document
            PrintPreviewDialog* pp = new PrintPreviewDialog();
            pp->Document = pdoc;
            try
            {
                pp->ShowDialog();
            }
            catch(Exception *pe)
            {
                MessageBox::Show(pe->Message, "Error");
            }

        }

private: System::Void exitItem_Click(System::Object *  sender, System::EventArgs *  e)
        {
			Environment::Exit(0);
        }
private: System::Void runItem_Click(System::Object *  sender, System::EventArgs *  e)
        {
			Calibration * pcal = new Calibration(CalData, VNA);
			if (pcal->ShowDialog() == DialogResult::OK)
				calCheckBox->Enabled = true;
        }

private: System::Void loadItem_Click(System::Object *  sender, System::EventArgs *  e)
        {
            OpenFileDialog* infile = new OpenFileDialog();
            infile->Filter = "calibration files (*.cal)|*.cal";
            if (infile->ShowDialog() == DialogResult::OK)
			{
                LoadCalDataSet(infile, CalData);
				calCheckBox->Enabled = true;
			}
        }

private: System::Void rectItem_Click(System::Object *  sender, System::EventArgs *  e)
		{
			rectItem->Checked = true;
			if (polarItem->Checked == true)
			{
				polarItem->Checked = false;
				// redraw display because view has changed
				Refresh();
				//Form_Resize(0, 0);
            }
		}

private: System::Void polarItem_Click(System::Object *  sender, System::EventArgs *  e)
		{
			polarItem->Checked = true;
			if (rectItem->Checked == true)
			{
				rectItem->Checked = false;
				// redraw display because view has changed
				Refresh();
			}
		}

private: System::Void s11magItem_Click(System::Object *  sender, System::EventArgs *  e)
		{
			if (s11magItem->Checked == true)
				s11magItem->Checked = false;
			else
				s11magItem->Checked = true;

			Refresh();	// Redraw window
		}
private: System::Void s11phsItem_Click(System::Object *  sender, System::EventArgs *  e)
		{
			if (s11phsItem->Checked == true)
				s11phsItem->Checked = false;
			else
				s11phsItem->Checked = true;

			Refresh();	// Redraw window
		}

private: System::Void s21magItem_Click(System::Object *  sender, System::EventArgs *  e)
		{
			if (s21magItem->Checked == true)
				s21magItem->Checked = false;
			else
				s21magItem->Checked = true;

			Refresh();	// Redraw window
		}

private: System::Void s21phsItem_Click(System::Object *  sender, System::EventArgs *  e)
		{
			if (s21phsItem->Checked == true)
				s21phsItem->Checked = false;
			else
				s21phsItem->Checked = true;

			Refresh();	// Redraw window
		}


private: System::Void s21groupdelayItem_Click(System::Object *  sender, System::EventArgs *  e)
		{
			if (s21groupdelayItem->Checked == true)
				s21groupdelayItem->Checked = false;
			else
				s21groupdelayItem->Checked = true;

			Refresh();	// Redraw window
		}


private: System::Void trigItem_Click(System::Object *  sender, System::EventArgs *  e)
        {
			VNA_RXBUFFER * RxBuf = new VNA_RXBUFFER;
			VNA_TXBUFFER * TxBuf = new VNA_TXBUFFER;
		
			VNA->Read(RxBuf);
			VNA->Read(RxBuf);

			TxBuf->ReplyType = 0;
			TxBuf->IntegrationCount = 1;
			TxBuf->QDAClevel = THREE_FIVEDB_LEVEL;	// Reference level


			// Set Tx Level

			TxBuf->IDAClevel = TxLevLinear(txLevel);

			for (int m=0; m<FG->Points; m++)
			{

				// calculate linear frequency spot for each sweep

				TxBuf->TxAccum = FG->DDS(FG->Frequency(m));

				VNA->WriteRead(TxBuf, RxBuf);

				// Save received data by grid point

				trace1[m] = RxBuf->ReflMI;
				trace2[m] = RxBuf->ReflMQ;
				trace3[m] = RxBuf->ReflPI;
				trace4[m] = RxBuf->ReflPQ;

				trace5[m] = RxBuf->Vref1;

				trace6[m] = RxBuf->TranMI;
				trace7[m] = RxBuf->TranMQ;
				trace8[m] = RxBuf->TranPI;
				trace9[m] = RxBuf->TranPQ;

				trace10[m] = RxBuf->Vref2;

				// Glitch detection.
				// About 1 out of 3000 readings contains a 'glitch'. Detect it by
				// seeing if there is a sudden change in value compared to the
				// previous reading. If so, re-read the data one time.

				bool glitch = false;
				if (m>0)
				{
					if( abs(trace1[m]-trace1[m-1]) > 100) glitch = true;
					if( abs(trace2[m]-trace2[m-1]) > 100) glitch = true;
					if( abs(trace3[m]-trace3[m-1]) > 100) glitch = true;
					if( abs(trace4[m]-trace4[m-1]) > 100) glitch = true;
					if( abs(trace6[m]-trace6[m-1]) > 100) glitch = true;
					if( abs(trace7[m]-trace7[m-1]) > 100) glitch = true;
					if( abs(trace8[m]-trace8[m-1]) > 100) glitch = true;
					if( abs(trace9[m]-trace9[m-1]) > 100) glitch = true;

					if(glitch)
					{
						TxBuf->TxAccum = FG->DDS(FG->Frequency(m));

						VNA->WriteRead(TxBuf, RxBuf);

						// Save received data by grid point

						trace1[m] = RxBuf->ReflMI;
						trace2[m] = RxBuf->ReflMQ;
						trace3[m] = RxBuf->ReflPI;
						trace4[m] = RxBuf->ReflPQ;

						trace5[m] = RxBuf->Vref1;

						trace6[m] = RxBuf->TranMI;
						trace7[m] = RxBuf->TranMQ;
						trace8[m] = RxBuf->TranPI;
						trace9[m] = RxBuf->TranPQ;

						trace10[m] = RxBuf->Vref2;
					}
				}
			}

			Refresh();		// Force a redraw of the screen		
		}

private: System::Void calCheckBox_CheckedChanged(System::Object *  sender, System::EventArgs *  e)
		 {
			Refresh();	// Force Screen redraw
		 }

private: System::Void EtTrace_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 if (EtTrace->Checked == false)
				 EtTrace->Checked = true;
			 else
				 EtTrace->Checked = false;
			 
			 Refresh();
		 }

private: System::Void EsTrace_Click(System::Object *  sender, System::EventArgs *  e)
		 {
 			 if (EsTrace->Checked == false)
				 EsTrace->Checked = true;
			 else
				 EsTrace->Checked = false;
			
			 Refresh();
		 }

private: System::Void EdTrace_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 if (EdTrace->Checked == false)
				 EdTrace->Checked = true;
			 else
				 EdTrace->Checked = false;
			 
			 Refresh();
		 }
private: System::Void calSshort_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 if (calSshort->Checked == false)
				 calSshort->Checked = true;
			 else
				 calSshort->Checked = false;
			 
			 Refresh();
		 }

private: System::Void calSopen_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 if (calSopen->Checked == false)
				 calSopen->Checked = true;
			 else
				 calSopen->Checked = false;
			 
			 Refresh();
		 }

private: System::Void calSterm_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 if (calSterm->Checked == false)
				 calSterm->Checked = true;
			 else
				 calSterm->Checked = false;
			 
			 Refresh();
		 }

private: System::Void Scale10dB_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			Scale1dB->Checked = false;
			Scale5dB->Checked = false;
			Scale2dB->Checked = false;
			Scale10dB->Checked = true;
			RectVertScaledB = 10;
			Refresh();
		 }

private: System::Void Scale5dB_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			Scale10dB->Checked = false;
			Scale2dB->Checked = false;
			Scale1dB->Checked = false;
			Scale5dB->Checked = true;
			RectVertScaledB = 5;
			Refresh();
		 }

private: System::Void Scale2dB_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			Scale10dB->Checked = false;
			Scale5dB->Checked = false;
			Scale1dB->Checked = false;
			Scale2dB->Checked = true;
			RectVertScaledB = 2;
			Refresh();
		 }

private: System::Void Scale1dB_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			Scale10dB->Checked = false;
			Scale5dB->Checked = false;
			Scale2dB->Checked = false;
			Scale1dB->Checked = true;
			RectVertScaledB = 1;
			Refresh();
		 }

private: System::Void scalemicroSec_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 scale100psec->Checked = false;
			 scalenanoSec->Checked = false;
			 scale10nsec->Checked = false;
			 scale100nsec->Checked = false;
			 scalemicroSec->Checked = true;
			 scale10microsec->Checked = false;
			 Refresh();
		 }
private: System::Void scalenanoSec_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 scale100psec->Checked = false;
			 scalenanoSec->Checked = true;
			 scale10nsec->Checked = false;
			 scale100nsec->Checked = false;
			 scalemicroSec->Checked = false;
			 scale10microsec->Checked = false;
			 Refresh();
		 }
private: System::Void scale100psec_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 scale100psec->Checked = true;
			 scalenanoSec->Checked = false;
			 scale10nsec->Checked = false;
			 scale100nsec->Checked = false;
			 scalemicroSec->Checked = false;
			 scale10microsec->Checked = false;
			 Refresh();
		 }

private: System::Void scale10nsec_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 scale100psec->Checked = false;
			 scalenanoSec->Checked = false;
			 scale10nsec->Checked = true;
			 scale100nsec->Checked = false;
			 scalemicroSec->Checked = false;
			 scale10microsec->Checked = false;
             Refresh();
		 }

private: System::Void scale100nsec_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 scale100psec->Checked = false;
			 scalenanoSec->Checked = false;
			 scale10nsec->Checked = false;
			 scale100nsec->Checked = true;
			 scalemicroSec->Checked = false;
			 scale10microsec->Checked = false;
			 Refresh();
		 }

private: System::Void scale10microsec_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 scale100psec->Checked = false;
			 scalenanoSec->Checked = false;
			 scale10nsec->Checked = false;
			 scale100nsec->Checked = false;
			 scalemicroSec->Checked = false;
			 scale10microsec->Checked = true;
			 Refresh();
		 }
private: System::Void calSthru_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 if (calSthru->Checked == false)
				 calSthru->Checked = true;
			 else
				 calSthru->Checked = false;
			 
			 Refresh();
		 }
private: System::Void grid101menu_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 grid101menu->Checked = true;
			 grid201menu->Checked = false;
			 grid401menu->Checked = false;
			 grid1024menu->Checked = false;
			 int start = FG->StartF;
			 int stop = FG->StopF;
			 FG = new FrequencyGrid(101);	// Grid containing 101 frequencies
			 FG->SetStartF(start);			// pick up previous values for start
			 FG->SetStopF(stop);			// and stop
		 }

private: System::Void grid201menu_Click(System::Object *  sender, System::EventArgs *  e)
		 {			 
			 grid101menu->Checked = false;
			 grid201menu->Checked = true;
			 grid401menu->Checked = false;
			 grid1024menu->Checked = false;
			 int start = FG->StartF;
			 int stop = FG->StopF;
			 FG = new FrequencyGrid(201);	// Grid containing 201 frequencies
			 FG->SetStartF(start);			// pick up previous values for start
			 FG->SetStopF(stop);			// and stop
		 }

private: System::Void grid401menu_Click(System::Object *  sender, System::EventArgs *  e)
		 {			 
			 grid101menu->Checked = false;
			 grid201menu->Checked = false;
			 grid401menu->Checked = true;
			 grid1024menu->Checked = false;
			 int start = FG->StartF;
			 int stop = FG->StopF;
			 FG = new FrequencyGrid(401);	// Grid containing 401 frequencies
			 FG->SetStartF(start);			// pick up previous values for start
			 FG->SetStopF(stop);			// and stop
		 }

private: System::Void grid1024menu_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 grid101menu->Checked = false;
			 grid201menu->Checked = false;
			 grid401menu->Checked = false;
			 grid1024menu->Checked = true;
			 int start = FG->StartF;
			 int stop = FG->StopF;
			 FG = new FrequencyGrid(1024);	// Grid containing 1024 frequencies
			 FG->SetStartF(start);			// pick up previous values for start
			 FG->SetStopF(stop);			// and stop
		 }

private: System::Void instrumentCalItem_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			InstrumentCal * Ical = new InstrumentCal(CalData, VNA, StartUpPath);
			Ical->ShowDialog();
		 }

private: System::Void HelpMenuItem_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 Help::ShowHelp(this, String::Concat(StartUpPath, S"\\VNAR2 Help.chm"));
		 }

private: System::Void AboutMenuItem_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 Assembly * _assembly;
			 _assembly = Assembly::GetExecutingAssembly();
			 //MessageBox::Show(_assembly->ToString(),S"TAPR VNA Host Program");

			 About * AboutBox = new About(_assembly->ToString());
			 AboutBox->ShowDialog();
		 }
private: System::Void ChangeMarker_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 MarkerEntry * Mkr = new MarkerEntry(Marker);	// preload markers into dialog box
			 if (Mkr->ShowDialog() == DialogResult::OK)
				 for (int i=0; i<5; i++)
					 Marker[i] = Mkr->Marker[i];			// retrieve updated markers
			 Refresh();
		 }

private: System::Void ExportRectFmt_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 if (!storeForward->Checked)
			 {
				 MessageBox::Show(S"No Forward parameters stored. Cannot generate file",S"Error",
					 MessageBoxButtons::OK, MessageBoxIcon::Error);
				return;
			 }
			 if (!storeReverse->Checked)
			 {
				 MessageBox::Show(S"No Reverse parameters stored. Cannot generate file",S"Error",
					 MessageBoxButtons::OK, MessageBoxIcon::Error);
				return;
			 }
			 storeForward->Checked = false;
			 storeReverse->Checked = false;

			 ExportSParams(0, FG,
				 stS11Mag, stS11Phs, stS21Mag, stS21Phs,
				 stS22Mag, stS22Phs, stS12Mag, stS12Phs);	//Rectangular Mode
		 }

private: System::Void ExportPolarFmt_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 if (!storeForward->Checked)
			 {
				MessageBox::Show(S"No Forward parameters stored. Cannot generate file",S"Error",
					MessageBoxButtons::OK, MessageBoxIcon::Error);
				return;
			 }
			 if (!storeReverse->Checked)
			 {
				MessageBox::Show(S"No Reverse parameters stored. Cannot generate file",S"Error",
					MessageBoxButtons::OK, MessageBoxIcon::Error);
				return;
			 }
			 storeForward->Checked = false;
			 storeReverse->Checked = false;

			 ExportSParams(1, FG,
				 stS11Mag, stS11Phs, stS21Mag, stS21Phs,
				 stS22Mag, stS22Phs, stS12Mag, stS12Phs);	//Polar Mode
		 }

private: System::Void MarkerNumEnable_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 ShowMarkerNumbers = 1;
			 Refresh();
		 }

private: System::Void MarkerNumDisable_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 ShowMarkerNumbers = 0;
			 Refresh();
		 }

private: System::Void DrawMarkers(Graphics * gr, Pen * pen, Brush * brush, Point p,
			 System::Drawing::Font * mfont, int index)
		 {
			 for (int j=0; j<5; j++)						// five markers
				{
					if(FG->GridPoint(Marker[j]) == index)	// If this is a marker display point
					{										// draw marker
						String * text; text = Convert::ToString(j+1);
						Point ul(p.X - 5, p.Y - 10);		// upper left corner of marker triangle
						Point ur(p.X + 5, p.Y - 10);		// upper right corner of marker triangle
						Point tx(p.X - 4, p.Y - 22);		// position where number is drawn
						gr->DrawLine(pen, p, ul);
						gr->DrawLine(pen, ul, ur);
						gr->DrawLine(pen, ur, p);
						if (ShowMarkerNumbers)
                            gr->DrawString(text, mfont, brush, tx);
					}
				}
		 }

private: System::Void storeForward_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 if (storeForward->Checked)
			 {
				MessageBox::Show(S"Forward Parameter Storage in use.\nExport Parameters to clear storage",S"Error");
				return;
			 }
			 storeForward->Checked = true;
			 StoreSParams(calCheckBox->Checked, FG, CalData, trace2, trace3,
				 trace4, trace7, trace8, trace9, stS11Mag, stS11Phs, stS21Mag, stS21Phs);	//Forward Params
		 }

private: System::Void storeReverse_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 if (storeReverse->Checked)
			 {
				MessageBox::Show(S"Reverse Parameter Storage in use.\nExport Parameters to clear storage",S"Error");
				return;
			 }
			 storeReverse->Checked = true;
			 StoreSParams(calCheckBox->Checked, FG, CalData, trace2, trace3,
				 trace4, trace7, trace8, trace9, stS22Mag, stS22Phs, stS12Mag, stS12Phs);	//Reverse Params
		 }

};

}
