//
//    Copyright 2004, Thomas C. McDermott, N5EG
//    This file is part of VNAR - the Vector Network Analyzer program.
//
//    VNAR is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    VNAR is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with VNAR, if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

#pragma once

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Windows::Forms;
using namespace System::Data;
using namespace System::Drawing;


namespace VNAR2
{
	/// <summary> 
	/// Summary for NumEntBox
	///
	/// WARNING: If you change the name of this class, you will need to change the 
	///          'Resource File Name' property for the managed resource compiler tool 
	///          associated with all .resx files this class depends on.  Otherwise,
	///          the designers will not be able to interact properly with localized
	///          resources associated with this form.
	/// </summary>
	public __gc class NumEntBox : public System::Windows::Forms::Form
	{
	public: 
		NumEntBox(void)
		{
			InitializeComponent();
		}
        
	protected: 
		void Dispose(Boolean disposing)
		{
			if (disposing && components)
			{
				components->Dispose();
			}
			__super::Dispose(disposing);
		}
	private: System::Windows::Forms::Button *  OKButton;
	private: System::Windows::Forms::Button *  CancelButton;
	private: System::Windows::Forms::TextBox *  NumberBox;
	private: System::Windows::Forms::Label *  label1;

	private:
		/// <summary>
		/// Required designer variable.
		/// </summary>
		System::ComponentModel::Container* components;

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			this->OKButton = new System::Windows::Forms::Button();
			this->CancelButton = new System::Windows::Forms::Button();
			this->NumberBox = new System::Windows::Forms::TextBox();
			this->label1 = new System::Windows::Forms::Label();
			this->SuspendLayout();
			// 
			// OKButton
			// 
			this->OKButton->DialogResult = System::Windows::Forms::DialogResult::OK;
			this->OKButton->Location = System::Drawing::Point(48, 112);
			this->OKButton->Name = S"OKButton";
			this->OKButton->TabIndex = 0;
			this->OKButton->Text = S"OK";
			// 
			// CancelButton
			// 
			this->CancelButton->DialogResult = System::Windows::Forms::DialogResult::Cancel;
			this->CancelButton->Location = System::Drawing::Point(168, 112);
			this->CancelButton->Name = S"CancelButton";
			this->CancelButton->TabIndex = 1;
			this->CancelButton->Text = S"Cancel";
			// 
			// NumberBox
			// 
			this->NumberBox->Location = System::Drawing::Point(72, 64);
			this->NumberBox->Name = S"NumberBox";
			this->NumberBox->Size = System::Drawing::Size(144, 20);
			this->NumberBox->TabIndex = 2;
			this->NumberBox->Text = S"";
			this->NumberBox->TextAlign = System::Windows::Forms::HorizontalAlignment::Right;
			// 
			// label1
			// 
			this->label1->Location = System::Drawing::Point(96, 32);
			this->label1->Name = S"label1";
			this->label1->Size = System::Drawing::Size(88, 16);
			this->label1->TabIndex = 3;
			this->label1->Text = S"Enter new value";
			// 
			// NumEntBox
			// 
			this->AcceptButton = this->OKButton;
			this->AutoScaleBaseSize = System::Drawing::Size(5, 13);
			this->CancelButton = this->CancelButton;
			this->ClientSize = System::Drawing::Size(292, 164);
			this->Controls->Add(this->label1);
			this->Controls->Add(this->NumberBox);
			this->Controls->Add(this->CancelButton);
			this->Controls->Add(this->OKButton);
			this->FormBorderStyle = System::Windows::Forms::FormBorderStyle::Fixed3D;
			this->MaximizeBox = false;
			this->MinimizeBox = false;
			this->Name = S"NumEntBox";
			this->Text = S"Direct Value Entry";
			this->ResumeLayout(false);

		}		
	
	
	// User supplied code
	public:
	    void set_NumericValue(int number)   { NumberBox->Text = number.ToString(); }
		int get_NumericValue()
    { 
        int n;
        try
        {
            n = Convert::ToInt32(NumberBox->Text);
        }
        catch (Exception* pe)
        {
            MessageBox::Show(pe->Message, "Error");
        }
        return n;
    }

	};

}