from config import *
from counter import counter
from display16ch import updateDisplay

"""
	This is intended to be the code to be used in the final board (EPM1270)
	having a 10 MHz clock.
"""

def counterMainP(clk, reset, counterSig, externalSig, modeSw, intervalSw, gate, sigSelect,
					lcdBus, E, RS, RW):

	State = enum('STATE1', 'STATE2', 'STATE3', 'STATE4', 'STATE5', 'STATE6',
				 'STATE7', 'STATE8', 'STATE9', 'STATE10', 'STATE11')
	state = Signal(State.STATE1	)
	count = Signal(intbv(0)[COUNT_WIDTH:])
	start, done, dispStart, dispDone, dispMode, counterReset = [Signal(bool(1)) for k in range(6)]
	delayCounter = Signal(intbv(0)[23:])	# 0.5 sec delay max @ 10MHz
	DELAY_HALF_SEC = int(MASTER_CLOCK_FREQUENCY * 0.5)
	currentMode = Signal(bool(0))
	currentInterval = Signal(intbv(0)[2:])

	SC = counter(counterReset, clk, counterSig, externalSig, start, done, modeSw, intervalSw, gate, sigSelect, count)
	UD = updateDisplay(clk, reset, dispStart, dispDone, dispMode, modeSw, intervalSw, count, lcdBus, E, RS, RW)


	@always(clk.negedge)
	def logic():
		if reset == ACTIVE_LOW:
			counterReset.next = ACTIVE_LOW
			state.next = State.STATE1

		if state == State.STATE1:
			if reset == INACTIVE_HIGH:
				counterReset.next = INACTIVE_HIGH
				dispMode.next = 0
				dispStart.next = ACTIVE_LOW		# initialize the lcd display
				state.next = State.STATE2

		elif state == State.STATE2:
			dispStart.next = INACTIVE_HIGH
			state.next = State.STATE3

		elif state == State.STATE3:
			if dispDone == INACTIVE_HIGH:
				dispMode.next = 1			# switch to display update mode
				state.next = State.STATE4

		elif state == State.STATE4:			# top of process loop
			start.next = ACTIVE_LOW			# start the counter
			currentMode.next = modeSw
			currentInterval.next = intervalSw
			state.next = State.STATE5

		elif state == State.STATE5:
			start.next = INACTIVE_HIGH
			state.next = State.STATE6

		elif state == State.STATE6:
			if modeSw != currentMode or intervalSw != currentInterval:
				counterReset.next = ACTIVE_LOW	# interrupt current measurement
				state.next = State.STATE7
			elif done == ACTIVE_LOW:
				state.next = State.STATE8

		elif state == State.STATE7:
			counterReset.next = INACTIVE_HIGH
			state.next = State.STATE4

		elif state == State.STATE8:
			dispStart.next = ACTIVE_LOW	# udpate the display
			state.next = State.STATE9

		elif state == State.STATE9:
			dispStart.next = INACTIVE_HIGH
			state.next = State.STATE10

		elif state == State.STATE10:
			if dispDone == ACTIVE_LOW:
				delayCounter.next = DELAY_HALF_SEC
				state.next = State.STATE11

		elif state == State.STATE11:
			if delayCounter == 0:
				state.next = State.STATE4
			else:
				delayCounter.next = delayCounter - 1
		else:
			state.next = State.STATE1
	return instances()

def syncSig(clk, pIn, pOut, nbits):
	p1 = Signal(intbv(INACTIVE_HIGH)[nbits:])
	@always(clk.negedge)
	def logic():
		p1.next = pIn
		pOut.next = p1
	return logic

def counterMain(clk, resetIn, counterSig, externalSig, modeIn, intervalIn, gate,
				sigSelect, lcdBus, E, RS, RW, indicator):

	mode, reset = [Signal(bool(INACTIVE_HIGH)) for k in range(2)]
	interval, intervalRaw = [Signal(intbv(0)[2:]) for k in range(2)]

	S1 = syncSig(clk, modeIn, mode, 1)
	S2 = syncSig(clk, intervalIn, intervalRaw, 2)
	S3 = syncSig(clk, resetIn, reset, 1)
	CMP = counterMainP(clk, reset, counterSig, externalSig, mode, interval, gate, sigSelect, lcdBus, E, RS, RW)

	@always(clk.negedge)
	def logic():
		indicator.next = ~(gate[0] | gate[1])	# control for LED (low if either gate control sig is high - gate open)
		# invert the bits. The external circuit produces values 3, 2, 1 whereas what is needed is 0, 1, 2
		interval.next = ~intervalRaw

	return instances()


def test1():
	reset, clk, mode, E, RS, RW, indicator = [Signal(bool(0)) for k in range(7)]
	counterSig, externalSig, sigSelect = [Signal(bool(0)) for k in range(3)]
	interval, gate = [Signal(intbv(0)[2:]) for k in range(2)]
	lcdBus = Signal(intbv(0)[4:])
	toVerilog(counterMain, reset, clk, counterSig, externalSig, mode, interval, gate,
				sigSelect, lcdBus, E, RS, RW, indicator)

if __name__ == "__main__":
	test1()

