//Band Pass Filter Butterworth 2nd order
//Fp1=lower band pass cutoff frequency
//Fp2=upper band pass cutorf frequency
//F0=band pass center frequency
//J.Clark Aug3rd - 2012

Fp1=10200;
wp1=2*%pi*Fp1;
Fp2=12000;
wp2=2*%pi*Fp2;
w0=(wp1*wp2)^0.5;
B=wp2-wp1;

clf()
s=poly([0],'s')
ns=1
ds=1+1.4142*s+s^2
ds=horner(ds,((s^2+wp1*wp2)/(B*s)))
hs=ns/ds
fr=0.01:10:100000;
wr=2*%pi*fr;
hf=freq(hs(2),hs(3),%i*wr);
hm=abs(hf);
plot2d1(wr,20*log10(hm),logflag='ln')
