static struct proc_dir_entry *eqep_file;
static char   eqep_data;

/**************************************
  FUNCTION:   eqep_read

  DESCRIPTION: Function that reads data from the 
               BeagleBone eQEP hardware and returns the
               data to the User Mode program

  INPUTS:      page -- the character buffer where output data
                       is written
               start -- unused
               offset -- unused
               count -- requested number (ignored)
               eof -- end of file indicator (unused)
               data -- pointer to our position in the file
                       (ignored)

  OUTPUTS:     None

  RETURNS:     Number of characters actually sent back

  NOTES:       This function is designed to read one
               byte at a time. If the system requests 
               more than one char, the rest of the data
               will indicate no rotation.

  CONTEXT:     This function will only be called from 
               Linux kernel context.

**************************************/

static int eqep_read(char *page, char **start, off_t offset,
                     int  count, int *eof, void *data)
{
long position, *position_register;
char new_data;

   // Read the hardware position register
   position_register = QPOSCNT0_REG;
   position = *position_register;
   // subtract the starting position
   position -= 0x7fffffff;
   // convert the relative position to a char
   new_data = (char)(position & 0xff);
   // store the data in the buffer
   *page = new_data;
   // reset the position value to the nominal
   *position_register = 0x7fffffff;
   // indicate we are returning just one character
   return 1;
}
/**************************************
  FUNCTION:   eqep_write

  DESCRIPTION: Function that would normally write to a file.
               In our case it does nothing.

  INPUTS:      None

  OUTPUTS:     None

  RETURNS:     Nothing

  NOTES:       None

  CONTEXT:     This function will only be called from 
               the Linux kernel.

**************************************/

static void eqep_write(struct file *file, const char *buffer,
                       unsigned long count, void *data)
{

  // do nothing and return
  return 0;
}
