/* main program for GPS frequency disciplined DDS
 */

#include "GPSReference.h"			// our glue

#define	INITIAL_FREQ	7000000UL		// initial user freq, Hz

DDSControl *dds;
Display *dpy;
GPS *gps;
Encoder *enc;

void setup()
{
    // init debug (hardware) serial line
    Serial.begin (115200);
    Serial.println (F("GPS Reference"));

    // init I2C
    Wire.begin();

    // init modules
    dds = new DDSControl(INITIAL_FREQ);
    dpy = new Display();
    gps = new GPS();
    enc = new Encoder();

    // start measuring
    dpy->drawMessage("Initializing ...");
    dds->startMeasurement(true);
}

void loop()
{
    // update DDS calibration
    dds->update();

    // check for and display new user frequency
    dpy->userFreq();

    // update GPS serial info
    gps->parse();
}
