#ifndef _ENCODER_H
#define _ENCODER_H

#include <stdint.h>

class Encoder
{
    private:

	uint8_t prev_a, prev_b;			// persistent previous pin state
	uint32_t a_last_ms;			// millis() when edge detected
	volatile int32_t enc_value;		// reported position
	volatile bool new_value_ready;		// new enc_value ready for getValue()
	uint8_t enc_history;			// 2-bit 3-element pin history

	void gearBox (uint8_t b, uint32_t dt);

    public:

	Encoder ();
	bool getValue (int32_t &new_value);
	void setValue (int32_t n_v);
	void onEncPinChange(void);
	bool switchPushed();
};

#endif // _ENCODER_H
